/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.data;

import fuzs.puzzleslib.api.data.v1.AbstractModelProvider;
import fuzs.stoneworks.world.block.variant.BlockVariant;
import fuzs.stoneworks.world.block.variant.StoneBlockVariant;
import fuzs.stoneworks.world.block.variant.StoneVariantsProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModModelProvider
extends AbstractModelProvider {
    public ModModelProvider(PackOutput packOutput, String modId, ExistingFileHelper fileHelper) {
        super(packOutput, modId, fileHelper);
    }

    protected void registerStatesAndModels() {
        for (StoneBlockVariant variant : StoneVariantsProvider.getStoneBlockVariants().toList()) {
            if (variant.blockVariant() == BlockVariant.PILLAR) {
                this.axisBlock((RotatedPillarBlock)variant.block(), this.blockTexture(variant.name() + "_side"), this.blockTexture(variant.name() + "_top"));
                this.simpleBlockItem(variant.block(), variant.name());
                continue;
            }
            ResourceLocation texture = this.blockTexture(variant.name());
            if (variant.blockVariant() == BlockVariant.CHISELED && variant.stoneType().hasChiseledMotif()) {
                StoneBlockVariant polishedVariant = StoneVariantsProvider.getStoneVariant(variant.stoneType(), BlockVariant.POLISHED);
                this.simpleColumnBlock(variant.block(), texture, this.blockTexture(polishedVariant.id(polishedVariant.name())));
            } else {
                this.simpleBlock(variant.block());
            }
            this.simpleBlockItem(variant.block(), variant.name());
            if (!variant.blockVariant().supportsAdditionalBlocks()) continue;
            this.stairsBlock((StairBlock)variant.stairs(), texture);
            this.itemModels().stairs(variant.stairsName(), texture, texture, texture);
            this.slabBlock((SlabBlock)variant.slab(), texture, texture);
            this.itemModels().slab(variant.slabName(), texture, texture, texture);
            this.wallBlock((WallBlock)variant.wall(), texture);
            this.itemModels().wallInventory(variant.wallName(), texture);
        }
    }

    public void simpleColumnBlock(Block block, ResourceLocation side, ResourceLocation end) {
        this.simpleBlock(block, (ModelFile)this.models().cubeColumn(this.name(block), side, end));
    }

    private ResourceLocation blockTexture(String block) {
        return this.modLoc("block/" + block);
    }

    private ResourceLocation blockTexture(ResourceLocation id) {
        return new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_());
    }

    private void simpleBlockItem(Block block, String name) {
        this.simpleBlockItem(block, (ModelFile)this.models().getExistingFile(this.modLoc(name)));
    }
}

