/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummonRitualRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final Ingredient catalyst;
    public final MobSource mobSource;
    public final int count;
    public ArrayList<WeightedMobType> mobs;
    public final List<WeightedMobType> mobTypes = new ArrayList<WeightedMobType>();

    public SummonRitualRecipe(ResourceLocation id, Ingredient catalyst, MobSource source, int count, ArrayList<WeightedMobType> mobs) {
        this.id = id;
        this.catalyst = catalyst;
        this.mobSource = source;
        this.count = count;
        this.mobs = mobs;
    }

    public SummonRitualRecipe(ResourceLocation id, Ingredient catalyst, MobSource source, int count) {
        this.id = id;
        this.catalyst = catalyst;
        this.mobSource = source;
        this.count = count;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return false;
    }

    public boolean matches(List<ItemStack> augments) {
        return EnchantingApparatusRecipe.doItemsMatch(augments, Arrays.stream(this.catalyst.m_43908_()).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).toList());
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.SUMMON_RITUAL_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeRegistry.SUMMON_RITUAL_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_nouveau:summon_ritual");
        JsonArray mobs = new JsonArray();
        this.mobs.forEach(mob -> mobs.add((JsonElement)mob.toJson()));
        jsonobject.add("mobs", (JsonElement)mobs);
        jsonobject.addProperty("source", this.mobSource.toString());
        jsonobject.addProperty("count", (Number)this.count);
        jsonobject.add("augment", this.catalyst.m_43942_());
        return jsonobject;
    }

    public static enum MobSource {
        CURRENT_BIOME,
        MOB_LIST;

    }

    public record WeightedMobType(ResourceLocation mob, int weight) implements WeightedEntry
    {
        public WeightedMobType(ResourceLocation mob) {
            this(mob, 1);
        }

        public JsonObject toJson() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("mob", this.mob.toString());
            jsonobject.addProperty("weight", (Number)this.weight);
            return jsonobject;
        }

        public static WeightedMobType fromJson(JsonObject json) {
            return new WeightedMobType(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"mob")), GsonHelper.m_13927_((JsonObject)json, (String)"weight"));
        }

        @NotNull
        public Weight m_142631_() {
            return Weight.m_146282_((int)this.weight);
        }

        public static class Reader
        implements FriendlyByteBuf.Reader<WeightedMobType> {
            public WeightedMobType apply(FriendlyByteBuf friendlyByteBuf) {
                return new WeightedMobType(friendlyByteBuf.m_130281_(), friendlyByteBuf.readInt());
            }
        }

        public static class Writer
        implements FriendlyByteBuf.Writer<WeightedMobType> {
            public void accept(FriendlyByteBuf friendlyByteBuf, WeightedMobType weightedMobType) {
                friendlyByteBuf.m_130085_(weightedMobType.mob);
                friendlyByteBuf.writeInt(weightedMobType.weight);
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<SummonRitualRecipe> {
        public SummonRitualRecipe fromJson(ResourceLocation pRecipeId, JsonObject json) {
            Ingredient augment = Ingredient.m_43917_((JsonElement)(GsonHelper.m_13885_((JsonObject)json, (String)"augment") ? GsonHelper.m_13933_((JsonObject)json, (String)"augment") : GsonHelper.m_13930_((JsonObject)json, (String)"augment")));
            MobSource source = MobSource.valueOf(GsonHelper.m_13851_((JsonObject)json, (String)"source", (String)"MOB_LIST"));
            ArrayList<WeightedMobType> mobs = new ArrayList<WeightedMobType>();
            if (json.has("mob")) {
                mobs.add(new WeightedMobType(ResourceLocation.m_135820_((String)json.get("mob").getAsString())));
            }
            if (json.has("mobs")) {
                GsonHelper.m_13933_((JsonObject)json, (String)"mobs").forEach(el -> mobs.add(WeightedMobType.fromJson(el.getAsJsonObject())));
            }
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new SummonRitualRecipe(pRecipeId, augment, source, count, mobs);
        }

        @Nullable
        public SummonRitualRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient catalyst = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            MobSource source = (MobSource)pBuffer.m_130066_(MobSource.class);
            int count = pBuffer.readInt();
            ArrayList mobs = (ArrayList)pBuffer.m_236838_(Lists::newArrayListWithCapacity, (FriendlyByteBuf.Reader)new WeightedMobType.Reader());
            return new SummonRitualRecipe(pRecipeId, catalyst, source, count, mobs);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, SummonRitualRecipe pRecipe) {
            pRecipe.catalyst.m_43923_(pBuffer);
            pBuffer.m_130068_((Enum)pRecipe.mobSource);
            pBuffer.writeInt(pRecipe.count);
            pBuffer.m_236828_(pRecipe.mobs, (FriendlyByteBuf.Writer)new WeightedMobType.Writer());
        }
    }
}

