/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.client.gui.buttons.ANButton;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

@OnlyIn(value=Dist.CLIENT)
public class UnlockGlyphButton
extends ANButton {
    public boolean isCraftingSlot;
    public AbstractSpellPart spellPart;
    public String tooltip = "";
    public GlyphRecipe recipe;
    public boolean playerKnows;
    public boolean selected;

    public UnlockGlyphButton(int x, int y, boolean isCraftingSlot, AbstractSpellPart spellPart, Button.OnPress onPress) {
        super(x, y, 16, 16, onPress);
        this.isCraftingSlot = isCraftingSlot;
        this.spellPart = spellPart;
        Recipe recipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(spellPart.getRegistryName()).orElse(null);
        this.recipe = recipe instanceof GlyphRecipe ? (GlyphRecipe)recipe : null;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_ && this.spellPart != null) {
            RenderUtils.drawSpellPart(this.spellPart, graphics, this.f_93620_, this.f_93621_, this.f_93618_, !this.playerKnows, 0);
            if (this.selected) {
                graphics.m_280163_(new ResourceLocation("ars_nouveau", "textures/gui/glyph_selected.png"), this.f_93620_, this.f_93621_, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }

    @Override
    public void getTooltip(List<Component> tip) {
        if (this.spellPart == null) {
            return;
        }
        AbstractSpellPart spellPart = this.spellPart;
        tip.add((Component)Component.m_237115_((String)spellPart.getLocalizationKey()));
        if (Screen.m_96638_()) {
            tip.add(spellPart.getBookDescLang());
        } else {
            tip.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{spellPart.getConfigTier().value}).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)));
            tip.add((Component)Component.m_237110_((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84875_()}));
            String modName = ModList.get().getModContainerById(spellPart.getRegistryName().m_135827_()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(spellPart.getRegistryName().m_135827_());
            tip.add((Component)Component.m_237113_((String)modName).m_130940_(ChatFormatting.BLUE));
        }
    }
}

