/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class RainbowParticleColor
extends ParticleColor {
    public static final ResourceLocation ID = new ResourceLocation("ars_nouveau", "rainbow");
    public final int tickOffset;
    public int transitionSpeed;

    public RainbowParticleColor(int r, int g, int b) {
        super(r, g, b);
        this.tickOffset = random.nextInt(1536);
    }

    public RainbowParticleColor(int r, int g, int b, int transitionSpeed) {
        this(r, g, b);
        this.transitionSpeed = transitionSpeed;
    }

    public RainbowParticleColor(CompoundTag compoundTag) {
        super(compoundTag);
        this.tickOffset = compoundTag.m_128451_("tickOffset");
        this.transitionSpeed = compoundTag.m_128451_("transitionSpeed");
    }

    @Override
    public ParticleColor transition(int ticks) {
        return Color.rainbowColor(ticks).toParticle();
    }

    @Override
    public float getRed() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getRedAsFloat();
    }

    @Override
    public int getRedInt() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getRed();
    }

    @Override
    public float getBlue() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getBlueAsFloat();
    }

    @Override
    public int getBlueInt() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getBlue();
    }

    @Override
    public int getGreenInt() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getGreen();
    }

    @Override
    public float getGreen() {
        return Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getGreenAsFloat();
    }

    @Override
    public int getColor() {
        return RainbowParticleColor.fromInt(Color.rainbowColor(this.tickOffset + ClientInfo.ticksInGame).getRGB()).getColor();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ID;
    }
}

