/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class StarbuncleModel
extends GeoModel<Starbuncle> {
    public void setCustomAnimations(Starbuncle entity, long uniqueID, @Nullable AnimationState customPredicate) {
        super.setCustomAnimations((GeoAnimatable)entity, uniqueID, customPredicate);
        if (entity.partyCarby) {
            return;
        }
        if (customPredicate == null) {
            return;
        }
        ((GeoBone)this.getBone("basket").get()).setHidden(!entity.isTamed());
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraData().get(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
    }

    public ResourceLocation getModelResource(Starbuncle carbuncle) {
        if (carbuncle.m_7755_().getString().equals("Gootastic")) {
            return new ResourceLocation("ars_nouveau", "geo/goobuncle.geo.json");
        }
        return new ResourceLocation("ars_nouveau", "geo/starbuncle.geo.json");
    }

    public ResourceLocation getTextureResource(Starbuncle carbuncle) {
        return carbuncle.getTexture(carbuncle);
    }

    public ResourceLocation getAnimationResource(Starbuncle carbuncle) {
        return new ResourceLocation("ars_nouveau", "animations/starbuncle_animations.json");
    }
}

