/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ArsGeoBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;

public class ScribesRenderer
extends ArsGeoBlockRenderer<ScribesTile> {
    public static GeoModel model = new GenericModel("scribes_table");

    public ScribesRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn, model);
    }

    public void preRender(PoseStack stack, ScribesTile tile, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (tile.m_58904_().m_8055_(tile.m_58899_()).m_60734_() != BlockRegistry.SCRIBES_BLOCK.get()) {
            return;
        }
        if (tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)ScribesBlock.PART) != ThreePartBlock.HEAD) {
            return;
        }
        stack.m_85836_();
        Direction direction = (Direction)tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)ScribesBlock.FACING);
        if (direction == Direction.NORTH) {
            stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            stack.m_252880_(1.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.SOUTH) {
            stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            stack.m_252880_(-1.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.WEST) {
            stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            stack.m_252880_(0.0f, 0.0f, -2.0f);
        }
        if (direction == Direction.EAST) {
            stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            stack.m_252880_(0.0f, 0.0f, 0.0f);
        }
        super.preRender(stack, (BlockEntity)tile, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        stack.m_85849_();
    }

    @Override
    public void actuallyRender(PoseStack stack, ScribesTile tile, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (tile.m_58904_().m_8055_(tile.m_58899_()).m_60734_() != BlockRegistry.SCRIBES_BLOCK.get()) {
            return;
        }
        if (tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)ScribesBlock.PART) != ThreePartBlock.HEAD) {
            return;
        }
        Direction direction = (Direction)tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)ScribesBlock.FACING);
        stack.m_85836_();
        if (direction == Direction.NORTH) {
            stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            stack.m_252880_(1.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.SOUTH) {
            stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            stack.m_252880_(-1.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.WEST) {
            stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
            stack.m_252880_(0.0f, 0.0f, -2.0f);
        }
        if (direction == Direction.EAST) {
            stack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            stack.m_252880_(0.0f, 0.0f, 0.0f);
        }
        super.actuallyRender(stack, tile, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        stack.m_85849_();
    }

    public void renderFinal(PoseStack stack, ScribesTile tile, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (tile.m_58904_().m_8055_(tile.m_58899_()).m_60734_() != BlockRegistry.SCRIBES_BLOCK.get()) {
            return;
        }
        if (tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)ScribesBlock.PART) != ThreePartBlock.HEAD) {
            return;
        }
        this.renderPressedItem(tile, tile.crafting ? (tile.craftingTicks < 40 ? tile.recipe.output.m_41720_().m_7968_() : ItemsRegistry.BLANK_GLYPH.get().m_7968_()) : tile.getStack(), stack, bufferSource, packedLight, packedOverlay, (float)ClientInfo.ticksInGame + partialTick);
    }

    public void renderPressedItem(ScribesTile tile, ItemStack itemToRender, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int packedLight, int packedOverlay, float partialTicks) {
        Direction direction = (Direction)tile.m_58904_().m_8055_(tile.m_58899_()).m_61143_((Property)ScribesBlock.FACING);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 1.0, 0.0);
        BlockState state = tile.m_58904_().m_8055_(tile.m_58899_());
        if (!(state.m_60734_() instanceof ScribesBlock)) {
            return;
        }
        Quaternionf quat = Axis.f_252403_.m_252977_(90.0f);
        Vec3 translationOffset = new Vec3(0.0, 0.0, 0.0);
        if (direction == Direction.WEST) {
            matrixStack.m_252880_(1.0f, 0.0f, 0.5f);
            quat = Axis.f_252403_.m_252977_(90.0f);
            translationOffset = new Vec3(1.0, 0.0, 0.5);
        }
        if (direction == Direction.EAST) {
            matrixStack.m_252880_(0.0f, 0.0f, 0.5f);
            quat = Axis.f_252403_.m_252977_(180.0f);
            translationOffset = new Vec3(0.0, 0.0, 0.5);
        }
        if (direction == Direction.SOUTH) {
            matrixStack.m_252880_(0.5f, 0.0f, 0.0f);
            quat = Axis.f_252403_.m_252977_(180.0f);
            translationOffset = new Vec3(0.5, 0.0, 0.0);
        }
        if (direction == Direction.NORTH) {
            matrixStack.m_252880_(0.5f, 0.0f, 1.0f);
            quat = Axis.f_252403_.m_252977_(90.0f);
            translationOffset = new Vec3(0.5, 0.0, 1.0);
        }
        float y = ((Direction)state.m_61143_((Property)ScribesBlock.FACING)).m_122427_().m_122435_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-y + 90.0f));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        matrixStack.m_252781_(quat);
        matrixStack.m_85841_(0.6f, 0.6f, 0.3f);
        Minecraft.m_91087_().m_91291_().m_269128_(itemToRender, ItemDisplayContext.FIXED, packedLight, packedOverlay, matrixStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), tile.m_58904_(), (int)tile.m_58899_().m_121878_());
        matrixStack.m_85849_();
        if (tile.recipe != null && !tile.crafting) {
            List<Ingredient> inputs = tile.getRemainingRequired();
            float ticks = partialTicks + (float)ClientInfo.ticksInGame;
            float angleBetweenEach = 360.0f / (float)inputs.size();
            Vec3 distanceVec = new Vec3(1.0, -0.5, 1.0);
            for (int i = 0; i < inputs.size(); ++i) {
                Ingredient ingredient = inputs.get(i);
                ItemStack stack = ingredient.m_43908_()[ClientInfo.ticksInGame / 20 % ingredient.m_43908_().length];
                matrixStack.m_85836_();
                matrixStack.m_252880_(0.0f, 2.0f, 0.0f);
                matrixStack.m_85837_(translationOffset.f_82479_, translationOffset.f_82480_, translationOffset.f_82481_);
                matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(ticks + (float)i * angleBetweenEach));
                matrixStack.m_85837_(distanceVec.m_7096_(), distanceVec.m_7098_() + (double)((float)(i % 2 == 0 ? -i : i) * Mth.m_14031_((float)(ticks / 60.0f))) * 0.0625, distanceVec.m_7094_());
                matrixStack.m_252781_((i % 2 == 0 ? Axis.f_252403_ : Axis.f_252529_).m_252977_(ticks));
                Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, matrixStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), tile.m_58904_(), (int)tile.m_58899_().m_121878_());
                matrixStack.m_85849_();
            }
        }
    }

    public static GenericItemBlockRenderer getISTER() {
        return new GenericItemBlockRenderer(model);
    }

    public RenderType getRenderType(ScribesTile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }
}

