/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.capability;

import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.familiar.IFamiliar;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.common.lib.LibEntityNames;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class FamiliarData {
    public static final String ENTITY_TAG = "entityTag";
    public static final String FAMILIAR_ID = "familiarID";
    public AbstractFamiliarHolder familiarHolder;
    public CompoundTag entityTag;

    public FamiliarData(ResourceLocation entityID) {
        this.familiarHolder = FamiliarRegistry.getFamiliarHolderMap().get(entityID);
        this.entityTag = new CompoundTag();
    }

    public FamiliarData(CompoundTag tag) {
        this.entityTag = tag.m_128441_(ENTITY_TAG) ? tag.m_128469_(ENTITY_TAG) : new CompoundTag();
        this.familiarHolder = FamiliarRegistry.getFamiliarHolderMap().getOrDefault(new ResourceLocation(tag.m_128461_(FAMILIAR_ID)), FamiliarRegistry.getFamiliarHolderMap().get(new ResourceLocation("ars_nouveau", LibEntityNames.FAMILIAR_WIXIE)));
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(FAMILIAR_ID, this.familiarHolder.getRegistryName().toString());
        tag.m_128365_(ENTITY_TAG, (Tag)this.entityTag);
        return tag;
    }

    public IFamiliar getEntity(Level level) {
        IFamiliar familiar = this.familiarHolder.getSummonEntity(level, this.entityTag);
        familiar.setHolderID(this.familiarHolder.getRegistryName());
        return familiar;
    }
}

