/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hollingsworth.arsnouveau.common.block.AlterationTable;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.lib.LibBlockNames;
import com.hollingsworth.arsnouveau.common.util.RegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class DefaultTableProvider
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public DefaultTableProvider(PackOutput pOutput) {
        super(pOutput, new HashSet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(EntityLootTable::new, LootContextParamSets.f_81415_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    public static class EntityLootTable
    extends EntityLootSubProvider {
        private final Map<EntityType<?>, Map<ResourceLocation, LootTable.Builder>> map = Maps.newHashMap();

        protected EntityLootTable() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_((EntityType)ModEntities.WILDEN_STALKER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsRegistry.WILDEN_WING.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)ModEntities.WILDEN_GUARDIAN.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsRegistry.WILDEN_SPIKE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)ModEntities.WILDEN_HUNTER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsRegistry.WILDEN_HORN.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
        }

        protected void m_245309_(EntityType<?> pEntityType, LootTable.Builder pBuilder) {
            super.m_245309_(pEntityType, pBuilder);
            this.map.put(pEntityType, (Map<ResourceLocation, LootTable.Builder>)ImmutableMap.of((Object)pEntityType.m_20677_(), (Object)pBuilder));
        }

        protected void m_247520_(EntityType<?> pEntityType, ResourceLocation pLootTableLocation, LootTable.Builder pBuilder) {
            super.m_247520_(pEntityType, pLootTableLocation, pBuilder);
            this.map.computeIfAbsent(pEntityType, p_249004_ -> Maps.newHashMap()).put(pLootTableLocation, pBuilder);
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> p_251751_) {
            this.m_246942_();
            HashSet set = Sets.newHashSet();
            this.getKnownEntityTypes().map(EntityType::m_204041_).forEach(p_249003_ -> {
                EntityType entitytype = (EntityType)p_249003_.m_203334_();
                if (this.m_245552_(entitytype)) {
                    Map<ResourceLocation, LootTable.Builder> map = this.map.remove(entitytype);
                    ResourceLocation resourcelocation = entitytype.m_20677_();
                    if (map != null) {
                        map.forEach((p_250376_, p_250972_) -> {
                            if (!set.add(p_250376_)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", p_250376_, p_249003_.m_205785_().m_135782_()));
                            }
                            p_251751_.accept((ResourceLocation)p_250376_, (LootTable.Builder)p_250972_);
                        });
                    }
                } else {
                    Map<ResourceLocation, LootTable.Builder> map1 = this.map.remove(entitytype);
                    if (map1 != null) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", map1.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(",")), p_249003_.m_205785_().m_135782_()));
                    }
                }
            });
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(block -> ForgeRegistries.ENTITY_TYPES.getKey(block).m_135827_().equals("ars_nouveau")).toList().stream();
        }
    }

    public static class BlockLootTable
    extends BlockLootSubProvider {
        public List<Block> list = new ArrayList<Block>();

        protected BlockLootTable() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_(), new HashMap());
        }

        protected void m_245660_() {
            this.registerDropSelf(BlockRegistry.ENCHANTED_SPELL_TURRET);
            this.registerDropSelf(BlockRegistry.BLAZING_LOG);
            this.registerDropSelf(BlockRegistry.VEXING_LOG);
            this.registerDropSelf(BlockRegistry.CASCADING_LOG);
            this.registerDropSelf(BlockRegistry.FLOURISHING_LOG);
            this.registerDropSelf(BlockRegistry.BLAZING_SAPLING);
            this.registerDropSelf(BlockRegistry.VEXING_SAPLING);
            this.registerDropSelf(BlockRegistry.CASCADING_SAPLING);
            this.registerDropSelf(BlockRegistry.FLOURISHING_SAPLING);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_PLANK);
            this.registerDrop(BlockRegistry.WIXIE_CAULDRON.get(), (ItemLike)Items.f_42544_);
            for (FlowerPotBlock pot : BlockRegistry.flowerPots.values()) {
                this.list.add((Block)pot);
                this.m_246535_((Block)pot);
            }
            this.registerLeavesAndSticks((Block)BlockRegistry.BLAZING_LEAVES.get(), (Block)BlockRegistry.BLAZING_SAPLING.get());
            this.registerLeavesAndSticks((Block)BlockRegistry.CASCADING_LEAVE.get(), (Block)BlockRegistry.CASCADING_SAPLING.get());
            this.registerLeavesAndSticks((Block)BlockRegistry.FLOURISHING_LEAVES.get(), (Block)BlockRegistry.FLOURISHING_SAPLING.get());
            this.registerLeavesAndSticks((Block)BlockRegistry.VEXING_LEAVES.get(), (Block)BlockRegistry.VEXING_SAPLING.get());
            this.registerDropSelf(BlockRegistry.BLAZING_WOOD);
            this.registerDropSelf(BlockRegistry.VEXING_WOOD);
            this.registerDropSelf(BlockRegistry.CASCADING_WOOD);
            this.registerDropSelf(BlockRegistry.FLOURISHING_WOOD);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_BUTTON);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_STAIRS);
            this.registerSlabItemTable((Block)BlockRegistry.ARCHWOOD_SLABS.get());
            this.registerDropSelf(BlockRegistry.MAGELIGHT_TORCH);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_FENCE_GATE);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_TRAPDOOR);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_PPlate);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_FENCE);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWLOG_BLUE);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWWOOD_BLUE);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWLOG_GREEN);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWWOOD_GREEN);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWLOG_RED);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWWOOD_RED);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWLOG_PURPLE);
            this.registerDropSelf(BlockRegistry.STRIPPED_AWWOOD_PURPLE);
            this.registerDropDoor((Block)BlockRegistry.ARCHWOOD_DOOR.get());
            this.registerDropSelf(BlockRegistry.SOURCE_GEM_BLOCK);
            this.registerDropSelf(BlockRegistry.POTION_MELDER);
            this.registerDropSelf(BlockRegistry.RITUAL_BLOCK);
            this.registerDropSelf(BlockRegistry.GOLD_SCONCE_BLOCK);
            this.registerBedCondition(BlockRegistry.SCRIBES_BLOCK.get(), (Property)ScribesBlock.PART, (Comparable<T> & StringRepresentable)ThreePartBlock.HEAD);
            this.registerDrop(BlockRegistry.DRYGMY_BLOCK.get(), (ItemLike)Items.f_41998_);
            this.registerDropSelf(BlockRegistry.VITALIC_BLOCK);
            this.registerDropSelf(BlockRegistry.ALCHEMICAL_BLOCK);
            this.registerDropSelf(BlockRegistry.MYCELIAL_BLOCK);
            this.registerDropSelf(BlockRegistry.TIMER_SPELL_TURRET);
            this.registerDropSelf(BlockRegistry.BASIC_SPELL_TURRET);
            this.registerDropSelf(BlockRegistry.ARCHWOOD_CHEST);
            this.registerDropSelf(BlockRegistry.SPELL_PRISM);
            this.registerDropSelf(BlockRegistry.AGRONOMIC_SOURCELINK);
            this.registerDropSelf(BlockRegistry.ENCHANTING_APP_BLOCK);
            LootPool.Builder pedestal = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(BlockRegistry.ARCANE_PEDESTAL).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
            this.m_247577_(BlockRegistry.ARCANE_PEDESTAL.get(), LootTable.m_79147_().m_79161_(pedestal));
            LootPool.Builder platform = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(BlockRegistry.ARCANE_PLATFORM).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
            this.m_247577_(BlockRegistry.ARCANE_PLATFORM.get(), LootTable.m_79147_().m_79161_(platform));
            this.registerDropSelf(BlockRegistry.RELAY);
            this.registerDropSelf(BlockRegistry.RELAY_SPLITTER);
            this.registerDropSelf(BlockRegistry.ARCANE_CORE_BLOCK);
            this.registerDropSelf(BlockRegistry.IMBUEMENT_BLOCK);
            this.registerDropSelf(BlockRegistry.VOLCANIC_BLOCK);
            this.registerDropSelf(BlockRegistry.BRAZIER_RELAY);
            this.registerDropSelf(BlockRegistry.RELAY_WARP);
            this.registerDropSelf(BlockRegistry.RELAY_DEPOSIT);
            this.registerDropSelf(BlockRegistry.RELAY_COLLECTOR);
            this.registerDropSelf(BlockRegistry.CRAFTING_LECTERN.get());
            this.registerDropSelf(BlockRegistry.RED_SBED);
            this.registerDropSelf(BlockRegistry.YELLOW_SBED);
            this.registerDropSelf(BlockRegistry.GREEN_SBED);
            this.registerDropSelf(BlockRegistry.PURPLE_SBED);
            this.registerDropSelf(BlockRegistry.BLUE_SBED);
            this.registerDropSelf(BlockRegistry.ORANGE_SBED);
            this.registerDropSelf(BlockRegistry.SCRYERS_CRYSTAL);
            this.registerDropSelf(BlockRegistry.SCRYERS_OCULUS);
            this.registerDropSelf(BlockRegistry.POTION_DIFFUSER);
            for (String s : LibBlockNames.DECORATIVE_SOURCESTONE) {
                this.registerDropSelf(BlockRegistry.getBlock(s));
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ars_nouveau", s + "_stairs"));
                this.registerDropSelf(block);
                Block slab = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ars_nouveau", s + "_slab"));
                this.registerDropSelf(slab);
            }
            this.registerBedCondition(BlockRegistry.ALTERATION_TABLE.get(), (Property)AlterationTable.PART, (Comparable<T> & StringRepresentable)ThreePartBlock.HEAD);
            this.registerDropSelf(BlockRegistry.VOID_PRISM);
            this.registerDropSelf(BlockRegistry.MAGEBLOOM_BLOCK);
            this.registerDropSelf(BlockRegistry.GHOST_WEAVE);
            this.registerDropSelf(BlockRegistry.FALSE_WEAVE);
            this.registerDropSelf(BlockRegistry.MIRROR_WEAVE);
            this.registerDropSelf(BlockRegistry.ITEM_DETECTOR);
            this.registerDropSelf(BlockRegistry.SKY_WEAVE);
            this.registerDropSelf(BlockRegistry.ROTATING_TURRET);
            this.registerDropSelf(BlockRegistry.SPELL_SENSOR);
            this.m_247577_(BlockRegistry.SOURCE_JAR.get(), this.createManaManchineTable(BlockRegistry.SOURCE_JAR.get()));
            LootPool.Builder potionJarBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(BlockRegistry.POTION_JAR).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("potionData", "BlockEntityTag.potionData", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("currentFill", "BlockEntityTag.currentFill", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("locked", "BlockEntityTag.locked", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("potionNames", "potionNames", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("currentFill", "fill", CopyNbtFunction.MergeStrategy.REPLACE)).m_79078_((LootItemFunction.Builder)SetContainerContents.m_193036_(BlockRegistry.POTION_JAR_TYPE.get()).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
            this.m_247577_(BlockRegistry.POTION_JAR.get(), LootTable.m_79147_().m_79161_(potionJarBuilder));
            this.m_247577_((Block)BlockRegistry.BASTION_POD.get(), LootTable.m_79147_().m_79161_(this.POD_BUILDER(BlockRegistry.BASTION_POD.m_5456_(), (Block)BlockRegistry.BASTION_POD.get())));
            this.m_247577_((Block)BlockRegistry.MENDOSTEEN_POD.get(), LootTable.m_79147_().m_79161_(this.POD_BUILDER(BlockRegistry.MENDOSTEEN_POD.m_5456_(), (Block)BlockRegistry.MENDOSTEEN_POD.get())));
            this.m_247577_((Block)BlockRegistry.FROSTAYA_POD.get(), LootTable.m_79147_().m_79161_(this.POD_BUILDER(BlockRegistry.FROSTAYA_POD.m_5456_(), (Block)BlockRegistry.FROSTAYA_POD.get())));
            this.m_247577_((Block)BlockRegistry.BOMBEGRANTE_POD.get(), LootTable.m_79147_().m_79161_(this.POD_BUILDER(BlockRegistry.BOMBEGRANTE_POD.m_5456_(), (Block)BlockRegistry.BOMBEGRANTE_POD.get())));
            LootPool.Builder mobJarBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(BlockRegistry.MOB_JAR).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("entityTag", "BlockEntityTag.entityTag", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("entityId", "entityId", CopyNbtFunction.MergeStrategy.REPLACE)).m_79078_((LootItemFunction.Builder)SetContainerContents.m_193036_(BlockRegistry.MOB_JAR_TILE.get()).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
            this.m_247577_(BlockRegistry.MOB_JAR.get(), LootTable.m_79147_().m_79161_(mobJarBuilder));
            LootPool.Builder repository = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(BlockRegistry.REPOSITORY).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)));
            this.m_247577_(BlockRegistry.REPOSITORY.get(), LootTable.m_79147_().m_79161_(repository));
            this.registerDropSelf(BlockRegistry.SOURCESTONE_SCONCE_BLOCK.get());
            this.registerDropSelf(BlockRegistry.POLISHED_SCONCE_BLOCK.get());
            this.registerDropSelf(BlockRegistry.ARCHWOOD_SCONCE_BLOCK.get());
            this.registerDropSelf(BlockRegistry.REDSTONE_RELAY.get());
            this.registerDropSelf(BlockRegistry.SOURCEBERRY_SACK.get());
        }

        protected void m_247577_(Block pBlock, LootTable.Builder pBuilder) {
            this.list.add(pBlock);
            super.m_247577_(pBlock, pBuilder);
        }

        protected void m_246481_(Block pBlock, Function<Block, LootTable.Builder> pFactory) {
            this.list.add(pBlock);
            super.m_246481_(pBlock, pFactory);
        }

        protected void add(RegistryWrapper<Block> pBlock, LootTable.Builder pBuilder) {
            this.m_247577_(pBlock.get(), pBuilder);
        }

        protected void add(RegistryWrapper<Block> pBlock, Function<Block, LootTable.Builder> pFactory) {
            this.m_246481_(pBlock.get(), pFactory);
        }

        public LootPool.Builder POD_BUILDER(Item item, Block block) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)ArchfruitPod.f_51736_, 2)))));
        }

        public LootTable.Builder createManaManchineTable(Block block) {
            LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80282_("inv", "BlockEntityTag.inv", CopyNbtFunction.MergeStrategy.REPLACE).m_80282_("source", "BlockEntityTag.source", CopyNbtFunction.MergeStrategy.REPLACE)).m_79078_((LootItemFunction.Builder)SetContainerContents.m_193036_(BlockRegistry.SOURCE_JAR_TILE.get()).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)new ResourceLocation("minecraft", "contents")))));
            return LootTable.m_79147_().m_79161_(builder);
        }

        protected void registerSlabItemTable(Block p_124291_) {
            this.list.add(p_124291_);
            this.m_247577_(p_124291_, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)p_124291_, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)p_124291_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)p_124291_).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))))))));
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> p_249322_) {
            this.m_245660_();
            HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
            for (Block block : this.list) {
                LootTable.Builder loottable$builder;
                ResourceLocation resourcelocation;
                if (!block.m_245993_(this.f_243739_) || (resourcelocation = block.m_60589_()) == BuiltInLootTables.f_78712_ || !set.add(resourcelocation) || (loottable$builder = (LootTable.Builder)this.f_244441_.remove(resourcelocation)) == null) continue;
                p_249322_.accept(resourcelocation, loottable$builder);
            }
        }

        protected <T extends Comparable<T> & StringRepresentable> void registerBedCondition(Block block, Property<T> prop, T isValue) {
            this.list.add(block);
            this.m_247577_(block, LootTable.m_79147_().m_79161_((LootPool.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)block).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(prop, isValue)))))));
        }

        public void registerLeavesAndSticks(Block leaves, Block sapling) {
            this.list.add(leaves);
            this.m_246481_(leaves, l_state -> this.m_246047_((Block)l_state, sapling, DEFAULT_SAPLING_DROP_RATES));
        }

        public void registerDropDoor(Block block) {
            this.list.add(block);
            this.m_247577_(block, this.m_247398_(block));
        }

        public void registerDropSelf(RegistryWrapper block) {
            this.list.add((Block)block.get());
            this.m_245724_((Block)block.get());
        }

        public void registerDropSelf(Block block) {
            this.list.add(block);
            this.m_245724_(block);
        }

        public void registerDropSelf(RegistryObject<Block> block) {
            this.list.add((Block)block.get());
            this.m_245724_((Block)block.get());
        }

        public void registerDrop(Block input, ItemLike output) {
            this.list.add(input);
            this.m_246125_(input, output);
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("ars_nouveau")).collect(Collectors.toList());
        }
    }
}

