/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.world.feature.LightFeature;
import com.hollingsworth.arsnouveau.common.world.tree.MagicTrunkPlacer;
import com.hollingsworth.arsnouveau.common.world.tree.SupplierBlockStateProvider;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class WorldgenRegistry {
    public static final DeferredRegister<Feature<?>> FEAT_REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"ars_nouveau");
    public static final RegistryObject<Feature<BlockStateConfiguration>> LIGHT_FEATURE = FEAT_REG.register("light_feature", () -> new LightFeature((Codec<BlockStateConfiguration>)BlockStateConfiguration.f_67546_));
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_CASCADING_TREE = WorldgenRegistry.registerConfKey("cascading_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_BLAZING_TREE = WorldgenRegistry.registerConfKey("blazing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_VEXING_TREE = WorldgenRegistry.registerConfKey("vexing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_FLOURISHING_TREE = WorldgenRegistry.registerConfKey("flourishing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_CONFIGURED_CASCADING_TREE = WorldgenRegistry.registerConfKey("natural_cascading_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_CONFIGURED_BLAZING_TREE = WorldgenRegistry.registerConfKey("natural_blazing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_CONFIGURED_VEXING_TREE = WorldgenRegistry.registerConfKey("natural_vexing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NATURAL_CONFIGURED_FLOURISHING_TREE = WorldgenRegistry.registerConfKey("natural_flourishing_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_BERRY_BUSH = WorldgenRegistry.registerConfKey("patch_berry");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_LIGHTS = WorldgenRegistry.registerConfKey("lights");
    public static final ResourceKey<PlacedFeature> PLACED_NATURAL_CASCADING_TREE = WorldgenRegistry.registerPlacedKey("placed_cascading_tree");
    public static final ResourceKey<PlacedFeature> PLACED_NATURAL_BLAZING_TREE = WorldgenRegistry.registerPlacedKey("placed_blazing_tree");
    public static final ResourceKey<PlacedFeature> PLACED_NATURAL_VEXING_TREE = WorldgenRegistry.registerPlacedKey("placed_vexing_tree");
    public static final ResourceKey<PlacedFeature> PLACED_NATURAL_FLOURISHING_TREE = WorldgenRegistry.registerPlacedKey("placed_flourishing_tree");
    public static final ResourceKey<PlacedFeature> PLACED_BERRY_BUSH = WorldgenRegistry.registerPlacedKey("placed_berry_bush");
    public static final ResourceKey<PlacedFeature> PLACED_MIX_ARCHWOODS = WorldgenRegistry.registerPlacedKey("placed_mixed_archwoods");
    public static final ResourceKey<PlacedFeature> PLACED_DENSE_ARCHWOODS = WorldgenRegistry.registerPlacedKey("placed_dense_archwoods");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MIXED_ARCHWOODS = WorldgenRegistry.registerConfKey("mixed_archwoods");
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_GRASS = WorldgenRegistry.registerPlacedKey("mojang_grass");
    public static final ResourceKey<PlacedFeature> PLACED_MOJANK_FLOWERS = WorldgenRegistry.registerPlacedKey("mojang_flowers");
    public static final ResourceKey<PlacedFeature> PLACED_LIGHTS = WorldgenRegistry.registerPlacedKey("placed_lights");

    public static ResourceKey<Feature<?>> registerFeatureKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256833_, (ResourceLocation)new ResourceLocation("ars_nouveau", name));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerConfKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("ars_nouveau", name));
    }

    public static ResourceKey<PlacedFeature> registerPlacedKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("ars_nouveau", name));
    }

    public static void bootstrapConfiguredFeatures(BootstapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter placed = context.m_255420_(Registries.f_256988_);
        context.m_255272_(CONFIGURED_CASCADING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)WorldgenRegistry.buildTree("blue_archwood_leaves", "blue_archwood_log", false, new ResourceLocation("ars_nouveau", "frostaya_pod"))));
        context.m_255272_(CONFIGURED_BLAZING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)WorldgenRegistry.buildTree("red_archwood_leaves", "red_archwood_log", false, new ResourceLocation("ars_nouveau", "bombegranate_pod"))));
        context.m_255272_(CONFIGURED_VEXING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)WorldgenRegistry.buildTree("purple_archwood_leaves", "purple_archwood_log", false, new ResourceLocation("ars_nouveau", "bastion_pod"))));
        context.m_255272_(CONFIGURED_FLOURISHING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)WorldgenRegistry.buildTree("green_archwood_leaves", "green_archwood_log", false, new ResourceLocation("ars_nouveau", "mendosteen_pod"))));
        context.m_255272_(NATURAL_CONFIGURED_CASCADING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)WorldgenRegistry.buildTree("blue_archwood_leaves", "blue_archwood_log", true, new ResourceLocation("ars_nouveau", "frostaya_pod"))));
        context.m_255272_(NATURAL_CONFIGURED_BLAZING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)WorldgenRegistry.buildTree("red_archwood_leaves", "red_archwood_log", true, new ResourceLocation("ars_nouveau", "bombegranate_pod"))));
        context.m_255272_(NATURAL_CONFIGURED_VEXING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)WorldgenRegistry.buildTree("purple_archwood_leaves", "purple_archwood_log", true, new ResourceLocation("ars_nouveau", "bastion_pod"))));
        context.m_255272_(NATURAL_CONFIGURED_FLOURISHING_TREE, (Object)new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)WorldgenRegistry.buildTree("green_archwood_leaves", "green_archwood_log", true, new ResourceLocation("ars_nouveau", "mendosteen_pod"))));
        context.m_255272_(PATCH_BERRY_BUSH, (Object)new ConfiguredFeature(Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206476_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ars_nouveau", "sourceberry_bush"))).m_49966_().m_61124_((Property)SourceBerryBush.AGE, (Comparable)Integer.valueOf(3))))), List.of(Blocks.f_50440_))));
        context.m_255272_(MIXED_ARCHWOODS, (Object)new ConfiguredFeature(Feature.f_65755_, (FeatureConfiguration)new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(PLACED_NATURAL_CASCADING_TREE), placed.m_255043_(PLACED_NATURAL_BLAZING_TREE), placed.m_255043_(PLACED_NATURAL_VEXING_TREE), placed.m_255043_(PLACED_NATURAL_FLOURISHING_TREE)}))));
        context.m_255272_(CONFIGURED_LIGHTS, (Object)new ConfiguredFeature((Feature)LIGHT_FEATURE.get(), (FeatureConfiguration)new BlockStateConfiguration(BlockRegistry.LIGHT_BLOCK.get().m_49966_())));
    }

    public static void bootstrapPlacedFeatures(BootstapContext<PlacedFeature> context) {
        HolderGetter features = context.m_255420_(Registries.f_256911_);
        context.m_255272_(PLACED_BERRY_BUSH, (Object)new PlacedFeature((Holder)features.m_254902_(PATCH_BERRY_BUSH).get(), List.of(RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_NATURAL_CASCADING_TREE, (Object)new PlacedFeature((Holder)features.m_254902_(NATURAL_CONFIGURED_CASCADING_TREE).get(), List.of(PlacementUtils.m_206493_((Block)((Block)BlockRegistry.CASCADING_SAPLING.get())))));
        context.m_255272_(PLACED_NATURAL_BLAZING_TREE, (Object)new PlacedFeature((Holder)features.m_254902_(NATURAL_CONFIGURED_BLAZING_TREE).get(), List.of(PlacementUtils.m_206493_((Block)((Block)BlockRegistry.BLAZING_SAPLING.get())))));
        context.m_255272_(PLACED_NATURAL_VEXING_TREE, (Object)new PlacedFeature((Holder)features.m_254902_(NATURAL_CONFIGURED_VEXING_TREE).get(), List.of(PlacementUtils.m_206493_((Block)((Block)BlockRegistry.VEXING_SAPLING.get())))));
        context.m_255272_(PLACED_NATURAL_FLOURISHING_TREE, (Object)new PlacedFeature((Holder)features.m_254902_(NATURAL_CONFIGURED_FLOURISHING_TREE).get(), List.of(PlacementUtils.m_206493_((Block)((Block)BlockRegistry.FLOURISHING_SAPLING.get())))));
        context.m_255272_(PLACED_MIX_ARCHWOODS, (Object)new PlacedFeature((Holder)features.m_254902_(MIXED_ARCHWOODS).get(), VegetationPlacements.m_195479_((PlacementModifier)RarityFilter.m_191900_((int)Config.TREE_SPAWN_RATE))));
        context.m_255272_(PLACED_MOJANK_GRASS, (Object)new PlacedFeature((Holder)features.m_254902_(VegetationFeatures.f_195182_).get(), VegetationPlacements.m_195474_((int)2)));
        context.m_255272_(PLACED_MOJANK_FLOWERS, (Object)new PlacedFeature((Holder)features.m_254902_(VegetationFeatures.f_195192_).get(), List.of(RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_LIGHTS, (Object)new PlacedFeature((Holder)features.m_254902_(CONFIGURED_LIGHTS).get(), VegetationPlacements.m_195474_((int)1)));
        context.m_255272_(PLACED_DENSE_ARCHWOODS, (Object)new PlacedFeature((Holder)features.m_254902_(MIXED_ARCHWOODS).get(), VegetationPlacements.m_195479_((PlacementModifier)PlacementUtils.m_195364_((int)7, (float)0.01f, (int)1))));
    }

    public static TreeConfiguration buildTree(String leaves, String log, boolean natural, ResourceLocation podRegistryName) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)new SupplierBlockStateProvider(log), (TrunkPlacer)new MagicTrunkPlacer(9, 1, 0, natural, podRegistryName.toString()), (BlockStateProvider)new SupplierBlockStateProvider(leaves), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)UniformInt.m_146622_((int)0, (int)0), (IntProvider)UniformInt.m_146622_((int)0, (int)0), 0), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68251_();
    }
}

