/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementEntryProgress {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private final Font font;
    private final Minecraft minecraft;
    private AdvancementProgress advancementProgress;
    private Map<String, CriterionProgress> criteriaMap = new HashMap<String, CriterionProgress>();
    private ResourceLocation id;
    private String namespace = "";
    private Date firstProgressDate;
    private Date lastProgressDate;
    private Float progress = Float.valueOf(0.0f);
    private String progressString = "";
    private boolean isDone = false;
    private int progressStringWidth = 0;
    private int progressTotal = 0;
    private Iterable<String> completedCriteria;
    private Iterable<String> remainingCriteria;
    private int completedCriteriaNumber;
    private int remainingCriteriaNumber;
    private int maxCriteraRequired;

    AdvancementEntryProgress(Advancement advancement, AdvancementProgress advancementProgress) {
        this.minecraft = Minecraft.m_91087_();
        this.font = this.minecraft.f_91062_;
        this.id = advancement.m_138327_();
        this.namespace = advancement.m_138327_().m_135827_();
        this.maxCriteraRequired = advancement.m_138326_();
        this.advancementProgress = advancementProgress;
        this.update(this.advancementProgress);
    }

    public void update(AdvancementProgress advancementProgress) {
        if (advancementProgress == null) {
            return;
        }
        this.advancementProgress = advancementProgress;
        this.isDone = advancementProgress.m_8193_();
        this.firstProgressDate = advancementProgress.m_8221_();
        this.progress = Float.valueOf(advancementProgress.m_8213_());
        this.completedCriteria = advancementProgress.m_8220_();
        this.completedCriteriaNumber = (int)this.completedCriteria.spliterator().getExactSizeIfKnown();
        for (String criteriaId : this.completedCriteria) {
            this.criteriaMap.put(criteriaId, advancementProgress.m_8214_(criteriaId));
        }
        this.remainingCriteria = advancementProgress.m_8219_();
        this.remainingCriteriaNumber = (int)this.remainingCriteria.spliterator().getExactSizeIfKnown();
        for (String criteriaId : this.remainingCriteria) {
            this.criteriaMap.put(criteriaId, advancementProgress.m_8214_(criteriaId));
        }
        if (this.remainingCriteriaNumber > 0 || this.completedCriteriaNumber > 0) {
            this.progressTotal = this.completedCriteriaNumber + this.remainingCriteriaNumber;
            this.progressString = this.completedCriteriaNumber + "/" + this.progressTotal;
            this.progressStringWidth = this.font.m_92895_(this.progressString);
        }
        this.lastProgressDate = this.findLastProgressDate();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public int getMaxCriteraRequired() {
        return this.maxCriteraRequired;
    }

    public int getCompletedCriteriaNumber() {
        return this.completedCriteriaNumber;
    }

    public int getRemainingCriteriaNumber() {
        return this.remainingCriteriaNumber;
    }

    public Date getFirstProgressDate() {
        return this.firstProgressDate;
    }

    public Date getLastProgressDate() {
        return this.lastProgressDate;
    }

    public String getProgressString() {
        return this.progressString;
    }

    public int getProgressStringWidth() {
        return this.progressStringWidth;
    }

    public int getProgressTotal() {
        return this.progressTotal;
    }

    public float getProgress() {
        return this.progress.floatValue();
    }

    public Iterable<String> getCompletedCriteria() {
        return this.completedCriteria;
    }

    public Iterable<String> getCompletedCriteriaHumanReadable() {
        ArrayList result = Lists.newArrayList();
        for (String criteria : this.completedCriteria) {
            result.add(this.getHumanReadableName(criteria));
        }
        return result;
    }

    public Iterable<String> getRemainingCriteria() {
        return this.remainingCriteria;
    }

    public Iterable<String> getRemainingCriteriaHumanReadable() {
        ArrayList result = Lists.newArrayList();
        for (String criteria : this.remainingCriteria) {
            result.add(this.getHumanReadableName(criteria));
        }
        return result;
    }

    private Date findLastProgressDate() {
        Date date = null;
        for (CriterionProgress criterionProgress : this.criteriaMap.values()) {
            Date obtainedDate = criterionProgress.m_12920_();
            if (!criterionProgress.m_12911_() || date != null && (obtainedDate == null || !obtainedDate.after(date))) continue;
            date = criterionProgress.m_12920_();
        }
        return date;
    }

    private String getHumanReadableName(String criteria) {
        ArrayList namespaces = Lists.newArrayList();
        if (this.namespace != null) {
            namespaces.add(this.namespace);
            if (!this.namespace.equals("minecraft")) {
                namespaces.add("minecraft");
            }
        }
        if (namespaces != null) {
            Iterator iterator = namespaces.iterator();
            while (iterator.hasNext()) {
                String possibleNamespace;
                String criteriaName = criteria.startsWith((possibleNamespace = (String)iterator.next()) + ":") ? criteria.replace(possibleNamespace + ":", "") : criteria;
                String itemNameFormat = "item." + possibleNamespace + "." + criteriaName;
                MutableComponent itemName = Component.m_237115_((String)itemNameFormat);
                if (!itemName.getString().equals(itemNameFormat)) {
                    return itemName.getString();
                }
                String blockNameFormat = "block." + possibleNamespace + "." + criteriaName;
                MutableComponent blockName = Component.m_237115_((String)blockNameFormat);
                if (!blockName.getString().equals(blockNameFormat)) {
                    return blockName.getString();
                }
                String entityNameFormat = "entity." + possibleNamespace + "." + criteriaName;
                MutableComponent entityName = Component.m_237115_((String)entityNameFormat);
                if (!entityName.getString().equals(entityNameFormat)) {
                    return entityName.getString();
                }
                String enchantmentNameFormat = "enchantment." + possibleNamespace + "." + criteriaName;
                MutableComponent enchantmentName = Component.m_237115_((String)enchantmentNameFormat);
                if (!enchantmentName.getString().equals(enchantmentNameFormat)) {
                    return enchantmentName.getString();
                }
                String effectNameFormat = "effect." + possibleNamespace + "." + criteriaName;
                MutableComponent effectName = Component.m_237115_((String)effectNameFormat);
                if (!effectName.getString().equals(effectNameFormat)) {
                    return effectName.getString();
                }
                String biomeNameFormat = "biome." + possibleNamespace + "." + criteriaName;
                MutableComponent biomeName = Component.m_237115_((String)biomeNameFormat);
                if (biomeName.getString().equals(biomeNameFormat)) continue;
                return biomeName.getString();
            }
            String advancementNameFormat = "advancement." + this.id.toString().replace(":", ".").replace("/", ".") + "." + criteria.replace(":", ".").replace("/", ".");
            MutableComponent advancementName = Component.m_237115_((String)advancementNameFormat);
            if (!advancementName.getString().equals(advancementNameFormat)) {
                return advancementName.getString();
            }
            log.warn("Unable to translate {} ({}) to a more meaningful name.", (Object)criteria, (Object)advancementNameFormat);
        }
        return criteria;
    }
}

