/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementsManager;
import de.markusbordihn.advancementstracker.client.advancements.ClientAdvancementManager;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class AdvancementsEventManager {
    private static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static int numberOfAdvancements = 0;

    protected AdvancementsEventManager() {
    }

    @SubscribeEvent
    public static void handleLevelEventLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        AdvancementsEventManager.reset();
    }

    @SubscribeEvent
    public static void handleAdvancementEvent(AdvancementEvent advancementEvent) {
        Advancement advancement = advancementEvent.getAdvancement();
        if (ClientAdvancementManager.isValidAdvancement(advancement)) {
            int possibleNumberOfAdvancements;
            LocalPlayer localPlayer;
            Advancement rootAdvancement;
            log.debug("[Advancement Event] {}", (Object)advancement);
            String advancementId = advancement.m_138327_().toString();
            if (rootAdvancement == null) {
                if (advancementId.contains("/root") || advancementId.contains(":root")) {
                    ClientAdvancementManager.reset();
                }
                AdvancementsManager.addAdvancementRoot(advancement);
            } else {
                for (rootAdvancement = advancement.m_138319_(); rootAdvancement != null && rootAdvancement.m_138319_() != null; rootAdvancement = rootAdvancement.m_138319_()) {
                }
                AdvancementsManager.addAdvancementRoot(rootAdvancement);
                AdvancementsManager.addAdvancementTask(advancement);
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null && (localPlayer = minecraft.f_91074_) != null && localPlayer.f_108617_ != null && localPlayer.f_108617_.m_105145_() != null && !localPlayer.f_108617_.m_105145_().m_104396_().m_139344_().isEmpty() && (possibleNumberOfAdvancements = localPlayer.f_108617_.m_105145_().m_104396_().m_139344_().size()) > numberOfAdvancements) {
                log.debug("Force sync of advancements because it seems we are missing some {} vs. {}", (Object)possibleNumberOfAdvancements, (Object)numberOfAdvancements);
                ClientAdvancementManager.reset();
                numberOfAdvancements = possibleNumberOfAdvancements;
            }
        }
    }

    public static void reset() {
        log.debug("Resetting number of advancements ...");
        numberOfAdvancements = 0;
    }
}

