/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.TrackedAdvancementsManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class AdvancementsManager {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static AdvancementEntry selectedAdvancement;
    private static AdvancementEntry selectedRootAdvancement;
    private static Map<Advancement, AdvancementProgress> advancementProgressMap;
    private static Map<ResourceLocation, Set<AdvancementEntry>> advancementsMap;
    private static Set<AdvancementEntry> rootAdvancements;
    private static Set<String> advancementsIndex;
    private static boolean hasAdvancements;

    protected AdvancementsManager() {
    }

    @SubscribeEvent
    public static void handleLevelEventLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        AdvancementsManager.reset();
    }

    public static void reset() {
        log.debug("Reset Advancements Manager ...");
        advancementProgressMap = new HashMap<Advancement, AdvancementProgress>();
        advancementsIndex = new HashSet<String>();
        advancementsMap = new HashMap<ResourceLocation, Set<AdvancementEntry>>();
        hasAdvancements = false;
        rootAdvancements = new HashSet<AdvancementEntry>();
        selectedAdvancement = null;
        selectedRootAdvancement = null;
    }

    public static void addAdvancementRoot(Advancement advancement) {
        String advancementId = advancement.m_138327_().toString();
        if (AdvancementsManager.hasAdvancement(advancementId)) {
            return;
        }
        AdvancementProgress advancementProgress = AdvancementsManager.getAdvancementProgress(advancement);
        AdvancementEntry advancementEntry = new AdvancementEntry(advancement, advancementProgress);
        rootAdvancements.add(advancementEntry);
        advancementsIndex.add(advancementId);
        log.debug("Added Root Advancement: {}", (Object)advancementEntry);
    }

    public static void addAdvancementTask(Advancement advancement) {
        Advancement rootAdvancement;
        String advancementId = advancement.m_138327_().toString();
        for (rootAdvancement = advancement.m_138319_(); rootAdvancement != null && rootAdvancement.m_138319_() != null; rootAdvancement = rootAdvancement.m_138319_()) {
        }
        if (rootAdvancement != null) {
            AdvancementsManager.addAdvancementRoot(rootAdvancement);
        }
        if (AdvancementsManager.hasAdvancement(advancementId)) {
            return;
        }
        AdvancementProgress advancementProgress = AdvancementsManager.getAdvancementProgress(advancement);
        AdvancementEntry advancementEntry = new AdvancementEntry(advancement, advancementProgress);
        Set childAdvancements = advancementsMap.computeIfAbsent(advancementEntry.rootId, k -> new HashSet());
        childAdvancements.add(advancementEntry);
        advancementsIndex.add(advancementId);
        if (!hasAdvancements) {
            hasAdvancements = true;
        }
        log.debug("Added Advancement Task: {}", (Object)advancementEntry);
        TrackedAdvancementsManager.checkForTrackedAdvancement(advancementEntry);
    }

    public static boolean hasAdvancement(Advancement advancement) {
        return AdvancementsManager.hasAdvancement(advancement.m_138327_().toString());
    }

    public static boolean hasAdvancement(String advancementId) {
        return advancementsIndex.contains(advancementId);
    }

    public static boolean hasRootAdvancement(Advancement advancement) {
        for (AdvancementEntry rootAdvancement : rootAdvancements) {
            if (advancement.m_138327_() != rootAdvancement.getId()) continue;
            return true;
        }
        return false;
    }

    public static AdvancementEntry getRootAdvancement(Advancement advancement) {
        for (AdvancementEntry rootAdvancement : rootAdvancements) {
            if (advancement.m_138327_() != rootAdvancement.getId()) continue;
            return rootAdvancement;
        }
        return null;
    }

    public static Set<AdvancementEntry> getRootAdvancements() {
        return rootAdvancements;
    }

    public static Set<AdvancementEntry> getSortedRootAdvancements(Comparator<AdvancementEntry> comparator) {
        Set<AdvancementEntry> advancements = AdvancementsManager.getRootAdvancements();
        if (advancements == null) {
            return new HashSet<AdvancementEntry>();
        }
        return advancements.stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<AdvancementEntry> getRootAdvancementsByTile() {
        return AdvancementsManager.getSortedRootAdvancements(AdvancementEntry.sortByTitle());
    }

    public static int getNumberOfRootAdvancements() {
        return rootAdvancements.size();
    }

    public static int getNumberOfAdvancements(AdvancementEntry rootAdvancement) {
        Set<AdvancementEntry> advancements = AdvancementsManager.getAdvancements(rootAdvancement);
        return advancements.size();
    }

    public static int getNumberOfCompletedAdvancements(AdvancementEntry rootAdvancement) {
        int completedAdvancements = 0;
        Set<AdvancementEntry> advancements = AdvancementsManager.getAdvancements(rootAdvancement);
        for (AdvancementEntry advancementEntry : advancements) {
            if (!advancementEntry.getProgress().isDone()) continue;
            ++completedAdvancements;
        }
        return completedAdvancements;
    }

    public static AdvancementEntry getAdvancement(Advancement advancement) {
        return AdvancementsManager.getAdvancement(advancement.m_138327_().toString());
    }

    public static AdvancementEntry getAdvancement(String id) {
        for (Set<AdvancementEntry> advancementEntries : advancementsMap.values()) {
            for (AdvancementEntry advancementEntry : advancementEntries) {
                if (!id.equals(advancementEntry.getIdString())) continue;
                return advancementEntry;
            }
        }
        return null;
    }

    public static Set<AdvancementEntry> getAdvancements(AdvancementEntry rootAdvancement) {
        if (rootAdvancement == null) {
            log.error("Unable to get advancements for root advancement {}", (Object)rootAdvancement);
            return new HashSet<AdvancementEntry>();
        }
        Set<AdvancementEntry> advancements = advancementsMap.get(rootAdvancement.getId());
        if (advancements == null) {
            return new HashSet<AdvancementEntry>();
        }
        return advancements;
    }

    public static Set<AdvancementEntry> getSortedAdvancements(AdvancementEntry rootAdvancement, Comparator<AdvancementEntry> comparator) {
        Set advancements = AdvancementsManager.getAdvancements(rootAdvancement);
        return advancements.isEmpty() ? advancements : (Set)advancements.stream().sorted(comparator).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<AdvancementEntry> getAdvancementsByTile(AdvancementEntry rootAdvancement) {
        return AdvancementsManager.getSortedAdvancements(rootAdvancement, AdvancementEntry.sortByTitle());
    }

    public static Set<AdvancementEntry> getAdvancementsByStatus(AdvancementEntry rootAdvancement) {
        return AdvancementsManager.getSortedAdvancements(rootAdvancement, AdvancementEntry.sortByStatus());
    }

    public static void updateAdvancementProgress(Advancement advancement, AdvancementProgress advancementProgress) {
        advancementProgressMap.put(advancement, advancementProgress);
        AdvancementEntry advancementEntry = AdvancementsManager.getAdvancement(advancement);
        if (advancementEntry == null && (advancementEntry = AdvancementsManager.getRootAdvancement(advancement)) == null) {
            log.error("Unable to find entry for advancement {} with progress {}", (Object)advancement, (Object)advancementProgress);
            return;
        }
        advancementEntry.updateAdvancementProgress(advancementProgress);
        if (advancementProgress.m_8193_()) {
            TrackedAdvancementsManager.untrackAdvancement(advancement);
        }
    }

    public static AdvancementProgress getAdvancementProgress(Advancement advancement) {
        return advancementProgressMap.get(advancement);
    }

    public static AdvancementEntry getSelectedAdvancement() {
        Set<AdvancementEntry> possibleAdvancements;
        if (selectedAdvancement == null && AdvancementsManager.getSelectedRootAdvancement() != null && !(possibleAdvancements = AdvancementsManager.getAdvancements(AdvancementsManager.getSelectedRootAdvancement())).isEmpty() && possibleAdvancements.iterator().hasNext()) {
            selectedAdvancement = possibleAdvancements.iterator().next();
        }
        return selectedAdvancement;
    }

    public static void setSelectedAdvancement(AdvancementEntry selectedAdvancement) {
        AdvancementsManager.selectedAdvancement = selectedAdvancement;
    }

    public static AdvancementEntry getSelectedRootAdvancement() {
        AdvancementEntry possibleRootAdvancement;
        if (selectedRootAdvancement == null && rootAdvancements != null && rootAdvancements.iterator().hasNext() && (possibleRootAdvancement = rootAdvancements.iterator().next()) != selectedRootAdvancement) {
            log.debug("Select root advancement: {}", (Object)selectedAdvancement);
            selectedRootAdvancement = possibleRootAdvancement;
            selectedAdvancement = null;
        }
        return selectedRootAdvancement;
    }

    public static void setSelectedRootAdvancement(AdvancementEntry selectedRootAdvancement) {
        AdvancementsManager.selectedRootAdvancement = selectedRootAdvancement;
        if (selectedAdvancement != null && selectedRootAdvancement.getId() != AdvancementsManager.selectedAdvancement.rootId) {
            selectedAdvancement = null;
        }
    }

    public static boolean hasAdvancements() {
        return hasAdvancements;
    }

    static {
        advancementProgressMap = new HashMap<Advancement, AdvancementProgress>();
        advancementsMap = new HashMap<ResourceLocation, Set<AdvancementEntry>>();
        rootAdvancements = new HashSet<AdvancementEntry>();
        advancementsIndex = new HashSet<String>();
        hasAdvancements = false;
    }
}

