/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.advancements;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementsManager;
import de.markusbordihn.advancementstracker.client.gui.screens.AdvancementsTrackerScreen;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientAdvancementManager
implements ClientAdvancements.Listener {
    private static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static final short ADD_LISTENER_TICK = 2;
    private static ClientAdvancementManager clientAdvancementManager;
    private static ClientAdvancements clientAdvancements;
    private static boolean hasListener;
    private static boolean needsReload;
    private static int listenerTicks;

    protected ClientAdvancementManager() {
    }

    @SubscribeEvent
    public static void handleLevelEventLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        ClientAdvancementManager.reset();
    }

    @SubscribeEvent
    public static void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft minecraft;
        if (event.phase == TickEvent.Phase.END) {
            ++listenerTicks;
            return;
        }
        if (listenerTicks >= 2 && !hasListener) {
            ClientAdvancementManager.addListener();
            listenerTicks = 0;
        }
        if ((minecraft = Minecraft.m_91087_()) != null) {
            if (minecraft.f_91080_ != null) {
                Screen screen = minecraft.f_91080_;
                if (!needsReload && !(screen instanceof AdvancementsTrackerScreen) && screen instanceof ClientAdvancements.Listener) {
                    log.debug("Need to reload advancements after screen {} is closed!", (Object)minecraft.f_91080_);
                    needsReload = true;
                }
            } else if (needsReload) {
                ClientAdvancementManager.reset();
            }
        }
    }

    public static void reset() {
        log.debug("Resetting Client Advancement Manager ...");
        clientAdvancementManager = new ClientAdvancementManager();
        clientAdvancements = null;
        hasListener = false;
        listenerTicks = 0;
        needsReload = false;
    }

    public static void addListener() {
        if (clientAdvancements != null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null || minecraft.f_91074_ == null || minecraft.f_91074_.f_108617_ == null || minecraft.f_91074_.f_108617_.m_105145_() == null || minecraft.f_91074_.f_108617_.m_105145_().m_104396_().m_139344_().isEmpty()) {
            return;
        }
        log.debug("Adding client advancement manager listener...");
        clientAdvancements = minecraft.f_91074_.f_108617_.m_105145_();
        minecraft.f_91074_.f_108617_.m_105145_().m_104397_((ClientAdvancements.Listener)clientAdvancementManager);
        hasListener = true;
    }

    public static boolean isValidAdvancement(Advancement advancement) {
        String advancementId = advancement.m_138327_().toString();
        if (advancementId.startsWith("minecraft:recipes/") || advancementId.startsWith("smallships:recipes")) {
            return false;
        }
        if (advancement.m_138320_() == null) {
            log.debug("[Skip Advancement with no display information] {}", (Object)advancement);
            return false;
        }
        return true;
    }

    public void m_7922_(Advancement advancement, AdvancementProgress advancementProgress) {
        if (ClientAdvancementManager.isValidAdvancement(advancement)) {
            log.debug("[Update Advancement Progress] {} with {}", (Object)advancement, (Object)advancementProgress);
            AdvancementsManager.updateAdvancementProgress(advancement, advancementProgress);
        }
    }

    public void m_5513_(Advancement advancement) {
        if (ClientAdvancementManager.isValidAdvancement(advancement) && advancement.m_138319_() == null) {
            log.debug("[Add Advancement Root] {}", (Object)advancement);
            AdvancementsManager.addAdvancementRoot(advancement);
        }
    }

    public void m_5504_(Advancement advancement) {
        log.debug("[Remove Advancement Root] {}", (Object)advancement);
    }

    public void m_5505_(Advancement advancement) {
        if (ClientAdvancementManager.isValidAdvancement(advancement) && advancement.m_138319_() != null) {
            log.debug("[Add Advancement Task] {}", (Object)advancement);
            AdvancementsManager.addAdvancementTask(advancement);
        }
    }

    public void m_5516_(Advancement advancement) {
        log.debug("[Remove Advancement Task] {}", (Object)advancement);
    }

    public void m_7204_() {
        log.debug("[Advancements Cleared] ...");
    }

    public void m_6896_(Advancement advancement) {
        log.debug("[Selected Tab Changed] {}", (Object)advancement);
    }

    static {
        hasListener = false;
        needsReload = false;
        listenerTicks = 0;
    }
}

