/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.panel;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.advancementstracker.Constants;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.TrackedAdvancementsManager;
import de.markusbordihn.advancementstracker.client.gui.components.AdvancementTooltip;
import de.markusbordihn.advancementstracker.client.gui.screens.AdvancementsTrackerScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementOverviewPanel
extends ObjectSelectionList<ChildAdvancementEntry> {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private final int listLeft;
    private final int listWidth;
    private AdvancementsTrackerScreen parent;
    private AdvancementTooltip advancementTooltip;

    public AdvancementOverviewPanel(AdvancementsTrackerScreen parent, int listWidth, int top, int listLeft, int bottom) {
        Minecraft minecraft = parent.getMinecraftInstance();
        int n = parent.f_96544_;
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, listWidth, n, top, bottom, 9 * 4 + 12);
        this.parent = parent;
        this.listWidth = listWidth;
        this.listLeft = listLeft;
        this.m_93507_(listLeft + 1);
        this.m_93488_(false);
        this.m_93471_(false);
    }

    public void refreshList() {
        this.m_93516_();
        this.parent.buildChildAdvancementsList(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0), mod -> new ChildAdvancementEntry((AdvancementEntry)mod, this.parent));
        if (this.m_93517_() > 0.0) {
            this.m_93410_(0.0);
        }
        this.advancementTooltip = null;
    }

    public void setAdvancementTooltip(AdvancementTooltip advancementTooltip) {
        this.advancementTooltip = advancementTooltip;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.advancementTooltip != null) {
            this.advancementTooltip = null;
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return !this.parent.showingAdvancementDetail() && mouseY >= (double)this.f_93390_ && mouseY <= (double)this.f_93391_ && mouseX >= (double)this.f_93393_ && mouseX <= (double)(this.f_93392_ + 5);
    }

    protected int m_5756_() {
        return this.listWidth + this.listLeft;
    }

    public int m_5759_() {
        return this.listWidth;
    }

    public class ChildAdvancementEntry
    extends ObjectSelectionList.Entry<ChildAdvancementEntry> {
        private static final ResourceLocation icons = new ResourceLocation("minecraft:textures/gui/icons.png");
        private static final ResourceLocation miscTexture = new ResourceLocation("advancements_tracker", "textures/gui/misc.png");
        private final AdvancementEntry advancementEntry;
        private final AdvancementsTrackerScreen parent;
        private final AdvancementTooltip advancementTooltip;
        private final Font font;
        private final boolean isDone;
        private final int completedCriteriaNumber;
        private final int descriptionColor;
        private final int iconWidth;
        private final int remainingCriteriaNumber;
        private final int titleColor;
        private FormattedCharSequence titleParts;
        private List<FormattedCharSequence> descriptionParts;
        private boolean isMouseOvered = false;
        private int maxFontWidth;
        private int progressWidth = 182;
        private int relativeLeftPosition;
        private int relativeTopPosition;
        private int titleWidth;

        ChildAdvancementEntry(AdvancementEntry advancementEntry, AdvancementsTrackerScreen parent) {
            this.advancementEntry = advancementEntry;
            this.advancementTooltip = new AdvancementTooltip(advancementEntry);
            this.completedCriteriaNumber = advancementEntry.getProgress().getCompletedCriteriaNumber();
            this.descriptionColor = advancementEntry.getDescriptionColor();
            this.font = parent.getFontRenderer();
            this.isDone = advancementEntry.getProgress().isDone();
            this.parent = parent;
            this.remainingCriteriaNumber = advancementEntry.getProgress().getRemainingCriteriaNumber();
            this.titleColor = advancementEntry.getTitleColor();
            this.iconWidth = 18;
            this.maxFontWidth = AdvancementOverviewPanel.this.listWidth - this.iconWidth - 4;
            this.titleWidth = this.font.m_92852_((FormattedText)advancementEntry.getTitle()) > this.maxFontWidth ? this.maxFontWidth - 6 : this.maxFontWidth;
            this.titleParts = Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{this.font.m_92854_((FormattedText)advancementEntry.getTitle(), this.titleWidth)}));
            this.descriptionParts = this.font.m_92923_((FormattedText)advancementEntry.getDescription(), this.maxFontWidth);
        }

        public AdvancementEntry getAdvancementEntry() {
            return this.advancementEntry;
        }

        private void renderBackground(GuiGraphics guiGraphics, int top, int entryWidth, int entryHeight) {
            if (this.advancementEntry.getBackground() == null) {
                return;
            }
            if (this.isMouseOvered) {
                RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280163_(this.advancementEntry.getBackground(), AdvancementOverviewPanel.this.getLeft() + 1, top - 1, 0.0f, 0.0f, entryWidth - 2, entryHeight + 1, 16, 16);
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderIcon(GuiGraphics guiGraphics, int top) {
            if (this.advancementEntry.getIcon() == null) {
                return;
            }
            guiGraphics.m_280480_(this.advancementEntry.getIcon(), AdvancementOverviewPanel.this.getLeft() + 3, top + 2);
        }

        private void renderRewards(GuiGraphics guiGraphics, int top, int left, int entryWidth) {
            if (!this.advancementEntry.hasRewards()) {
                return;
            }
            float scaling = 0.7f;
            int positionLeft = Math.round((float)(left + entryWidth - 14) / scaling);
            int positionTop = Math.round((float)(top - 1) / scaling);
            if (this.advancementEntry.hasExperienceReward()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(scaling, scaling, scaling);
                guiGraphics.m_280163_(miscTexture, positionLeft, positionTop, 102.0f, 7.0f, 12, 15, 256, 256);
                guiGraphics.m_280168_().m_85849_();
                positionLeft -= 16;
            }
            if (this.advancementEntry.hasLootReward()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(scaling, scaling, scaling);
                guiGraphics.m_280163_(miscTexture, positionLeft, positionTop, 137.0f, 6.0f, 14, 16, 256, 256);
                guiGraphics.m_280168_().m_85849_();
                positionLeft -= 16;
            }
            if (this.advancementEntry.hasRecipesReward()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(scaling, scaling, scaling);
                guiGraphics.m_280163_(miscTexture, positionLeft, positionTop, 118.0f, 6.0f, 14, 16, 256, 256);
                guiGraphics.m_280168_().m_85849_();
                positionLeft -= 16;
            }
        }

        private void renderProgress(GuiGraphics guiGraphics, int top, int entryWidth, int iconWidth) {
            int progressPositionLeft = AdvancementOverviewPanel.this.getLeft() + iconWidth + 5;
            int progressPositionTop = top + 33;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280163_(icons, progressPositionLeft, progressPositionTop, 0.0f, 64.0f, this.progressWidth, 5, 256, 256);
            guiGraphics.m_280168_().m_85849_();
            if (this.remainingCriteriaNumber > 0 || this.isDone) {
                int progressTotal = this.completedCriteriaNumber + this.remainingCriteriaNumber;
                int progressDone = this.completedCriteriaNumber;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)icons);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280163_(icons, progressPositionLeft, progressPositionTop, 0.0f, 69.0f, this.isDone ? this.progressWidth : this.progressWidth / progressTotal * progressDone, 5, 256, 256);
                guiGraphics.m_280168_().m_85849_();
                if (entryWidth > this.progressWidth + 42) {
                    float scaling = 0.75f;
                    float positionScaling = 1.33f;
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_85841_(scaling, scaling, scaling);
                    guiGraphics.m_280488_(this.font, this.advancementEntry.getProgress().getProgressString(), Math.round((float)(progressPositionLeft + this.progressWidth + 5) * positionScaling), Math.round((float)progressPositionTop * positionScaling), (this.remainingCriteriaNumber >= 1 ? ChatFormatting.YELLOW.m_126665_() : ChatFormatting.GREEN.m_126665_()).intValue());
                    guiGraphics.m_280168_().m_85849_();
                }
            }
        }

        private void renderDecoration(GuiGraphics guiGraphics, int top, int entryWidth, int entryHeight) {
            int topPosition = top - 2;
            int leftPosition = AdvancementOverviewPanel.this.getLeft();
            int rightPosition = leftPosition + entryWidth - 2;
            int bottomPosition = top + entryHeight;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280163_(miscTexture, leftPosition, topPosition, 0.0f, 0.0f, entryWidth - 1, 1, entryWidth - 1, 256);
            guiGraphics.m_280163_(miscTexture, rightPosition, topPosition + 1, 255.0f, 0.0f, 1, entryHeight + 2, 256, entryHeight);
            guiGraphics.m_280163_(miscTexture, leftPosition, bottomPosition, 0.0f, 255.0f, entryWidth - 1, 1, entryWidth - 1, 256);
            guiGraphics.m_280163_(miscTexture, leftPosition, topPosition + 1, 0.0f, 0.0f, 1, entryHeight + 2, 256, entryHeight);
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderTrackingCheckbox(GuiGraphics guiGraphics, int top, int left) {
            int iconPosition = 22;
            if (this.isDone) {
                iconPosition = 3;
            } else if (TrackedAdvancementsManager.isTrackedAdvancement(this.advancementEntry)) {
                iconPosition = 42;
            }
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280163_(miscTexture, left + 2, top + 27, (float)iconPosition, 6.0f, 15, 15, 256, 256);
            guiGraphics.m_280168_().m_85849_();
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.advancementEntry.getTitleString()});
        }

        public void m_6311_(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isFocused, float partialTick) {
            this.isMouseOvered = this.m_5953_(mouseX, mouseY);
            int textPositionLeft = left + this.iconWidth;
            this.relativeLeftPosition = left;
            this.relativeTopPosition = top;
            this.renderBackground(guiGraphics, top, entryWidth, entryHeight);
            if (this.isMouseOvered) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
            }
            this.renderIcon(guiGraphics, top);
            guiGraphics.m_280648_(this.font, this.titleParts, textPositionLeft + 3, top + 1, this.titleColor);
            if (this.titleWidth != this.maxFontWidth) {
                guiGraphics.m_280614_(this.font, Constants.ELLIPSIS, textPositionLeft + this.titleWidth, top + 1, this.titleColor, false);
            }
            int descriptionLines = 1;
            for (FormattedCharSequence descriptionPart : this.descriptionParts) {
                Objects.requireNonNull(this.font);
                int descriptionTopPosition = top + (2 + 9) * descriptionLines;
                guiGraphics.m_280648_(this.font, descriptionPart, textPositionLeft + 3, descriptionTopPosition, this.descriptionColor);
                if (this.descriptionParts.size() >= 3 && descriptionLines == 2) {
                    guiGraphics.m_280614_(this.font, Constants.ELLIPSIS, textPositionLeft + (this.font.m_92724_(descriptionPart) < this.maxFontWidth - 6 ? this.font.m_92724_(descriptionPart) + 6 : this.maxFontWidth - 6), descriptionTopPosition, this.descriptionColor, false);
                    break;
                }
                ++descriptionLines;
            }
            this.renderRewards(guiGraphics, top, left, entryWidth);
            this.renderProgress(guiGraphics, top, entryWidth, this.iconWidth);
            this.renderDecoration(guiGraphics, top, entryWidth, entryHeight);
            this.renderTrackingCheckbox(guiGraphics, top, left);
            if (super.m_5953_((double)mouseX, (double)mouseY)) {
                AdvancementOverviewPanel.this.setAdvancementTooltip(this.advancementTooltip);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                double relativeX = mouseX - (double)this.relativeLeftPosition;
                double relativeY = mouseY - (double)this.relativeTopPosition;
                if (relativeX > 3.0 && relativeX < 15.0 && relativeY > 27.0 && relativeY < 42.0) {
                    TrackedAdvancementsManager.toggleTrackedAdvancement(this.getAdvancementEntry());
                } else {
                    this.parent.setSelectedChildAdvancement(this);
                    this.parent.showAdvancementDetail(true);
                    AdvancementOverviewPanel.this.m_6987_((AbstractSelectionList.Entry)this);
                }
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }
}

