/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.client.gui.screens;

import de.markusbordihn.advancementstracker.client.advancements.AdvancementEntry;
import de.markusbordihn.advancementstracker.client.advancements.AdvancementsManager;
import de.markusbordihn.advancementstracker.client.gui.components.SmallButton;
import de.markusbordihn.advancementstracker.client.gui.panel.AdvancementCategoryPanel;
import de.markusbordihn.advancementstracker.client.gui.panel.AdvancementOverviewPanel;
import de.markusbordihn.advancementstracker.client.gui.screens.AdvancementDetailScreen;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementsTrackerScreen
extends Screen {
    protected static final Logger log = LogManager.getLogger((String)"Advancements Tracker");
    private static final ResourceLocation miscTexture = new ResourceLocation("advancements_tracker", "textures/gui/misc.png");
    private static final int PADDING = 10;
    private static final int STATUS_BAR_HEIGHT = 11;
    private static final int SCROLLBAR_WIDTH = 6;
    private static boolean showCompletedAdvancements = true;
    private static boolean showOnlyRewardedAdvancements = false;
    private static Screen parentScreen = null;
    Set<AdvancementEntry> rootAdvancements;
    Set<AdvancementEntry> childAdvancements;
    private int listWidth;
    private CategorySortType sortType = CategorySortType.NORMAL;
    private boolean sorted = false;
    private AdvancementEntry selectedRootAdvancement = null;
    private AdvancementEntry selectedChildAdvancement = null;
    private AdvancementCategoryPanel advancementCategoryPanel;
    private AdvancementOverviewPanel advancementOverviewPanel;
    private AdvancementDetailScreen showAdvancementDetailScreen;
    private boolean showAdvancementDetail = false;
    private int numberOfCompletedAdvancements = 0;
    private int numberOfRootAdvancements = 0;
    private int numberOfTotalAdvancements = 0;
    private int completedCheckboxX;
    private int onlyRewardedCheckboxX;

    public AdvancementsTrackerScreen() {
        this((Component)Component.m_237113_((String)"Advancements Tracker"));
    }

    public AdvancementsTrackerScreen(Component component) {
        super(component);
    }

    public static void toggleVisibility() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            return;
        }
        if (!(minecraft.f_91080_ instanceof AdvancementsTrackerScreen)) {
            parentScreen = minecraft.f_91080_;
            Minecraft.m_91087_().m_91152_((Screen)new AdvancementsTrackerScreen());
        } else if (minecraft.f_91080_ instanceof AdvancementsTrackerScreen) {
            Minecraft.m_91087_().m_91152_(parentScreen);
            parentScreen = null;
        }
    }

    private static void toggleShowCompletedAdvancements() {
        showCompletedAdvancements = !showCompletedAdvancements;
    }

    private static void toggleShowOnlyRewardedAdvancements() {
        showOnlyRewardedAdvancements = !showOnlyRewardedAdvancements;
    }

    public Minecraft getMinecraftInstance() {
        return this.f_96541_;
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildRootAdvancementsList(Consumer<T> listViewConsumer, Function<AdvancementEntry, T> newEntry) {
        if (this.rootAdvancements == null) {
            this.reloadRootAdvancements();
        }
        this.rootAdvancements.forEach(advancementEntry -> listViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((AdvancementEntry)advancementEntry)));
    }

    public void reloadRootAdvancements() {
        this.reloadRootAdvancements(CategorySortType.NORMAL);
    }

    public void reloadRootAdvancements(CategorySortType sortType) {
        this.rootAdvancements = sortType == CategorySortType.NORMAL ? AdvancementsManager.getRootAdvancements() : AdvancementsManager.getSortedRootAdvancements(sortType);
        if (this.advancementCategoryPanel != null) {
            this.advancementCategoryPanel.refreshList();
        }
    }

    private void resortRootAdvancements(CategorySortType newSort) {
        this.sortType = newSort;
        for (CategorySortType sort : CategorySortType.values()) {
            if (sort.button == null) continue;
            sort.button.f_93623_ = this.sortType != sort;
        }
        this.sorted = false;
    }

    public AdvancementEntry getSelectedRootAdvancement() {
        return this.selectedRootAdvancement;
    }

    public void setSelectedRootAdvancement(AdvancementCategoryPanel.RootAdvancementEntry entry) {
        AdvancementEntry advancementEntry = entry.getAdvancementEntry();
        if (advancementEntry == null || this.selectedRootAdvancement == advancementEntry) {
            return;
        }
        this.selectedRootAdvancement = advancementEntry;
        log.debug("Selected root entry {}", (Object)this.selectedRootAdvancement);
        this.reloadChildAdvancements();
        this.numberOfCompletedAdvancements = AdvancementsManager.getNumberOfCompletedAdvancements(this.selectedRootAdvancement);
        this.numberOfTotalAdvancements = AdvancementsManager.getNumberOfAdvancements(this.selectedRootAdvancement);
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildChildAdvancementsList(Consumer<T> listViewConsumer, Function<AdvancementEntry, T> newEntry) {
        if (this.childAdvancements == null) {
            return;
        }
        this.childAdvancements.forEach(advancementEntry -> {
            if (!(!showCompletedAdvancements && advancementEntry.getProgress().isDone() || showOnlyRewardedAdvancements && !advancementEntry.hasRewards())) {
                listViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((AdvancementEntry)advancementEntry));
            }
        });
    }

    public void reloadChildAdvancements() {
        this.reloadChildAdvancements(CategorySortType.NORMAL);
    }

    public void reloadChildAdvancements(CategorySortType sortType) {
        if (this.selectedRootAdvancement == null) {
            return;
        }
        this.childAdvancements = sortType == CategorySortType.NORMAL ? AdvancementsManager.getAdvancements(this.selectedRootAdvancement) : AdvancementsManager.getSortedAdvancements(this.selectedRootAdvancement, sortType);
        if (this.advancementOverviewPanel != null) {
            this.advancementOverviewPanel.refreshList();
        }
    }

    public void showAdvancementDetail(boolean visible) {
        this.showAdvancementDetail = visible;
        AdvancementDetailScreen advancementDetailScreen = this.showAdvancementDetailScreen = visible && this.selectedChildAdvancement != null ? new AdvancementDetailScreen(this.selectedChildAdvancement) : null;
        if (this.showAdvancementDetailScreen != null) {
            this.showAdvancementDetailScreen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public AdvancementEntry getSelectedChildAdvancement() {
        return this.selectedChildAdvancement;
    }

    public void setSelectedChildAdvancement(AdvancementOverviewPanel.ChildAdvancementEntry entry) {
        AdvancementEntry advancementEntry = entry.getAdvancementEntry();
        if (this.selectedChildAdvancement == advancementEntry) {
            return;
        }
        this.selectedChildAdvancement = advancementEntry;
        log.debug("Selected child entry {}", (Object)this.selectedChildAdvancement);
    }

    private void renderNumberOfRootAdvancements(GuiGraphics guiGraphics) {
        if (this.numberOfRootAdvancements > 0) {
            float scaleFactor = 0.75f;
            MutableComponent text = Component.m_237110_((String)"advancements_tracker.advancementsScreen.numCategories", (Object[])new Object[]{this.numberOfRootAdvancements});
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scaleFactor, scaleFactor, scaleFactor);
            guiGraphics.m_280430_(this.f_96547_, (Component)text, Math.round(((float)(this.listWidth - 10) - 52.0f) / scaleFactor), Math.round((float)(this.f_96544_ - 8) / scaleFactor), 0xFFFFFF);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderAdvancementsStats(GuiGraphics guiGraphics) {
        if (this.numberOfTotalAdvancements > 0) {
            float scaleFactor = 0.75f;
            MutableComponent text = Component.m_237110_((String)"advancements_tracker.advancementsScreen.numCompleted", (Object[])new Object[]{this.numberOfCompletedAdvancements, this.numberOfTotalAdvancements});
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scaleFactor, scaleFactor, scaleFactor);
            guiGraphics.m_280430_(this.f_96547_, (Component)text, Math.round(((float)this.f_96543_ - 92.0f) / scaleFactor), Math.round((float)(this.f_96544_ - 8) / scaleFactor), 0xFFFFFF);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderCompletedCheckbox(GuiGraphics guiGraphics) {
        this.completedCheckboxX = this.listWidth;
        float scaleFactorIcon = 0.6f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scaleFactorIcon, scaleFactorIcon, scaleFactorIcon);
        guiGraphics.m_280163_(miscTexture, Math.round((float)this.completedCheckboxX / scaleFactorIcon), Math.round((float)(this.f_96544_ - 10) / scaleFactorIcon), showCompletedAdvancements ? 42.0f : 22.0f, 6.0f, 15, 15, 256, 256);
        guiGraphics.m_280168_().m_85849_();
        float scaleFactorText = 0.75f;
        MutableComponent text = Component.m_237115_((String)"advancements_tracker.advancementsScreen.showCompleted");
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scaleFactorText, scaleFactorText, scaleFactorText);
        guiGraphics.m_280430_(this.f_96547_, (Component)text, Math.round(((float)this.listWidth + 12.0f) / scaleFactorText), Math.round((float)(this.f_96544_ - 8) / scaleFactorText), 0xFFFFFF);
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderOnlyRewardedCheckbox(GuiGraphics guiGraphics) {
        this.onlyRewardedCheckboxX = this.listWidth + 78;
        float scaleFactorIcon = 0.6f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scaleFactorIcon, scaleFactorIcon, scaleFactorIcon);
        guiGraphics.m_280163_(miscTexture, Math.round((float)this.onlyRewardedCheckboxX / scaleFactorIcon), Math.round((float)(this.f_96544_ - 10) / scaleFactorIcon), showOnlyRewardedAdvancements ? 42.0f : 22.0f, 6.0f, 15, 15, 256, 256);
        guiGraphics.m_280168_().m_85849_();
        float scaleFactorText = 0.75f;
        int fontColor = showOnlyRewardedAdvancements ? 0xFF0000 : 0xFFFFFF;
        MutableComponent text = Component.m_237115_((String)"advancements_tracker.advancementsScreen.showOnlyRewarded");
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scaleFactorText, scaleFactorText, scaleFactorText);
        guiGraphics.m_280430_(this.f_96547_, (Component)text, Math.round(((float)this.listWidth + 90.0f) / scaleFactorText), Math.round((float)(this.f_96544_ - 8) / scaleFactorText), fontColor);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean showingAdvancementDetail() {
        return this.showAdvancementDetail && this.selectedChildAdvancement != null && this.showAdvancementDetailScreen != null;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.listWidth = Math.max(this.f_96543_ / 3, 100);
        int topPosition = 20;
        int categoryPanelLeftPosition = 0;
        this.advancementCategoryPanel = new AdvancementCategoryPanel(this, this.listWidth, topPosition, categoryPanelLeftPosition, this.f_96544_ - 11);
        this.advancementOverviewPanel = new AdvancementOverviewPanel(this, this.f_96543_ - this.listWidth - 12 - 1, topPosition, this.advancementCategoryPanel.getWidth() + 6, this.f_96544_ - 11);
        this.m_142416_((GuiEventListener)this.advancementCategoryPanel);
        this.m_142416_((GuiEventListener)this.advancementOverviewPanel);
        int buttonPositionX = 5;
        int buttonPositionY = this.f_96544_ - 11;
        CategorySortType.NORMAL.button = new SmallButton(buttonPositionX, buttonPositionY, 20, 10, CategorySortType.NORMAL.getButtonText(), b -> this.resortRootAdvancements(CategorySortType.NORMAL));
        this.m_142416_((GuiEventListener)CategorySortType.NORMAL.button);
        int buttonMargin = 1;
        CategorySortType.A_TO_Z.button = new SmallButton(buttonPositionX += 20 + buttonMargin, buttonPositionY, 20, 10, CategorySortType.A_TO_Z.getButtonText(), b -> this.resortRootAdvancements(CategorySortType.A_TO_Z));
        this.m_142416_((GuiEventListener)CategorySortType.A_TO_Z.button);
        CategorySortType.Z_TO_A.button = new SmallButton(buttonPositionX += 20 + buttonMargin, buttonPositionY, 20, 10, CategorySortType.Z_TO_A.getButtonText(), b -> this.resortRootAdvancements(CategorySortType.Z_TO_A));
        this.m_142416_((GuiEventListener)CategorySortType.Z_TO_A.button);
        this.reloadRootAdvancements();
        this.reloadChildAdvancements();
        this.numberOfRootAdvancements = AdvancementsManager.getNumberOfRootAdvancements();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        this.advancementCategoryPanel.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.advancementOverviewPanel.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderNumberOfRootAdvancements(guiGraphics);
        this.renderAdvancementsStats(guiGraphics);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.listWidth + 10 + 10, 8, 0xFFFFFF, false);
        this.renderCompletedCheckbox(guiGraphics);
        this.renderOnlyRewardedCheckbox(guiGraphics);
        if (this.showingAdvancementDetail()) {
            this.showAdvancementDetailScreen.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        guiGraphics.m_280024_(0, this.f_96544_ - 12, this.f_96543_, this.f_96544_, -1072689136, -804253680);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            super.m_6375_(mouseX, mouseY, button);
        }
        if (this.showingAdvancementDetail()) {
            if (this.showAdvancementDetailScreen.m_5953_(mouseX, mouseY)) {
                this.showAdvancementDetailScreen.m_6375_(mouseX, mouseY, button);
            } else {
                this.showAdvancementDetail(false);
            }
            return false;
        }
        if (mouseX > (double)this.completedCheckboxX && mouseX < (double)(this.completedCheckboxX + 8) && mouseY > (double)(this.f_96544_ - 11)) {
            AdvancementsTrackerScreen.toggleShowCompletedAdvancements();
            this.reloadChildAdvancements();
            return false;
        }
        if (mouseX > (double)this.onlyRewardedCheckboxX && mouseX < (double)(this.onlyRewardedCheckboxX + 8) && mouseY > (double)(this.f_96544_ - 11)) {
            AdvancementsTrackerScreen.toggleShowOnlyRewardedAdvancements();
            this.reloadChildAdvancements();
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.showingAdvancementDetail()) {
            this.showAdvancementDetailScreen.m_6050_(mouseX, mouseY, scroll);
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.showingAdvancementDetail()) {
            this.showAdvancementDetailScreen.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_86600_() {
        if (!this.sorted) {
            this.reloadRootAdvancements(this.sortType);
            this.reloadChildAdvancements(this.sortType);
            this.sorted = true;
        }
    }

    public boolean m_7933_(int key1, int key2, int key3) {
        if (key1 == 256 && this.showingAdvancementDetail()) {
            this.showAdvancementDetail(false);
            return false;
        }
        return super.m_7933_(key1, key2, key3);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CategorySortType implements Comparator<AdvancementEntry>
    {
        NORMAL,
        A_TO_Z{

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A{

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        Button button;

        @Override
        protected int compare(String name1, String name2) {
            return name1.equals(name2) ? 1 : 0;
        }

        @Override
        public int compare(AdvancementEntry advancement1, AdvancementEntry advancement2) {
            return this.compare(advancement1.getSortName(), advancement2.getSortName());
        }

        Component getButtonText() {
            return Component.m_237115_((String)("advancements_tracker.sort." + StringUtils.toLowerCase((String)this.name())));
        }
    }
}

