/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.advancementstracker.config;

import de.markusbordihn.advancementstracker.client.gui.widget.AdvancementsTrackerWidget;
import de.markusbordihn.advancementstracker.utils.gui.PositionManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfig {
    public static final Config CLIENT;
    static final ForgeConfigSpec clientSpec;
    private static final Logger log;

    private ClientConfig() {
    }

    @SubscribeEvent
    public static void onConfigReloading(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getSpec() == clientSpec) {
            AdvancementsTrackerWidget.reloadConfig();
        }
    }

    static {
        log = LogManager.getLogger((String)"Advancements Tracker");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Config)specPair.getLeft();
        log.info("{} Client config ...", (Object)" Register AdvancementsTracker");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue overviewEnabled;
        public final ForgeConfigSpec.BooleanValue widgetEnabled;
        public final ForgeConfigSpec.BooleanValue widgetVisible;
        public final ForgeConfigSpec.EnumValue<PositionManager.BasePosition> widgetPosition;
        public final ForgeConfigSpec.IntValue widgetHeight;
        public final ForgeConfigSpec.IntValue widgetWidth;
        public final ForgeConfigSpec.IntValue widgetTop;
        public final ForgeConfigSpec.IntValue widgetLeft;
        public final ForgeConfigSpec.ConfigValue<String> logLevel;
        public final ForgeConfigSpec.ConfigValue<List<String>> trackedAdvancements;
        public final ForgeConfigSpec.ConfigValue<List<String>> trackedAdvancementsRemote;
        public final ForgeConfigSpec.ConfigValue<List<String>> trackedAdvancementsLocal;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Advancements Tracker (Client configuration)");
            builder.push("general");
            this.trackedAdvancements = builder.comment("List of default tracked advancements, mostly used by mod packs.").define("trackedAdvancements", new ArrayList<String>(List.of("")));
            builder.pop();
            builder.push("Advancements Tracker: Overview");
            this.overviewEnabled = builder.comment("Enable/Disable the advancements overview screen.").define("overviewEnabled", true);
            builder.pop();
            builder.push("Advancements Tracker: Widget");
            this.widgetEnabled = builder.comment("Enable/Disable the advancements tracker widget.").define("widgetEnabled", true);
            this.widgetVisible = builder.comment("Shows the widget automatically. If this is set to false the widget will be only visible after pressing the defined hot-keys.").define("widgetVisible", true);
            this.widgetPosition = builder.comment("Defines the base position of the widget, default is MIDDLE_RIGHT").defineEnum("widgetPosition", (Enum)PositionManager.BasePosition.MIDDLE_RIGHT);
            this.widgetHeight = builder.comment("Defines the max. height of the widget. Default is 0 which mean use the max. available height.").defineInRange("widgetHeight", 0, 0, 600);
            this.widgetWidth = builder.comment("Defines the max.width of the widget.").defineInRange("widgetWidth", 135, 120, 600);
            this.widgetTop = builder.comment("Defines the top position relative to the widget position.").defineInRange("widgetTop", 0, -400, 400);
            this.widgetLeft = builder.comment("Defines the left position relative to the widget position.").defineInRange("widgetLeft", 0, -400, 400);
            builder.pop();
            builder.push("Debug");
            this.logLevel = builder.comment("Changed the default log level to get more output.").define("logLevel", (Object)"info");
            builder.pop();
            builder.push("cache");
            this.trackedAdvancementsRemote = builder.define("trackedAdvancementsRemote", new ArrayList<String>(List.of("")));
            this.trackedAdvancementsLocal = builder.define("trackedAdvancementsLocal", new ArrayList<String>(List.of("")));
            builder.pop();
        }
    }
}

