/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.irisflw.vertex.block;

import com.jozufozu.flywheel.core.layout.BufferLayout;
import com.jozufozu.flywheel.core.layout.CommonItems;
import com.jozufozu.flywheel.core.layout.LayoutItem;
import com.jozufozu.flywheel.core.vertex.BlockVertex;
import com.jozufozu.flywheel.core.vertex.BlockVertexListUnsafe;
import com.jozufozu.flywheel.core.vertex.BlockWriterUnsafe;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import top.leonx.irisflw.IrisFlw;
import top.leonx.irisflw.vertex.ExtendedLayoutItems;
import top.leonx.irisflw.vertex.IrisBlockVertexListUnsafe;
import top.leonx.irisflw.vertex.block.ExtendedBlockWriterUnsafe;

public class ExtendedBlockVertex
extends BlockVertex {
    public static final BufferLayout FORMAT = BufferLayout.builder().addItems(new LayoutItem[]{CommonItems.VEC3, CommonItems.RGBA, CommonItems.UV, CommonItems.LIGHT_SHORT, CommonItems.NORMAL, CommonItems.PADDING_BYTE}).build();
    public static final BufferLayout IRIS_FORMAT = BufferLayout.builder().addItems(new LayoutItem[]{CommonItems.VEC3, CommonItems.RGBA, CommonItems.UV, CommonItems.LIGHT_SHORT, CommonItems.NORMAL, CommonItems.PADDING_BYTE, CommonItems.LIGHT_SHORT, CommonItems.VEC4, CommonItems.RGBA, CommonItems.RGB, CommonItems.PADDING_BYTE}).build();
    public static final BufferLayout EXTEND_FORMAT = BufferLayout.builder().addItems(new LayoutItem[]{CommonItems.VEC3, CommonItems.RGBA, CommonItems.UV, CommonItems.LIGHT_SHORT, CommonItems.NORMAL, CommonItems.PADDING_BYTE, CommonItems.VEC4, ExtendedLayoutItems.SHORT2}).build();

    @NotNull
    public BufferLayout getLayout() {
        if (IrisFlw.isUsingExtendedVertexFormat()) {
            return EXTEND_FORMAT;
        }
        return super.getLayout();
    }

    @NotNull
    public BlockWriterUnsafe createWriter(@NotNull ByteBuffer buffer) {
        if (IrisFlw.isUsingExtendedVertexFormat()) {
            return new ExtendedBlockWriterUnsafe(this, buffer);
        }
        return super.createWriter(buffer);
    }

    @NotNull
    public BlockVertexListUnsafe createReader(@NotNull ByteBuffer buffer, int vertexCount) {
        if (IrisFlw.isUsingExtendedVertexFormat()) {
            return new IrisBlockVertexListUnsafe(buffer, vertexCount);
        }
        return super.createReader(buffer, vertexCount);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BlockVertexListUnsafe.Shaded createReader(ByteBuffer buffer, int vertexCount, int unshadedStartVertex) {
        if (IrisFlw.isUsingExtendedVertexFormat()) {
            return new IrisBlockVertexListUnsafe.Shaded(buffer, vertexCount, unshadedStartVertex);
        }
        return super.createReader(buffer, vertexCount, unshadedStartVertex);
    }

    @NotNull
    public String getShaderHeader() {
        if (IrisFlw.isUsingExtendedVertexFormat()) {
            return "layout (location = 0) in vec3 _flw_v_pos;\nlayout (location = 1) in vec4 _flw_v_color;\nlayout (location = 2) in vec2 _flw_v_texCoords;\nlayout (location = 3) in vec2 _flw_v_light;\nlayout (location = 4) in vec3 _flw_v_normal;\nlayout (location = 5) in vec4 _flw_v_packed_extended;  // x:midTexCoord, z:tangent, w:midBlock\nlayout (location = 6) in vec4 _flw_v_mc_Entity;        // x:entityId or blockId, y:render type\n\nVertex FLWCreateVertex() {\n\tVertex v;\n\tv.pos = _flw_v_pos;\n\tv.color = _flw_v_color;\n\tv.texCoords = _flw_v_texCoords;\n\tv.light = _flw_v_light;\n\tv.normal = _flw_v_normal;\n\treturn v;\n}\n";
        }
        return super.getShaderHeader();
    }
}

