/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import com.tristankechlo.random_mob_sizes.commands.ResponseHelper;
import com.tristankechlo.random_mob_sizes.commands.SamplerTypesArgumentType;
import com.tristankechlo.random_mob_sizes.config.ConfigManager;
import com.tristankechlo.random_mob_sizes.config.RandomMobSizesConfig;
import com.tristankechlo.random_mob_sizes.config.ScalingOverrides;
import com.tristankechlo.random_mob_sizes.sampler.SamplerTypes;
import com.tristankechlo.random_mob_sizes.sampler.ScalingSampler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public final class MobScalingsCommand {
    private static final String COMMAND_NAME = "mobscalings";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)COMMAND_NAME).requires(source -> source.m_6761_(3))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity_type", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256939_)).then(Commands.m_82129_((String)"scaling_type", (ArgumentType)SamplerTypesArgumentType.get()).then(Commands.m_82129_((String)"data", (ArgumentType)CompoundTagArgument.m_87657_()).executes(MobScalingsCommand::setEntityScale)))).then(Commands.m_82129_((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)10.0f)).executes(MobScalingsCommand::setEntityScaleStatic))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"entity_type", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256939_)).executes(MobScalingsCommand::removeEntityScale)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"show").then(Commands.m_82129_((String)"entity_type", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256939_)).executes(MobScalingsCommand::showEntityScale))).executes(MobScalingsCommand::showAllEntityScales));
        dispatcher.register(command);
        RandomMobSizes.LOGGER.info("Command '/{}' registered", (Object)COMMAND_NAME);
    }

    private static int setEntityScale(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            EntityType entityType = (EntityType)ResourceArgument.m_246260_(context, (String)"entity_type").m_203334_();
            SamplerTypes scalingType = (SamplerTypes)((Object)context.getArgument("scaling_type", SamplerTypes.class));
            CompoundTag data = CompoundTagArgument.m_87660_(context, (String)"data");
            return MobScalingsCommand.setEntityScale(source, entityType, scalingType, data);
        }
        catch (Exception e) {
            return MobScalingsCommand.errorHandling(source, e, "An error occurred while setting the scale for the entity type!");
        }
    }

    private static int setEntityScaleStatic(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            EntityType entityType = (EntityType)ResourceArgument.m_246260_(context, (String)"entity_type").m_203334_();
            float scale = FloatArgumentType.getFloat(context, (String)"scale");
            CompoundTag nbt = new CompoundTag();
            nbt.m_128350_("scaling", scale);
            return MobScalingsCommand.setEntityScale(source, entityType, SamplerTypes.STATIC, nbt);
        }
        catch (Exception e) {
            return MobScalingsCommand.errorHandling(source, e, "An error occurred while setting the static scale for the entity type!");
        }
    }

    private static int setEntityScale(CommandSourceStack source, EntityType<?> entityType, SamplerTypes scalingType, CompoundTag nbt) {
        RandomMobSizes.LOGGER.info("Setting scale for entity type '{}' to '{}' with data '{}'", new Object[]{entityType, scalingType, nbt});
        ResourceLocation loc = BuiltInRegistries.f_256780_.m_7981_(entityType);
        ScalingSampler sampler = scalingType.fromNBT(nbt, loc.toString());
        boolean success = RandomMobSizesConfig.SCALING_OVERRIDES.setScalingSampler(entityType, sampler);
        if (success) {
            ConfigManager.saveConfig();
            ResponseHelper.sendSuccessScalingTypeSet(source, entityType, scalingType, nbt);
        } else {
            ResponseHelper.sendErrorScalingTypeSet(source, entityType);
        }
        return 1;
    }

    private static int removeEntityScale(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            EntityType entityType = (EntityType)ResourceArgument.m_246260_(context, (String)"entity_type").m_203334_();
            RandomMobSizes.LOGGER.info("Removing scale for entity type '{}'", (Object)entityType);
            RandomMobSizesConfig.SCALING_OVERRIDES.removeScalingSampler(entityType);
            ConfigManager.saveConfig();
            ResponseHelper.sendSuccessScalingTypeRemoved(source, entityType);
            return 1;
        }
        catch (Exception e) {
            return MobScalingsCommand.errorHandling(source, e, "An error occurred while removing the scale for the entity type!");
        }
    }

    private static int showEntityScale(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            EntityType entityType = (EntityType)ResourceArgument.m_246260_(context, (String)"entity_type").m_203334_();
            ScalingSampler scalingSampler = RandomMobSizesConfig.getScalingSampler(entityType);
            if (scalingSampler == null) {
                ResponseHelper.sendErrorScalingTypeNotSet(source, entityType);
                return 0;
            }
            ResponseHelper.sendSuccessScalingType(source, entityType, scalingSampler);
            return 1;
        }
        catch (Exception e) {
            return MobScalingsCommand.errorHandling(source, e, "An error occurred while showing the scale for the entity type!");
        }
    }

    private static int showAllEntityScales(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ScalingSampler defaultSampler = RandomMobSizesConfig.getDefaultSampler();
        ResponseHelper.sendSuccessScalingType(source, "DefaultScaling", defaultSampler);
        ScalingOverrides.getIterator().forEachRemaining(entry -> ResponseHelper.sendSuccessScalingType(source, (EntityType)entry.getKey(), (ScalingSampler)entry.getValue()));
        return 1;
    }

    private static int errorHandling(CommandSourceStack source, Exception e, String text) {
        MutableComponent message = Component.m_237113_((String)text).m_130940_(ChatFormatting.RED);
        ResponseHelper.sendMessage(source, (Component)message, false);
        message = Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.RED);
        ResponseHelper.sendMessage(source, (Component)message, false);
        RandomMobSizes.LOGGER.error(text);
        RandomMobSizes.LOGGER.error(e.getMessage());
        return 0;
    }
}

