/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.commands;

import com.tristankechlo.random_mob_sizes.config.ConfigManager;
import com.tristankechlo.random_mob_sizes.sampler.SamplerTypes;
import com.tristankechlo.random_mob_sizes.sampler.ScalingSampler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;

public final class ResponseHelper {
    public static void sendMessageConfigShow(CommandSourceStack source) {
        MutableComponent clickableFile = ResponseHelper.clickableConfig();
        MutableComponent message = Component.m_237113_((String)"Config-file can be found here: ").m_7220_((Component)clickableFile);
        ResponseHelper.sendMessage(source, (Component)message.m_130940_(ChatFormatting.WHITE), false);
    }

    public static void sendMessageConfigReload(CommandSourceStack source, boolean success) {
        String text = success ? "Config was successfully reloaded." : "Error while reloading config. Check the logs for further details.";
        MutableComponent message = Component.m_237113_((String)text).m_130940_(ChatFormatting.WHITE);
        ResponseHelper.sendMessage(source, (Component)message, true);
    }

    public static void sendMessageConfigReset(CommandSourceStack source, boolean success) {
        String text = success ? "Config was successfully reset." : "Error while saving the default config.";
        MutableComponent message = Component.m_237113_((String)text).m_130940_(ChatFormatting.WHITE);
        ResponseHelper.sendMessage(source, (Component)message, true);
    }

    public static MutableComponent start() {
        return Component.m_237113_((String)"[RandomMobSizes] ").m_130940_(ChatFormatting.GOLD);
    }

    public static void sendMessage(CommandSourceStack source, Component message, boolean broadcastToOps) {
        MutableComponent start = ResponseHelper.start().m_7220_(message);
        source.m_288197_(() -> start, broadcastToOps);
    }

    public static MutableComponent clickableConfig() {
        String fileName = "random_mob_sizes.json";
        String filePath = ConfigManager.getConfigPath();
        MutableComponent mutableComponent = Component.m_237113_((String)fileName);
        mutableComponent.m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
        mutableComponent.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, filePath)));
        return mutableComponent;
    }

    public static MutableComponent clickableLink(String url, String displayText) {
        MutableComponent mutableComponent = Component.m_237113_((String)displayText);
        mutableComponent.m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE});
        mutableComponent.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
        return mutableComponent;
    }

    public static MutableComponent clickableLink(String url) {
        return ResponseHelper.clickableLink(url, url);
    }

    public static void sendSuccessScalingTypeSet(CommandSourceStack source, EntityType<?> entityType, SamplerTypes samplerTypes, CompoundTag data) {
        MutableComponent message = Component.m_237113_((String)"Scaling for ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)entityType.m_20676_().getString()).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)" was set to ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)samplerTypes.toString()).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)" with data ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)data.toString()).m_130940_(ChatFormatting.GREEN));
        ResponseHelper.sendMessage(source, (Component)message, true);
    }

    public static void sendErrorScalingTypeSet(CommandSourceStack source, EntityType<?> entityType) {
        MutableComponent message = Component.m_237113_((String)"Scaling for ").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237113_((String)entityType.m_20676_().getString()).m_130940_(ChatFormatting.DARK_RED)).m_7220_((Component)Component.m_237113_((String)" is now allowed!").m_130940_(ChatFormatting.RED));
        ResponseHelper.sendMessage(source, (Component)message, true);
    }

    public static void sendSuccessScalingTypeRemoved(CommandSourceStack source, EntityType<?> entityType) {
        MutableComponent message = Component.m_237113_((String)"Scaling for ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)entityType.m_20676_().getString()).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)" was removed from the config.").m_130940_(ChatFormatting.WHITE));
        ResponseHelper.sendMessage(source, (Component)message, true);
    }

    public static void sendErrorScalingTypeNotSet(CommandSourceStack source, EntityType<?> entityType) {
        MutableComponent message = Component.m_237113_((String)"Scaling for ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)entityType.m_20676_().getString()).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)" is not set in the config.").m_130940_(ChatFormatting.WHITE));
        ResponseHelper.sendMessage(source, (Component)message, false);
    }

    public static void sendSuccessScalingType(CommandSourceStack source, EntityType<?> entityType, ScalingSampler sampler) {
        ResponseHelper.sendSuccessScalingType(source, entityType.m_20676_().getString(), sampler);
    }

    public static void sendSuccessScalingType(CommandSourceStack source, String entityType, ScalingSampler sampler) {
        MutableComponent entity = Component.m_237113_((String)entityType).m_130940_(ChatFormatting.GREEN);
        MutableComponent result = Component.m_237113_((String)sampler.serialize().toString()).m_130940_(ChatFormatting.GREEN);
        MutableComponent message = Component.m_237110_((String)"Scaling for %s is set to %s", (Object[])new Object[]{entity, result}).m_130940_(ChatFormatting.WHITE);
        ResponseHelper.sendMessage(source, (Component)message, false);
    }
}

