/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.tristankechlo.random_mob_sizes.sampler.SamplerTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class SamplerTypesArgumentType
implements ArgumentType<SamplerTypes> {
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(o -> Component.m_237113_((String)("Invalid sampler type: " + o)));
    private static final Collection<String> EXAMPLES = Stream.of(SamplerTypes.values()).map(SamplerTypes::m_7912_).toList();
    private static final SamplerTypes[] VALUES = SamplerTypes.values();

    public SamplerTypes parse(StringReader reader) throws CommandSyntaxException {
        String s = reader.readUnquotedString();
        SamplerTypes type = SamplerTypes.byName(s, null);
        if (type == null) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader, (Object)s);
        }
        return type;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof SharedSuggestionProvider) {
            return SharedSuggestionProvider.m_82981_(Arrays.stream(VALUES).map(SamplerTypes::m_7912_), (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static SamplerTypesArgumentType get() {
        return new SamplerTypesArgumentType();
    }

    public static SamplerTypes getSamplerType(CommandContext<?> context, String name) {
        return (SamplerTypes)((Object)context.getArgument(name, SamplerTypes.class));
    }
}

