/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.tristankechlo.random_mob_sizes.IPlatformHelper;
import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import com.tristankechlo.random_mob_sizes.config.RandomMobSizesConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ConfigManager {
    private static final File CONFIG_DIR = IPlatformHelper.INSTANCE.getConfigDirectory().toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    public static final String FILE_NAME = "random_mob_sizes.json";
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "random_mob_sizes.json");

    public static boolean loadAndVerifyConfig() {
        ConfigManager.createConfigFolder();
        RandomMobSizesConfig.setToDefault();
        if (CONFIG_FILE.exists()) {
            boolean success = true;
            AtomicBoolean makeBackup = new AtomicBoolean(false);
            try {
                ConfigManager.loadConfigFromFile(() -> makeBackup.set(true));
                RandomMobSizes.LOGGER.info("Config '{}' was successfully loaded.", (Object)FILE_NAME);
            }
            catch (Exception e) {
                RandomMobSizes.LOGGER.error(e.getMessage());
                RandomMobSizes.LOGGER.error("Error loading config '{}', config hasn't been loaded. Using default config.", (Object)FILE_NAME);
                ConfigManager.backupConfig();
                RandomMobSizesConfig.setToDefault();
                success = false;
            }
            if (makeBackup.get()) {
                ConfigManager.backupConfig();
                success = false;
            }
            ConfigManager.writeConfigToFile();
            return success;
        }
        ConfigManager.writeConfigToFile();
        RandomMobSizes.LOGGER.warn("No config '{}' was found, created a new one.", (Object)FILE_NAME);
        return true;
    }

    private static void loadConfigFromFile(Runnable setMakeBackup) throws FileNotFoundException {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse((Reader)new FileReader(CONFIG_FILE));
        JsonObject json = jsonElement.getAsJsonObject();
        RandomMobSizesConfig.deserialize(json, setMakeBackup);
    }

    private static void writeConfigToFile() {
        try {
            JsonObject jsonObject = RandomMobSizesConfig.serialize();
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(CONFIG_FILE));
            writer.setIndent("\t");
            GSON.toJson((JsonElement)jsonObject, writer);
            writer.close();
        }
        catch (Exception e) {
            RandomMobSizes.LOGGER.error("There was an error writing the config to file: '{}'", (Object)FILE_NAME);
            RandomMobSizes.LOGGER.error(e.getMessage());
        }
    }

    private static void backupConfig() {
        String backupFileName = FILE_NAME.replace(".json", ".backup.txt");
        Path backupFilePath = Paths.get(CONFIG_DIR.getAbsolutePath(), backupFileName);
        try {
            List<String> lines = Files.readAllLines(CONFIG_FILE.toPath());
            Files.write(backupFilePath, lines, new OpenOption[0]);
            RandomMobSizes.LOGGER.warn("Created backup file '{}'", (Object)backupFileName);
        }
        catch (Exception e) {
            RandomMobSizes.LOGGER.error("Error creating backup file '{}'", (Object)backupFileName);
            RandomMobSizes.LOGGER.error(e.getMessage());
        }
    }

    public static boolean resetConfig() {
        try {
            RandomMobSizesConfig.setToDefault();
            ConfigManager.writeConfigToFile();
            RandomMobSizes.LOGGER.info("Config '{}' was set to default.", (Object)FILE_NAME);
            return true;
        }
        catch (Exception e) {
            RandomMobSizes.LOGGER.error("Error resetting config '{}'", (Object)FILE_NAME);
            RandomMobSizes.LOGGER.error(e.getMessage());
            return false;
        }
    }

    public static boolean saveConfig() {
        try {
            ConfigManager.writeConfigToFile();
            RandomMobSizes.LOGGER.info("Config '{}' was saved.", (Object)FILE_NAME);
            return true;
        }
        catch (Exception e) {
            RandomMobSizes.LOGGER.error("Error saving config '{}'", (Object)FILE_NAME);
            RandomMobSizes.LOGGER.error(e.getMessage());
            return false;
        }
    }

    public static boolean reloadConfig() {
        try {
            return ConfigManager.loadAndVerifyConfig();
        }
        catch (Exception e) {
            RandomMobSizes.LOGGER.error("Error reloading config '{}'", (Object)FILE_NAME);
            RandomMobSizes.LOGGER.error(e.getMessage());
            return false;
        }
    }

    public static String getConfigPath() {
        return CONFIG_FILE.getAbsolutePath();
    }

    private static void createConfigFolder() {
        if (!CONFIG_DIR.exists() && !CONFIG_DIR.mkdirs()) {
            throw new RuntimeException("Could not create config folder: " + CONFIG_DIR.getAbsolutePath());
        }
    }
}

