/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.random_mob_sizes.IPlatformHelper;
import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;

public final class EntityTypeList
implements Supplier<List<EntityType<?>>> {
    private final String key;
    private ImmutableList<String> parsedValues;
    private ImmutableList<EntityType<?>> cachedValue;
    private final ImmutableList<String> defaultValue;

    public EntityTypeList(String key, List<String> stringValues) {
        this(key, stringValues, (List<EntityType<?>>)EntityTypeList.parseList(stringValues, key, () -> {}));
    }

    public EntityTypeList(String key, EntityType<?> ... entityTypes) {
        this(key, Arrays.stream(entityTypes).map(EntityType::m_20613_).map(ResourceLocation::toString).toList(), List.of(entityTypes));
    }

    private EntityTypeList(String key, List<String> stringValues, List<EntityType<?>> entityTypes) {
        this.key = key;
        this.cachedValue = ImmutableList.copyOf(entityTypes);
        this.defaultValue = ImmutableList.copyOf(stringValues);
        this.parsedValues = ImmutableList.copyOf(stringValues);
    }

    public void setToDefault() {
        this.cachedValue = EntityTypeList.parseList(this.defaultValue, this.key, () -> {});
        this.parsedValues = ImmutableList.copyOf(this.defaultValue);
    }

    public void serialize(JsonObject json) {
        JsonArray array = new JsonArray();
        for (String value : this.parsedValues) {
            array.add(value);
        }
        json.add(this.key, (JsonElement)array);
    }

    public void deserialize(JsonObject json, Runnable setMakeBackup) {
        try {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)this.key);
            List elements = array.asList();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement element : elements) {
                String value = GsonHelper.m_13805_((JsonElement)element, (String)this.key);
                builder.add((Object)value);
            }
            this.parsedValues = builder.build();
            this.cachedValue = EntityTypeList.parseList(this.parsedValues, this.key, setMakeBackup);
        }
        catch (Exception e) {
            RandomMobSizes.LOGGER.error("Error while parsing config value '{}', using default value", (Object)this.key);
            RandomMobSizes.LOGGER.error(e.getMessage());
            this.setToDefault();
            setMakeBackup.run();
        }
    }

    @Override
    public List<EntityType<?>> get() {
        return this.cachedValue;
    }

    private static ImmutableList<EntityType<?>> parseList(List<String> values, String key, Runnable setMakeBackup) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String value : values) {
            if (value.endsWith(":*")) {
                String namespace = value.substring(0, value.length() - 2);
                if (!IPlatformHelper.INSTANCE.isModLoaded(namespace)) {
                    RandomMobSizes.LOGGER.error("Skipping unknown wildcard: '{}' of config value '{}'", (Object)namespace, (Object)key);
                    setMakeBackup.run();
                    continue;
                }
                BuiltInRegistries.f_256780_.m_123024_().filter(entityType -> EntityType.m_20613_((EntityType)entityType).m_135827_().equals(namespace)).filter(RandomMobSizes::isEntityTypeAllowed).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                continue;
            }
            Optional type = EntityType.m_20632_((String)value);
            if (type.isPresent()) {
                if (RandomMobSizes.isEntityTypeAllowed((EntityType)type.get())) {
                    builder.add((Object)((EntityType)type.get()));
                    continue;
                }
                RandomMobSizes.LOGGER.error("Skipping disabled EntityType: '{}' of config value '{}'", (Object)value, (Object)key);
                setMakeBackup.run();
                continue;
            }
            RandomMobSizes.LOGGER.error("Skipping unknown EntityType: '{}' of config value '{}'", (Object)value, (Object)key);
            setMakeBackup.run();
        }
        return builder.build();
    }
}

