/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import com.tristankechlo.random_mob_sizes.sampler.AttributeScalingTypes;
import com.tristankechlo.random_mob_sizes.sampler.ScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.DifficultyScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.GaussianScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.StaticScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.UniformScalingSampler;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;

public final class ScalingOverrides {
    private static final String JSON_KEY = "scaling_overrides";
    private static Map<EntityType<?>, ScalingSampler> SETTINGS = new HashMap();

    public void setToDefault() {
        SETTINGS = new HashMap();
        SETTINGS.put(EntityType.f_20557_, new GaussianScalingSampler(0.5f, 1.5f));
        SETTINGS.put(EntityType.f_20520_, new GaussianScalingSampler(0.5f, 1.5f));
        SETTINGS.put(EntityType.f_20510_, new GaussianScalingSampler(0.5f, 1.5f));
        SETTINGS.put(EntityType.f_20555_, new UniformScalingSampler(0.5f, 1.5f, AttributeScalingTypes.SQUARE, AttributeScalingTypes.NONE, AttributeScalingTypes.INVERSE_SQUARE));
        SETTINGS.put(EntityType.f_217012_, new GaussianScalingSampler(0.5f, 1.5f));
        NonNullList samplers = NonNullList.m_122780_((int)Difficulty.values().length, (Object)new StaticScalingSampler(1.0f));
        samplers.set(Difficulty.PEACEFUL.m_19028_(), (Object)new StaticScalingSampler(1.3f));
        samplers.set(Difficulty.EASY.m_19028_(), (Object)new StaticScalingSampler(1.15f));
        samplers.set(Difficulty.NORMAL.m_19028_(), (Object)new StaticScalingSampler(1.0f));
        samplers.set(Difficulty.HARD.m_19028_(), (Object)new StaticScalingSampler(0.75f));
        SETTINGS.put(EntityType.f_20501_, new DifficultyScalingSampler((NonNullList<ScalingSampler>)samplers));
    }

    public void serialize(JsonObject json) {
        JsonObject scalingOverrides = new JsonObject();
        List<Pair> settings = SETTINGS.entrySet().parallelStream().map(entry -> {
            ResourceLocation location = EntityType.m_20613_((EntityType)((EntityType)entry.getKey()));
            return new Pair((Object)location, (Object)((ScalingSampler)entry.getValue()));
        }).sorted(Comparator.comparing(Pair::getFirst)).toList();
        settings.forEach(pair -> {
            String location = ((ResourceLocation)pair.getFirst()).toString();
            JsonElement element = ((ScalingSampler)pair.getSecond()).serialize();
            scalingOverrides.add(location, element);
        });
        json.add(JSON_KEY, (JsonElement)scalingOverrides);
    }

    public void deserialize(JsonObject jsonObject, Runnable setMakeBackup) {
        JsonObject json = GsonHelper.m_13930_((JsonObject)jsonObject, (String)JSON_KEY);
        HashMap newSettings = new HashMap();
        json.asMap().forEach((key, value) -> {
            Optional entityType = EntityType.m_20632_((String)key);
            if (entityType.isEmpty()) {
                RandomMobSizes.LOGGER.error("Error loading config, skipping unknown entity: '{}'", key);
                setMakeBackup.run();
                return;
            }
            try {
                EntityType type = (EntityType)entityType.get();
                ScalingSampler scalingSampler = ScalingSampler.deserializeSampler(value, key);
                newSettings.put(type, scalingSampler);
            }
            catch (Exception e) {
                RandomMobSizes.LOGGER.error("Error while parsing '{}', skipping scaling for entity '{}'", (Object)JSON_KEY, key);
                RandomMobSizes.LOGGER.error(e.getMessage());
                setMakeBackup.run();
            }
        });
        SETTINGS.clear();
        SETTINGS.putAll(newSettings);
    }

    public ScalingSampler getSampler(EntityType<?> entityType) {
        return SETTINGS.get(entityType);
    }

    public boolean setScalingSampler(EntityType<?> entityType, ScalingSampler scalingSampler) {
        if (!RandomMobSizes.isEntityTypeAllowed(entityType)) {
            return false;
        }
        SETTINGS.put(entityType, scalingSampler);
        return true;
    }

    public void removeScalingSampler(EntityType<?> entityType) {
        SETTINGS.remove(entityType);
    }

    public static Iterator<Map.Entry<EntityType<?>, ScalingSampler>> getIterator() {
        return SETTINGS.entrySet().iterator();
    }
}

