/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.mixin.entity;

import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import com.tristankechlo.random_mob_sizes.mixin_helper.MobMixinAddon;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Redirect(method={"dropFromLootTable"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootTable;getRandomItems(Lnet/minecraft/world/level/storage/loot/LootParams;JLjava/util/function/Consumer;)V"))
    private void dropFromLootTable$RandomMobSizes(LootTable instance, LootParams params, long seed, Consumer<ItemStack> spawnAtLocation) {
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof MobMixinAddon) || !RandomMobSizes.isEntityTypeAllowed(entity.m_6095_())) {
            instance.m_287276_(params, seed, spawnAtLocation);
            return;
        }
        MobMixinAddon mob = (MobMixinAddon)entity;
        if (!mob.shouldScaleLoot$RandomMobSizes()) {
            instance.m_287276_(params, seed, spawnAtLocation);
            return;
        }
        float scaling = mob.getMobScaling$RandomMobSizes();
        RandomSource random = params.m_287182_().m_213780_();
        Consumer stackSplitter = LootTable.m_246283_((ServerLevel)params.m_287182_(), spawnAtLocation);
        instance.m_287276_(params, seed, stack -> this.handleLoot$RandomMobSizes(scaling, random, (ItemStack)stack, stackSplitter));
    }

    private void handleLoot$RandomMobSizes(float scaling, RandomSource random, ItemStack stack, Consumer<ItemStack> stackSplitter) {
        if (scaling <= 1.0f && stack.m_41613_() == 1) {
            if (random.m_188500_() <= (double)scaling) {
                stackSplitter.accept(stack);
            }
            return;
        }
        int count = Math.round((float)stack.m_41613_() * scaling);
        if (count == 0 || stack.m_41613_() == 0) {
            return;
        }
        stack.m_41764_(count);
        stackSplitter.accept(stack);
    }

    @ModifyArg(method={"dropExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"), index=2)
    private int calculateExperienceOnDeath$RandomMobSizes(int xp) {
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof MobMixinAddon) || !RandomMobSizes.isEntityTypeAllowed(entity.m_6095_())) {
            return xp;
        }
        MobMixinAddon mob = (MobMixinAddon)entity;
        if (!mob.shouldScaleXP$RandomMobSizes()) {
            return xp;
        }
        float scaling = mob.getMobScaling$RandomMobSizes();
        return Math.round((float)xp * scaling);
    }
}

