/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.mixin.entity;

import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import com.tristankechlo.random_mob_sizes.config.RandomMobSizesConfig;
import com.tristankechlo.random_mob_sizes.mixin_helper.MobMixinAddon;
import com.tristankechlo.random_mob_sizes.sampler.ScalingSampler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
implements MobMixinAddon {
    private static final EntityDataAccessor<Float> SCALING$RANDOM_MOB_SIZES = SynchedEntityData.m_135353_(Mob.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Unique
    private boolean scaleLoot$RandomMobSizes = false;
    @Unique
    private boolean scaleExperience$RandomMobSizes = false;

    @Override
    public float getMobScaling$RandomMobSizes() {
        return ((Float)((Mob)this).m_20088_().m_135370_(SCALING$RANDOM_MOB_SIZES)).floatValue();
    }

    @Override
    public void setMobScaling$RandomMobSizes(float scale) {
        ((Mob)this).m_20088_().m_135381_(SCALING$RANDOM_MOB_SIZES, (Object)Float.valueOf(scale));
    }

    @Override
    public EntityDataAccessor<Float> getTracker$RandomMobSizes() {
        return SCALING$RANDOM_MOB_SIZES;
    }

    @Override
    public boolean shouldScaleLoot$RandomMobSizes() {
        return this.scaleLoot$RandomMobSizes;
    }

    @Override
    public void setShouldScaleLoot$RandomMobSizes(boolean shouldScale) {
        this.scaleLoot$RandomMobSizes = shouldScale;
    }

    @Override
    public boolean shouldScaleXP$RandomMobSizes() {
        return this.scaleExperience$RandomMobSizes;
    }

    @Override
    public void setShouldScaleXP$RandomMobSizes(boolean shouldScale) {
        this.scaleExperience$RandomMobSizes = shouldScale;
    }

    @Override
    public void doFinalizeSpawn$RandomMobSizes(ServerLevelAccessor level) {
        EntityType type = ((Mob)this).m_6095_();
        if (level.m_5776_() || !RandomMobSizes.isEntityTypeAllowed(type)) {
            return;
        }
        ScalingSampler sampler = RandomMobSizesConfig.getScalingSampler(type);
        Difficulty difficulty = level.m_46791_();
        float scaling = 1.0f;
        if (sampler != null) {
            scaling = sampler.sample(level.m_213780_(), level.m_46791_());
            if (sampler.shouldScaleHealth(difficulty)) {
                float healthScaling = sampler.getHealthScaler(difficulty).apply(scaling);
                float maxHealth = this.addModifier$RandomMobSizes(Attributes.f_22276_, healthScaling, true);
                ((LivingEntity)this).m_21153_(maxHealth);
            }
            if (sampler.shouldScaleDamage(difficulty)) {
                float damageScaling = sampler.getDamageScaler(difficulty).apply(scaling);
                this.addModifier$RandomMobSizes(Attributes.f_22281_, damageScaling, true);
            }
            if (sampler.shouldScaleSpeed(difficulty)) {
                float speedScaling = sampler.getSpeedScaler(difficulty).apply(scaling);
                this.addModifier$RandomMobSizes(Attributes.f_22279_, speedScaling, false);
            }
        }
        boolean shouldScaleLoot = sampler == null || sampler.shouldScaleLoot(difficulty);
        this.setShouldScaleLoot$RandomMobSizes(shouldScaleLoot);
        boolean shouldScaleXP = sampler == null || sampler.shouldScaleXP(difficulty);
        this.setShouldScaleXP$RandomMobSizes(shouldScaleXP);
        this.setMobScaling$RandomMobSizes(scaling);
    }

    @Inject(at={@At(value="TAIL")}, method={"finalizeSpawn"})
    private void finalizeSpawn$RandomMobSizes(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData data, CompoundTag nbt, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.doFinalizeSpawn$RandomMobSizes(level);
    }

    private float addModifier$RandomMobSizes(Attribute attribute, float scaling, boolean ceil) {
        AttributeInstance instance = ((LivingEntity)this).m_21051_(attribute);
        if (instance != null) {
            double baseValue = instance.m_22115_();
            float newValue = (float)(ceil ? Math.ceil(baseValue * (double)scaling) : baseValue * (double)scaling);
            instance.m_22100_((double)newValue);
            return newValue;
        }
        return 1.0f;
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void defineSyncedData$RandomMobSizes(CallbackInfo ci) {
        ((Mob)this).m_20088_().m_135372_(SCALING$RANDOM_MOB_SIZES, (Object)Float.valueOf(1.0f));
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void readAdditionalSaveData$RandomMobSizes(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_("ScaleFactor")) {
            this.setMobScaling$RandomMobSizes(tag.m_128457_("ScaleFactor"));
        }
        if (tag.m_128441_("ScaleLoot")) {
            this.setShouldScaleLoot$RandomMobSizes(tag.m_128471_("ScaleLoot"));
        }
        if (tag.m_128441_("ScaleExperience")) {
            this.setShouldScaleXP$RandomMobSizes(tag.m_128471_("ScaleExperience"));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void addAdditionalSaveData$RandomMobSizes(CompoundTag tag, CallbackInfo ci) {
        tag.m_128350_("ScaleFactor", this.getMobScaling$RandomMobSizes());
        tag.m_128379_("ScaleLoot", this.shouldScaleLoot$RandomMobSizes());
        tag.m_128379_("ScaleExperience", this.shouldScaleXP$RandomMobSizes());
    }

    @Inject(at={@At(value="TAIL")}, method={"convertTo"})
    private <T extends Mob> void convertTo$RandomMobSizes(EntityType<T> type, boolean $$1, CallbackInfoReturnable<T> cir) {
        if (!RandomMobSizesConfig.keepScalingOnConversion() || !RandomMobSizes.isEntityTypeAllowed(type)) {
            return;
        }
        float scaling = this.getMobScaling$RandomMobSizes();
        boolean scaleLoot = this.shouldScaleLoot$RandomMobSizes();
        boolean scaleXP = this.shouldScaleXP$RandomMobSizes();
        Mob entity = (Mob)cir.getReturnValue();
        ((MobMixinAddon)entity).setMobScaling$RandomMobSizes(scaling);
        ((MobMixinAddon)entity).setShouldScaleLoot$RandomMobSizes(scaleLoot);
        ((MobMixinAddon)entity).setShouldScaleXP$RandomMobSizes(scaleXP);
        RandomMobSizes.LOGGER.info("Converted '{}' to '{}' with scaling '{}'", new Object[]{this.getClass().getSimpleName(), entity.getClass().getSimpleName(), Float.valueOf(scaling)});
    }
}

