/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.sampler;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.StringRepresentable;

public enum AttributeScalingTypes implements StringRepresentable
{
    NONE("none", value -> Float.valueOf(1.0f)),
    NORMAL("normal", value -> value),
    SQUARE("square", value -> Float.valueOf(value.floatValue() * value.floatValue())),
    INVERSE("inverse", value -> Float.valueOf(1.0f / value.floatValue())),
    INVERSE_SQUARE("inverse_square", value -> Float.valueOf(1.0f / (value.floatValue() * value.floatValue()))),
    SQUARE_HALVED("square_halved", value -> Float.valueOf(1.0f + (value.floatValue() * value.floatValue() - 1.0f) * 0.5f)),
    INVERSE_HALVED("inverse_halved", value -> Float.valueOf(1.0f + (1.0f / value.floatValue() - 1.0f) * 0.5f)),
    INVERSE_SQUARE_HALVED("inverse_square_halved", value -> Float.valueOf(1.0f + (1.0f / (value.floatValue() * value.floatValue()) - 1.0f) * 0.5f));

    public static final StringRepresentable.EnumCodec<AttributeScalingTypes> CODEC;
    private final String name;
    private final Function<Float, Float> modifier;

    private AttributeScalingTypes(String name, Function<Float, Float> modifier) {
        this.name = name;
        this.modifier = modifier;
    }

    public String m_7912_() {
        return this.name;
    }

    public float apply(float value) {
        return this.modifier.apply(Float.valueOf(value)).floatValue();
    }

    public static AttributeScalingTypes byName(String name) {
        return Objects.requireNonNull((AttributeScalingTypes)CODEC.m_216455_(name), "Unknown scaling type '" + name + "'");
    }

    static {
        CODEC = StringRepresentable.m_216439_(AttributeScalingTypes::values);
    }
}

