/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.sampler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.random_mob_sizes.mixin.CompoundTagInvoker;
import com.tristankechlo.random_mob_sizes.sampler.ScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.DifficultyScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.GaussianScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.StaticScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.UniformScalingSampler;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;

public enum SamplerTypes implements StringRepresentable
{
    STATIC("static", StaticScalingSampler::new),
    UNIFORM("uniform", UniformScalingSampler::new),
    GAUSSIAN("gaussian", GaussianScalingSampler::new),
    DIFFICULTY("difficulty", DifficultyScalingSampler::new);

    public static final StringRepresentable.EnumCodec<SamplerTypes> CODEC;
    private final String name;
    private final BiFunction<JsonElement, String, ScalingSampler> jsonDeserializer;

    private SamplerTypes(String name, BiFunction<JsonElement, String, ScalingSampler> fromJson) {
        this.name = name;
        this.jsonDeserializer = fromJson;
    }

    public static SamplerTypes byName(String name, SamplerTypes fallback) {
        SamplerTypes type = (SamplerTypes)CODEC.m_216455_(name);
        return type != null ? type : fallback;
    }

    public ScalingSampler fromJson(JsonElement json, String entityType) {
        return this.jsonDeserializer.apply(json, entityType);
    }

    public ScalingSampler fromNBT(CompoundTag nbt, String entityType) {
        Map<String, Tag> map = ((CompoundTagInvoker)nbt).getEntries();
        JsonObject json = new JsonObject();
        for (Map.Entry<String, Tag> entry : map.entrySet()) {
            byte id = entry.getValue().m_7060_();
            if (id == 5 || id == 6 || id == 3 || id == 4) {
                json.addProperty(entry.getKey(), ((NumericTag)entry.getValue()).m_8103_());
            }
            if (id == 1) {
                json.addProperty(entry.getKey(), Boolean.valueOf(((NumericTag)entry.getValue()).m_7063_() != 0));
            }
            if (id != 8) continue;
            json.addProperty(entry.getKey(), entry.getValue().m_7916_());
        }
        return this.fromJson((JsonElement)json, entityType);
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.m_216439_(SamplerTypes::values);
    }
}

