/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.sampler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import com.tristankechlo.random_mob_sizes.sampler.AttributeScalingTypes;
import com.tristankechlo.random_mob_sizes.sampler.SamplerTypes;
import com.tristankechlo.random_mob_sizes.sampler.types.StaticScalingSampler;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;

public abstract class ScalingSampler {
    public static final float MINIMUM_SCALING = 0.1f;
    public static final float MAXIMUM_SCALING = 10.0f;
    protected final AttributeScalingTypes scaleHealth;
    protected final AttributeScalingTypes scaleDamage;
    protected final AttributeScalingTypes scaleSpeed;
    protected boolean addAttributeModifiers = true;
    protected boolean shouldScaleLoot = true;
    protected boolean shouldScaleXP = true;

    protected ScalingSampler() {
        this(AttributeScalingTypes.NORMAL, AttributeScalingTypes.NORMAL, AttributeScalingTypes.INVERSE);
    }

    protected ScalingSampler(AttributeScalingTypes health, AttributeScalingTypes damage, AttributeScalingTypes speed) {
        this.scaleHealth = health;
        this.scaleDamage = damage;
        this.scaleSpeed = speed;
    }

    protected ScalingSampler(JsonElement jsonElement, String entityType) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)entityType);
        this.scaleHealth = AttributeScalingTypes.byName(GsonHelper.m_13851_((JsonObject)json, (String)"scale_health", (String)"none"));
        this.scaleDamage = AttributeScalingTypes.byName(GsonHelper.m_13851_((JsonObject)json, (String)"scale_damage", (String)"none"));
        this.scaleSpeed = AttributeScalingTypes.byName(GsonHelper.m_13851_((JsonObject)json, (String)"scale_speed", (String)"none"));
        this.shouldScaleLoot = this.getBooleanSafe(json, "scale_loot", entityType, true);
        this.shouldScaleXP = this.getBooleanSafe(json, "scale_xp", entityType, true);
    }

    protected abstract float sampleScalingFactor(RandomSource var1, Difficulty var2);

    public final float sample(RandomSource random, Difficulty difficulty) {
        float value = this.sampleScalingFactor(random, difficulty);
        return Mth.m_14036_((float)value, (float)0.1f, (float)10.0f);
    }

    protected abstract JsonObject serialize(JsonObject var1);

    public final JsonElement serialize() {
        JsonObject json = new JsonObject();
        json = this.serialize(json);
        if (this.addAttributeModifiers) {
            json.addProperty("scale_loot", Boolean.valueOf(this.shouldScaleLoot));
            json.addProperty("scale_xp", Boolean.valueOf(this.shouldScaleXP));
            json.addProperty("scale_health", this.scaleHealth.m_7912_());
            json.addProperty("scale_damage", this.scaleDamage.m_7912_());
            json.addProperty("scale_speed", this.scaleSpeed.m_7912_());
        }
        return json;
    }

    public boolean shouldScaleHealth(Difficulty difficulty) {
        return this.scaleHealth != AttributeScalingTypes.NONE;
    }

    public AttributeScalingTypes getHealthScaler(Difficulty difficulty) {
        return this.scaleHealth;
    }

    public boolean shouldScaleDamage(Difficulty difficulty) {
        return this.scaleDamage != AttributeScalingTypes.NONE;
    }

    public AttributeScalingTypes getDamageScaler(Difficulty difficulty) {
        return this.scaleDamage;
    }

    public boolean shouldScaleSpeed(Difficulty difficulty) {
        return this.scaleSpeed != AttributeScalingTypes.NONE;
    }

    public AttributeScalingTypes getSpeedScaler(Difficulty difficulty) {
        return this.scaleSpeed;
    }

    public boolean shouldScaleLoot(Difficulty difficulty) {
        return this.shouldScaleLoot;
    }

    public boolean shouldScaleXP(Difficulty difficulty) {
        return this.shouldScaleXP;
    }

    public static ScalingSampler deserializeSampler(JsonElement jsonElement, String entityType) {
        if (GsonHelper.m_13872_((JsonElement)jsonElement)) {
            return new StaticScalingSampler(jsonElement.getAsFloat());
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)jsonElement, (String)entityType);
            String type = jsonObject.get("type").getAsString();
            SamplerTypes samplerType = SamplerTypes.byName(type, null);
            if (samplerType == null) {
                throw new JsonParseException("Unknown ScalingType: " + type);
            }
            return samplerType.fromJson(jsonElement, entityType);
        }
        throw new JsonParseException("ScalingType must be a NumberValue or JsonObject");
    }

    protected static void ensureMinSmallerMax(float min, float max, String entityType) {
        if (min >= max) {
            throw new JsonParseException("'min_scaling' must be smaller than 'max_scaling' for '" + entityType + "' (can not be equal)");
        }
    }

    protected static float getFloatSafe(JsonObject json, String key, String entityType) {
        return ScalingSampler.getFloatSafe(json, key, 0.1f, 10.0f, entityType);
    }

    protected static float getFloatSafe(JsonObject json, String key, float min, float max, String entityType) {
        float temp = GsonHelper.m_13915_((JsonObject)json, (String)key);
        if (ScalingSampler.isFloatOutOfBounds(temp, min, max)) {
            temp = Mth.m_14036_((float)temp, (float)min, (float)max);
            RandomMobSizes.LOGGER.error("'{}' for '{}' is out of range[{} - {}], using {} instead", new Object[]{key, entityType, Float.valueOf(min), Float.valueOf(max), Float.valueOf(temp)});
        }
        return temp;
    }

    protected static boolean isFloatOutOfBounds(float value, float min, float max) {
        return value < min || value > max;
    }

    private boolean getBooleanSafe(JsonObject json, String key, String entityType, boolean def) {
        if (GsonHelper.m_13880_((JsonObject)json, (String)key)) {
            return GsonHelper.m_13912_((JsonObject)json, (String)key);
        }
        RandomMobSizes.LOGGER.error("Expected '{}' to be a Boolean", (Object)key);
        RandomMobSizes.LOGGER.error("Error while parsing config value '{}' for entity '{}', using default value.", (Object)key, (Object)entityType);
        return def;
    }
}

