/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.sampler.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import com.tristankechlo.random_mob_sizes.sampler.AttributeScalingTypes;
import com.tristankechlo.random_mob_sizes.sampler.ScalingSampler;
import com.tristankechlo.random_mob_sizes.sampler.types.StaticScalingSampler;
import net.minecraft.core.NonNullList;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;

public class DifficultyScalingSampler
extends ScalingSampler {
    public static final String TYPE = "difficulty";
    protected final NonNullList<ScalingSampler> samplers;

    public DifficultyScalingSampler(NonNullList<ScalingSampler> samplers) {
        this.samplers = samplers;
        this.addAttributeModifiers = false;
    }

    public DifficultyScalingSampler(JsonElement jsonElement, String entityType) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)entityType);
        this.samplers = NonNullList.m_122780_((int)Difficulty.values().length, (Object)new StaticScalingSampler(1.0f));
        for (Difficulty difficulty : Difficulty.values()) {
            String key = difficulty.m_7912_();
            if (!json.has(key)) {
                RandomMobSizes.LOGGER.warn("Difficulty scaling sampler for entity type: '{}' and difficulty: '{}' is missing, using fallback instead", (Object)entityType, (Object)key);
                continue;
            }
            try {
                ScalingSampler sampler = ScalingSampler.deserializeSampler(json.get(key), entityType);
                if (sampler instanceof DifficultyScalingSampler) {
                    throw new IllegalArgumentException("Can not use type 'difficulty' inside a scaler of type 'difficulty'!");
                }
                this.samplers.set(difficulty.m_19028_(), (Object)sampler);
            }
            catch (Exception e) {
                RandomMobSizes.LOGGER.error("Error while parsing the difficulty scaling sampler for entity type: '{}' and difficulty: '{}'", (Object)entityType, (Object)key);
                throw e;
            }
        }
        this.addAttributeModifiers = false;
    }

    @Override
    protected JsonObject serialize(JsonObject json) {
        json.addProperty("type", TYPE);
        for (Difficulty difficulty : Difficulty.values()) {
            JsonElement difficultyJson = ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).serialize();
            json.add(difficulty.m_7912_(), difficultyJson);
        }
        return json;
    }

    @Override
    protected float sampleScalingFactor(RandomSource random, Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).sample(random, difficulty);
    }

    @Override
    public boolean shouldScaleDamage(Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).shouldScaleDamage(difficulty);
    }

    @Override
    public boolean shouldScaleHealth(Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).shouldScaleHealth(difficulty);
    }

    @Override
    public boolean shouldScaleSpeed(Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).shouldScaleSpeed(difficulty);
    }

    @Override
    public boolean shouldScaleLoot(Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).shouldScaleLoot(difficulty);
    }

    @Override
    public boolean shouldScaleXP(Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).shouldScaleXP(difficulty);
    }

    @Override
    public AttributeScalingTypes getDamageScaler(Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).getDamageScaler(difficulty);
    }

    @Override
    public AttributeScalingTypes getHealthScaler(Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).getHealthScaler(difficulty);
    }

    @Override
    public AttributeScalingTypes getSpeedScaler(Difficulty difficulty) {
        return ((ScalingSampler)this.samplers.get(difficulty.m_19028_())).getSpeedScaler(difficulty);
    }
}

