/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.sampler.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.random_mob_sizes.sampler.ScalingSampler;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;

public class GaussianScalingSampler
extends ScalingSampler {
    private static final double STD_DEV = 0.13;
    public static final String TYPE = "gaussian";
    private final float min_scaling;
    private final float max_scaling;
    private final float mean;
    private final boolean close_to_original;

    public GaussianScalingSampler(float min_scaling, float max_scaling) {
        this.min_scaling = min_scaling;
        this.max_scaling = max_scaling;
        this.close_to_original = false;
        this.mean = 0.5f;
    }

    public GaussianScalingSampler(JsonElement jsonElement, String entityType) {
        super(jsonElement, entityType);
        JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)entityType);
        this.min_scaling = GaussianScalingSampler.getFloatSafe(json, "min_scaling", entityType);
        this.max_scaling = GaussianScalingSampler.getFloatSafe(json, "max_scaling", entityType);
        GaussianScalingSampler.ensureMinSmallerMax(this.min_scaling, this.max_scaling, entityType);
        this.close_to_original = GsonHelper.m_13855_((JsonObject)json, (String)"close_to_original", (boolean)false);
        if (this.close_to_original) {
            if (this.min_scaling >= 1.0f) {
                throw new IllegalArgumentException("close_to_original is true, min_scaling needs to be smaller than 1.0");
            }
            if (this.max_scaling <= 1.0f) {
                throw new IllegalArgumentException("close_to_original is true, max_scaling needs to be bigger than 1.0");
            }
            this.mean = Mth.m_14036_((float)((1.0f - this.min_scaling) / (this.max_scaling - this.min_scaling)), (float)0.0f, (float)1.0f);
        } else {
            this.mean = 0.5f;
        }
    }

    @Override
    protected float sampleScalingFactor(RandomSource random, Difficulty difficulty) {
        return (float)((double)this.min_scaling + this.randomGaussian(random) * (double)(this.max_scaling - this.min_scaling));
    }

    private double randomGaussian(RandomSource random) {
        double value = (double)this.mean + random.m_188583_() * 0.13;
        return Mth.m_14008_((double)value, (double)0.0, (double)1.0);
    }

    @Override
    protected JsonObject serialize(JsonObject json) {
        json.addProperty("type", TYPE);
        json.addProperty("min_scaling", (Number)Float.valueOf(this.min_scaling));
        json.addProperty("max_scaling", (Number)Float.valueOf(this.max_scaling));
        json.addProperty("close_to_original", Boolean.valueOf(this.close_to_original));
        return json;
    }
}

