/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.random_mob_sizes.sampler.types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tristankechlo.random_mob_sizes.RandomMobSizes;
import com.tristankechlo.random_mob_sizes.sampler.AttributeScalingTypes;
import com.tristankechlo.random_mob_sizes.sampler.ScalingSampler;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;

public class StaticScalingSampler
extends ScalingSampler {
    public static final String TYPE = "static";
    private final float static_scaling;

    public StaticScalingSampler(float static_scaling) {
        this.static_scaling = static_scaling;
    }

    public StaticScalingSampler(JsonElement jsonElement, String entityType) {
        super(jsonElement, entityType);
        if (GsonHelper.m_13872_((JsonElement)jsonElement)) {
            float scaling = jsonElement.getAsFloat();
            if (StaticScalingSampler.isFloatOutOfBounds(scaling, 0.1f, 10.0f)) {
                RandomMobSizes.LOGGER.error("'scaling' for '{}' is out of range[{} - {}], changing to {}", new Object[]{entityType, Float.valueOf(0.1f), Float.valueOf(10.0f), Float.valueOf(scaling)});
                scaling = Mth.m_14036_((float)scaling, (float)0.1f, (float)10.0f);
            }
            this.static_scaling = scaling;
        } else {
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)entityType);
            this.static_scaling = StaticScalingSampler.getFloatSafe(json, "scaling", entityType);
        }
    }

    public StaticScalingSampler(float static_scaling, AttributeScalingTypes health, AttributeScalingTypes damage, AttributeScalingTypes speed) {
        super(health, damage, speed);
        this.static_scaling = static_scaling;
    }

    @Override
    protected float sampleScalingFactor(RandomSource random, Difficulty difficulty) {
        return this.static_scaling;
    }

    @Override
    protected JsonObject serialize(JsonObject json) {
        json.addProperty("type", TYPE);
        json.addProperty("scaling", (Number)Float.valueOf(this.static_scaling));
        return json;
    }
}

