/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.utils;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.util.entry.BlockEntry;
import fr.iglee42.createcasing.registries.ModBlocks;
import java.util.Arrays;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public enum WoodBlocks {
    OAK(Items.f_42647_, ModBlocks.OAK_SHAFT, ModBlocks.OAK_COGWHEEL, ModBlocks.OAK_LARGE_COGWHEEL),
    SPRUCE(Items.f_42700_, ModBlocks.SPRUCE_SHAFT, (BlockEntry<? extends Block>)AllBlocks.COGWHEEL, (BlockEntry<? extends Block>)AllBlocks.LARGE_COGWHEEL),
    BIRCH(Items.f_42753_, ModBlocks.BIRCH_SHAFT, ModBlocks.BIRCH_COGWHEEL, ModBlocks.BIRCH_LARGE_COGWHEEL),
    ACACIA(Items.f_42795_, ModBlocks.ACACIA_SHAFT, ModBlocks.ACACIA_COGWHEEL, ModBlocks.ACACIA_LARGE_COGWHEEL),
    DARK_OAK(Items.f_42796_, ModBlocks.DARK_OAK_SHAFT, ModBlocks.DARK_OAK_COGWHEEL, ModBlocks.DARK_OAK_LARGE_COGWHEEL),
    JUNGLE(Items.f_42794_, ModBlocks.JUNGLE_SHAFT, ModBlocks.JUNGLE_COGWHEEL, ModBlocks.JUNGLE_LARGE_COGWHEEL),
    MANGROVE(Items.f_220174_, ModBlocks.MANGROVE_SHAFT, ModBlocks.MANGROVE_COGWHEEL, ModBlocks.MANGROVE_LARGE_COGWHEEL),
    CHERRY(Items.f_271154_, ModBlocks.CHERRY_SHAFT, ModBlocks.CHERRY_COGWHEEL, ModBlocks.CHERRY_LARGE_COGWHEEL),
    BAMBOO(Items.f_243694_, ModBlocks.BAMBOO_SHAFT, ModBlocks.BAMBOO_COGWHEEL, ModBlocks.BAMBOO_LARGE_COGWHEEL),
    CRIMSON(Items.f_42797_, ModBlocks.CRIMSON_SHAFT, ModBlocks.CRIMSON_COGWHEEL, ModBlocks.CRIMSON_LARGE_COGWHEEL),
    WARPED(Items.f_42798_, ModBlocks.WARPED_SHAFT, ModBlocks.WARPED_COGWHEEL, ModBlocks.WARPED_LARGE_COGWHEEL),
    ANDESITE((Item)AllItems.ANDESITE_ALLOY.get(), (BlockEntry<? extends Block>)AllBlocks.SHAFT, null, null),
    BRASS((Item)AllItems.BRASS_INGOT.get(), ModBlocks.BRASS_SHAFT, null, null),
    GLASS(Items.f_41904_, ModBlocks.GLASS_SHAFT, null, null),
    MLDEG(Items.f_42755_, ModBlocks.MLDEG_SHAFT, null, null);

    private final Item item;
    private final BlockEntry<? extends Block> shaft;
    private final BlockEntry<? extends Block> cogwheel;
    private final BlockEntry<? extends Block> largeCogwheel;

    private WoodBlocks(Item item, BlockEntry<? extends Block> shaft, BlockEntry<? extends Block> cogwheel, BlockEntry<? extends Block> largeCogwheel) {
        this.item = item;
        this.shaft = shaft;
        this.cogwheel = cogwheel;
        this.largeCogwheel = largeCogwheel;
    }

    public static WoodBlocks getBlockByItem(Item item) {
        return Arrays.stream(WoodBlocks.values()).filter(e -> e.item.equals(item)).findFirst().orElse(null);
    }

    public static boolean hasBlocksForItem(Item item) {
        return WoodBlocks.getBlockByItem(item) != null;
    }

    public Item getItem() {
        return this.item;
    }

    public BlockEntry<? extends Block> getShaft() {
        return this.shaft;
    }

    public BlockEntry<? extends Block> getCogwheel() {
        return this.cogwheel;
    }

    public BlockEntry<? extends Block> getLargeCogwheel() {
        return this.largeCogwheel;
    }

    public boolean hasShaft() {
        return this.getShaft() != null;
    }

    public boolean hasCogwheel() {
        return this.getCogwheel() != null;
    }

    public boolean hasLargeCogwheel() {
        return this.getLargeCogwheel() != null;
    }

    public static boolean isShaft(BlockState state) {
        return Arrays.stream(WoodBlocks.values()).anyMatch(b -> b.hasShaft() && b.getShaft().has(state));
    }

    public static boolean isCogwheel(BlockState state) {
        return Arrays.stream(WoodBlocks.values()).anyMatch(b -> b.hasCogwheel() && b.getCogwheel().has(state));
    }

    public static boolean isLargeCogwheel(BlockState state) {
        return Arrays.stream(WoodBlocks.values()).anyMatch(b -> b.hasLargeCogwheel() && b.getLargeCogwheel().has(state));
    }

    public boolean isInSet(BlockState state) {
        return this.hasShaft() && this.shaft.has(state) || this.hasCogwheel() && this.cogwheel.has(state) || this.hasLargeCogwheel() && this.largeCogwheel.has(state);
    }
}

