/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.entity;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.satisfy.farm_and_charm.entity.DrivableEntity;
import net.satisfy.farm_and_charm.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class CartEntity
extends DrivableEntity {
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(CartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private float originalYRot = 0.0f;
    private boolean shouldResetRot = false;
    private float wheelRot;
    private int rollOut;
    private int soundCooldown = 0;
    private double lastDriverX;
    private double lastDriverY;
    private double lastDriverZ;

    protected CartEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    protected float wheelYOffset() {
        return this.wheelRadius() / 2.0f;
    }

    protected abstract float firstPoint();

    protected abstract float lastPoint();

    protected abstract float wheelRadius();

    protected float holdOffset() {
        return 2.0f;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand interactionHand) {
        if (this.hasDriver()) {
            this.removeDriver();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12635_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        boolean added = this.addDriver((Entity)player);
        if (added) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12633_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
        Vec3 currentPos = this.m_20182_();
        double distanceMoved = Math.sqrt(Math.pow(currentPos.f_82479_ - this.lastDriverX, 1.5) + Math.pow(currentPos.f_82480_ - this.lastDriverY, 1.5) + Math.pow(currentPos.f_82481_ - this.lastDriverZ, 1.5));
        double MIN_MOVEMENT_THRESHOLD = 0.05;
        if (distanceMoved > 0.05) {
            this.spawnWheelParticles();
            this.playMovementSound();
        }
        this.lastDriverX = currentPos.f_82479_;
        this.lastDriverY = currentPos.f_82480_;
        this.lastDriverZ = currentPos.f_82481_;
        this.setupMovement();
        this.setupWheels();
        this.setupRotation();
        if (this.shouldResetRot) {
            this.m_146922_(this.originalYRot);
            this.shouldResetRot = false;
        }
    }

    private void setupMovement() {
        if (this.hasDriver()) {
            Vec3 lastMoveVec = this.m_20182_().m_82492_(this.lastDriverX, this.lastDriverY, this.lastDriverZ).m_82490_(0.5);
            assert (this.getDriver() != null);
            Vec3 driverMoveVec = this.getDriver().m_20182_().m_82492_(this.lastDriverX, this.lastDriverY, this.lastDriverZ).m_82548_().m_82490_(0.5);
            Vec3 newPosVec = driverMoveVec.m_82549_(lastMoveVec).m_82541_().m_82490_((double)this.holdOffset());
            Vec3 desiredPos = this.getDriver().m_20182_().m_82549_(newPosVec);
            Vec3 movVec = desiredPos.m_82546_(this.m_20182_());
            if (this.m_20184_().m_82553_() + movVec.m_82490_(0.2).m_82553_() < movVec.m_82553_()) {
                this.m_20256_(this.m_20184_().m_82549_(movVec).m_82490_(0.2));
            }
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    private void setupRotation() {
        if (this.hasDriver()) {
            assert (this.getDriver() != null);
            Vec3 lookAtVec = this.getDriver().m_20182_().m_82546_(this.m_20182_()).m_82541_();
            double yRot = Math.atan2(-lookAtVec.f_82479_, lookAtVec.f_82481_);
            double xRot = Math.atan2(-lookAtVec.f_82480_, Math.sqrt(lookAtVec.f_82479_ * lookAtVec.f_82479_ + lookAtVec.f_82481_ * lookAtVec.f_82481_));
            this.m_146922_((float)Math.toDegrees(yRot));
            this.m_146926_((float)Math.toDegrees(xRot));
        }
    }

    private void setupWheels() {
        Vec3 velocity = this.m_20184_();
        float xzDist = (float)Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
        if (0.01f < xzDist && 10 >= this.rollOut) {
            float anglePerTick = xzDist / this.wheelRadius() / (float)this.rollOut;
            this.wheelRot -= anglePerTick;
            this.wheelRot %= (float)Math.PI * 2;
        }
        if (!this.m_20096_()) {
            if (10 > this.rollOut) {
                ++this.rollOut;
            }
        } else {
            this.rollOut = 1;
        }
    }

    public float wheelRot() {
        return this.wheelRot;
    }

    private void playMovementSound() {
        if (this.soundCooldown <= 0) {
            SoundEvent sound = (SoundEvent)DoApiSoundEventRegistry.CART_MOVING.get();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.NEUTRAL, 0.1f, 1.0f);
            this.soundCooldown = 55;
        }
    }

    private void spawnWheelParticles() {
        BlockPos blockPosUnder;
        ServerLevel serverLevel;
        BlockState blockState;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && !(blockState = (serverLevel = (ServerLevel)level).m_8055_(blockPosUnder = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() - 0.5), (int)this.m_20189_()))).m_60795_()) {
            for (int i = 0; i < 4; ++i) {
                double wheelParticleX = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 0.5;
                double wheelParticleY = this.m_20186_() + 0.1;
                double wheelParticleZ = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 0.5;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), wheelParticleX, wheelParticleY, wheelParticleZ, 1, 0.0, 0.05, 0.0, 0.1);
            }
        }
    }

    public float balance() {
        double maxFrontX = Math.sqrt(this.firstPoint() * this.firstPoint() - this.wheelYOffset() * this.wheelYOffset());
        double maxFrontSlope = Math.atan2(-this.wheelYOffset(), maxFrontX);
        if (!this.hasDriver()) {
            return (float)maxFrontSlope;
        }
        double maxBackX = Math.sqrt(this.lastPoint() * this.lastPoint() - this.wheelYOffset() * this.wheelYOffset());
        double maxBackSlope = Math.atan2(this.wheelYOffset(), maxBackX);
        double desiredXRot = Math.toRadians(-this.m_146909_());
        return this.m_20096_() ? (float)Math.max(Math.min(desiredXRot, maxBackSlope), maxFrontSlope) : (float)desiredXRot;
    }

    public boolean m_6469_(DamageSource damageSource, float damageAmount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            this.setDamage(this.getDamage() + damageAmount);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockState blockState = serverLevel.m_8055_(this.m_20183_().m_7495_());
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), 10, 0.1, 0.1, 0.1, 0.0);
                this.originalYRot = this.m_146908_();
                this.m_146922_(this.originalYRot + this.f_19796_.m_188501_() * 10.0f - 5.0f);
                this.shouldResetRot = true;
            }
            if (this.getDamage() > 5.0f) {
                if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.destroy(damageSource);
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    protected void destroy(DamageSource damageSource) {
        this.m_19998_((ItemLike)ObjectRegistry.SUPPLY_CART.get());
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(Math.min(damage, 40.0f)));
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }
}

