/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.registry.TagRegistry;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlock.class})
public abstract class CampfireBlockMixin {
    @Unique
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    @Unique
    private static final VoxelShape[] CORNERS = new VoxelShape[]{Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.m_49796_((double)15.0, (double)7.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.m_49796_((double)0.0, (double)7.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.m_49796_((double)15.0, (double)7.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0)};
    @Unique
    private static final VoxelShape TOP_LAYER = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    @Unique
    private static final VoxelShape FULL_CAMPFIRE_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{CORNERS[0], CORNERS[1], CORNERS[2], CORNERS[3], TOP_LAYER});

    @Inject(method={"dowse"}, at={@At(value="HEAD")}, cancellable=true)
    private static void modifyDowseParticles(@Nullable Entity entity, LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, CallbackInfo ci) {
        if (CampfireBlockMixin.shouldCancelParticles(levelAccessor, blockPos)) {
            ci.cancel();
        }
    }

    @Unique
    private static boolean shouldCancelParticles(LevelAccessor level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_204336_(TagRegistry.SUPPRESS_CAMPFIRE_SMOKE_PARTICLES);
    }

    @Inject(method={"makeParticles"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onMakeParticles(Level level, BlockPos blockPos, boolean signalFire, boolean spawnExtraSmoke, CallbackInfo ci) {
        if (CampfireBlockMixin.shouldCancelParticles((LevelAccessor)level, blockPos)) {
            ci.cancel();
        }
    }

    @Overwrite
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (world.m_8055_(pos.m_7494_()).m_204336_(TagRegistry.COOKING_POTS)) {
            return FULL_CAMPFIRE_SHAPE;
        }
        return BASE_SHAPE;
    }
}

