/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleQuiverPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class QuiverArrowSelectGui
extends Gui {
    private static final ResourceLocation TEXTURE = Supplementaries.res("textures/gui/quiver_select.png");
    private static boolean usingItem;
    private static boolean usingKeyAndHasItem;
    private static double lastCumulativeMouseDx;
    protected final Minecraft minecraft;

    public static boolean isActive() {
        return usingItem || usingKeyAndHasItem;
    }

    public static void setUsingItem(boolean on) {
        usingItem = on;
    }

    public static boolean isUsingKey() {
        return usingKeyAndHasItem;
    }

    public static void setUsingKeybind(boolean on) {
        IQuiverEntity qe;
        LocalPlayer localPlayer;
        usingKeyAndHasItem = on && (localPlayer = Minecraft.m_91087_().f_91074_) instanceof IQuiverEntity && (qe = (IQuiverEntity)localPlayer).supplementaries$hasQuiver();
    }

    protected QuiverArrowSelectGui(Minecraft minecraft, ItemRenderer itemRenderer) {
        super(minecraft, itemRenderer);
        this.minecraft = minecraft;
    }

    public static void onPlayerRotated(double yRotIncrease) {
        LocalPlayer player;
        int slotsMoved = (int)(yRotIncrease * 0.2);
        if (slotsMoved != 0 && (player = Minecraft.m_91087_().f_91074_) != null) {
            ServerBoundCycleQuiverPacket.Slot s = QuiverArrowSelectGui.getQuiverSlot((Player)player);
            ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(slotsMoved, s));
        }
    }

    public static void ohMouseMoved(double deltaX) {
        LocalPlayer player;
        int oldI;
        int slotsMoved;
        double scale = (Double)Minecraft.m_91087_().f_91066_.m_231964_().m_231551_() * 0.02;
        if ((slotsMoved = (int)((lastCumulativeMouseDx += deltaX) * scale) - (oldI = (int)(lastCumulativeMouseDx * scale))) != 0 && (player = Minecraft.m_91087_().f_91074_) != null) {
            ServerBoundCycleQuiverPacket.Slot s = QuiverArrowSelectGui.getQuiverSlot((Player)player);
            ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(slotsMoved, s));
        }
    }

    public static boolean onKeyPressed(int key, int action, int modifiers) {
        if (action == 1) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            switch (key) {
                case 263: {
                    ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(-1, QuiverArrowSelectGui.getQuiverSlot((Player)player)));
                    return true;
                }
                case 262: {
                    ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(1, QuiverArrowSelectGui.getQuiverSlot((Player)player)));
                    return true;
                }
            }
            int number = key - 48;
            if (number >= 1 && number <= 9) {
                if (number <= CommonConfigs.Tools.QUIVER_SLOTS.get()) {
                    ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(number - 1, QuiverArrowSelectGui.getQuiverSlot((Player)player), true));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean onMouseScrolled(double scrollDelta) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(scrollDelta > 0.0 ? -1 : 1, QuiverArrowSelectGui.getQuiverSlot((Player)player)));
        return true;
    }

    private void renderSlot(GuiGraphics graphics, int pX, int pY, ItemStack pStack, int seed) {
        if (!pStack.m_41619_()) {
            graphics.m_280256_(pStack, pX, pY, seed);
            RenderSystem.setShader(GameRenderer::m_172811_);
            graphics.m_280370_(this.minecraft.f_91062_, pStack, pX, pY);
        }
    }

    public void renderQuiverContent(GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Player player;
        ItemStack quiver;
        Entity entity = this.minecraft.m_91288_();
        if (entity instanceof Player && (quiver = QuiverArrowSelectGui.getCurrentlyUsedQuiver(player = (Player)entity)).m_41720_() == ModRegistry.QUIVER_ITEM.get()) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            QuiverItem.Data data = QuiverItem.getQuiverData(quiver);
            int selected = data.getSelectedSlot();
            List<ItemStack> items = data.getContentView();
            int slots = items.size();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int centerX = screenWidth / 2;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, -90.0f);
            int uWidth = slots * 20 + 2;
            int px = uWidth / 2;
            int py = screenHeight / 2 - 40;
            graphics.m_280218_(TEXTURE, centerX - (px += ClientConfigs.Items.QUIVER_GUI_X.get().intValue()), py += ClientConfigs.Items.QUIVER_GUI_Y.get().intValue(), 0, 0, uWidth - 1, 22);
            graphics.m_280218_(TEXTURE, centerX + px - 1, py, 0, 0, 1, 22);
            graphics.m_280218_(TEXTURE, centerX - px - 1 + selected * 20, py - 1, 24, 22, 24, 24);
            poseStack.m_85849_();
            int i1 = 1;
            for (int i = 0; i < slots; ++i) {
                int kx = centerX - px + 3 + i * 20;
                this.renderSlot(graphics, kx, py + 3, items.get(i), i1++);
            }
            RenderSystem.disableBlend();
            ItemStack selectedArrow = items.get(selected);
            if (!selectedArrow.m_41619_()) {
                this.drawHighlight(graphics, screenWidth, py, selectedArrow);
            }
            poseStack.m_85849_();
            QuiverArrowSelectGui.setUsingItem(true);
            return;
        }
        QuiverArrowSelectGui.setUsingItem(false);
    }

    @NotNull
    private static ServerBoundCycleQuiverPacket.Slot getQuiverSlot(Player player) {
        return usingKeyAndHasItem ? ServerBoundCycleQuiverPacket.Slot.INVENTORY : (player.m_7655_() == InteractionHand.MAIN_HAND ? ServerBoundCycleQuiverPacket.Slot.MAIN_HAND : ServerBoundCycleQuiverPacket.Slot.OFF_HAND);
    }

    private static ItemStack getCurrentlyUsedQuiver(Player player) {
        if (usingKeyAndHasItem) {
            return ((IQuiverEntity)player).supplementaries$getQuiver();
        }
        return player.m_21211_();
    }

    protected abstract void drawHighlight(GuiGraphics var1, int var2, int var3, ItemStack var4);

    static {
        usingKeyAndHasItem = false;
        lastCumulativeMouseDx = 0.0;
    }
}

