/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.entities.FallingAshEntity;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AshLayerBlock
extends FallingBlock {
    private static final int MAX_LAYERS = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[9];
    public static final ThreadLocal<Boolean> RECURSION_HACK;
    public static final int GRASS_SPREAD_WIDTH = 3;

    public AshLayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile projectile) {
        ThrownPotion potion;
        BlockPos pos = pHit.m_82425_();
        if (projectile instanceof ThrownPotion && PotionUtils.m_43579_((ItemStack)(potion = (ThrownPotion)projectile).m_7846_()) == Potions.f_43599_) {
            boolean flag;
            Entity entity = projectile.m_19749_();
            boolean bl = flag = entity == null || entity instanceof Player || PlatHelper.isMobGriefingOn((Level)level, (Entity)entity);
            if (flag) {
                this.removeOneLayer(state, pos, level);
            }
        }
    }

    public int m_6248_(BlockState state, BlockGetter reader, BlockPos pos) {
        return 0x9A9090;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_()) {
            worldIn.m_186460_(pos, (Block)this, this.m_7198_());
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext c;
        Entity e;
        if (pContext instanceof EntityCollisionContext && (e = (c = (EntityCollisionContext)pContext).m_193113_()) instanceof LivingEntity) {
            return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS) - 1];
        }
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType pathType) {
        if (pathType == PathComputationType.LAND) {
            return (Integer)state.m_61143_((Property)LAYERS) <= 4;
        }
        return false;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos otherPos) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            BlockPos pos = currentPos.m_7494_();
            BlockState state1 = world.m_8055_(pos);
            while (state1.m_60713_((Block)this)) {
                serverLevel.m_186460_(pos, (Block)this, this.m_7198_());
                pos = pos.m_7494_();
                state1 = serverLevel.m_8055_(pos);
            }
            AshLayerBlock.updateBasaltBelow(currentPos, (Level)serverLevel);
        }
        return super.m_7417_(state, direction, facingState, world, currentPos, otherPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRand) {
        BlockState below = level.m_8055_(pos.m_7495_());
        if ((FallingAshEntity.isFree(below) || this.hasIncompleteAshPileBelow(below)) && pos.m_123342_() >= level.m_141937_()) {
            while (state.m_60713_((Block)this)) {
                FallingAshEntity fallingblockentity = FallingAshEntity.fall((Level)level, pos, state);
                this.m_6788_((FallingBlockEntity)fallingblockentity);
                pos = pos.m_7494_();
                state = level.m_8055_(pos);
            }
        }
    }

    private boolean hasIncompleteAshPileBelow(BlockState state) {
        return state.m_60713_((Block)this) && (Integer)state.m_61143_((Property)LAYERS) != 8;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)this)) {
            int i = (Integer)blockstate.m_61143_((Property)LAYERS);
            return (BlockState)blockstate.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LAYERS});
    }

    public void m_213898_(BlockState pState, ServerLevel level, BlockPos pPos, RandomSource pRandom) {
        if (CommonConfigs.Building.ASH_RAIN.get().booleanValue() && level.m_46758_(pPos.m_7494_()) && level.f_46441_.m_188503_(4) == 0) {
            this.removeOneLayer(pState, pPos, (Level)level);
        }
    }

    public void m_141997_(BlockState pState, Level level, BlockPos pPos, Biome.Precipitation pPrecipitation) {
        super.m_141997_(pState, level, pPos, pPrecipitation);
        if (CommonConfigs.Building.ASH_RAIN.get().booleanValue() && level.f_46441_.m_188503_(2) == 0) {
            this.removeOneLayer(pState, pPos, level);
        }
    }

    private void removeOneLayer(BlockState state, BlockPos pos, Level level) {
        int levels = (Integer)state.m_61143_((Property)LAYERS);
        if (levels > 1) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(levels - 1)));
        } else {
            level.m_7471_(pos, false);
        }
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext useContext) {
        int i = (Integer)pState.m_61143_((Property)LAYERS);
        if (useContext.m_43722_().m_150930_(this.m_5456_()) && i < 8) {
            boolean ret = true;
            if (RECURSION_HACK.get().booleanValue()) {
                return true;
            }
            RECURSION_HACK.set(true);
            if (useContext.m_7058_()) {
                ret = useContext.m_43719_() == Direction.UP;
            }
            RECURSION_HACK.set(false);
            return ret;
        }
        return i <= 3;
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return true;
    }

    public static void tryConvertToAsh(IFireConsumeBlockEvent event) {
        double chance = CommonConfigs.Building.ASH_BURN_CHANCE.get();
        if (chance != 0.0) {
            int layers;
            BlockState state = event.getState();
            LevelAccessor level = event.getLevel();
            BlockPos pos = event.getPos();
            if (event.getFinalState() != null) {
                return;
            }
            Item i = state.m_60734_().m_5456_();
            int count = PlatHelper.getBurnTime((ItemStack)i.m_7968_()) / 100;
            if (i.m_204114_().m_203656_(ItemTags.f_13181_)) {
                count += 2;
            }
            if (count > 0 && (layers = Mth.m_14045_((int)level.m_213780_().m_188503_(count), (int)1, (int)8)) != 0) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ModParticles.ASH_PARTICLE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10 + layers, 0.5, 0.5, 0.5, 0.0);
                event.setFinalState((BlockState)ModRegistry.ASH_BLOCK.get().m_49966_().m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(layers)));
            }
        }
    }

    private void addParticle(Entity entity, BlockPos pos, Level level, int layers, float upSpeed) {
        level.m_7106_((ParticleOptions)ModParticles.ASH_PARTICLE.get(), entity.m_20185_(), (double)((float)pos.m_123342_() + (float)layers * 0.125f), entity.m_20189_(), (double)(Mth.m_216283_((RandomSource)level.f_46441_, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)upSpeed, (double)(Mth.m_216283_((RandomSource)level.f_46441_, (float)-1.0f, (float)1.0f) * 0.083333336f));
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.f_46443_ && (!(entity instanceof LivingEntity) || entity.m_146900_().m_60713_((Block)this))) {
            boolean bl;
            boolean bl2 = bl = entity.f_19790_ != entity.m_20185_() || entity.f_19792_ != entity.m_20189_();
            if (bl && level.f_46441_.m_188503_(2) == 0) {
                this.addParticle(entity, pos, level, (Integer)state.m_61143_((Property)LAYERS), 0.05f);
            }
        }
        super.m_7892_(state, level, pos, entity);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float height) {
        int layers = (Integer)state.m_61143_((Property)LAYERS);
        entity.m_142535_(height, layers > 2 ? 0.3f : 1.0f, level.m_269111_().m_268989_());
        if (level.f_46443_) {
            int i = 0;
            while ((double)i < Math.min(12.0, (double)height * 1.4)) {
                this.addParticle(entity, pos, level, layers, 0.12f);
                ++i;
            }
        }
    }

    public static boolean applyBonemeal(ItemStack stack, Level level, BlockPos pos, Player player) {
        BonemealableBlock bonemealableblock;
        BlockState blockstate = level.m_8055_(pos);
        Block block = blockstate.m_60734_();
        if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block).m_7370_((LevelReader)level, pos, blockstate, level.f_46443_)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (bonemealableblock.m_214167_(level, level.f_46441_, pos, blockstate)) {
                    bonemealableblock.m_214148_(serverLevel, level.f_46441_, pos, blockstate);
                }
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public static boolean updateBasaltBelow(BlockPos selfPos, Level level) {
        if (level.m_8055_(selfPos.m_7495_()) == Blocks.f_50137_.m_49966_()) {
            level.m_7731_(selfPos.m_7495_(), ModRegistry.ASHEN_BASALT.get().m_49966_(), 2);
            return true;
        }
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        AshLayerBlock.updateBasaltBelow(pos, level);
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state, BlockState replaceableState, FallingBlockEntity fallingBlock) {
        super.m_48792_(level, pos, state, replaceableState, fallingBlock);
        AshLayerBlock.updateBasaltBelow(pos, level);
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)((double)l * 2.0), (double)16.0));
        RECURSION_HACK = ThreadLocal.withInitial(() -> false);
    }
}

