/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BambooSpikesBlock
extends WaterBlock
implements ISoftFluidConsumer,
EntityBlock,
IWashable,
IPistonMotionReact {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty TIPPED = ModBlockProperties.TIPPED;
    private static final GameProfile SPIKE_PLAYER = new GameProfile(UUID.randomUUID(), "Spike Fake Player");
    private static final Supplier<Boolean> TIPPED_ENABLED = Suppliers.memoize(CommonConfigs.Functional.TIPPED_SPIKES_ENABLED::get);

    public BambooSpikesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public static DamageSource getDamageSource(Level level) {
        if (CommonConfigs.Functional.BAMBOO_SPIKES_DROP_LOOT.get().booleanValue()) {
            ServerPlayer fakePlayer = (ServerPlayer)FakePlayerManager.get((GameProfile)SPIKE_PLAYER, (Level)level);
            fakePlayer.m_8960_().m_135978_();
            fakePlayer.m_143403_(GameType.SPECTATOR);
            return ModDamageSources.spikePlayer((Player)fakePlayer);
        }
        return ModDamageSources.spike();
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof BambooSpikesBlockTile) {
            Potion p;
            BambooSpikesBlockTile tile = (BambooSpikesBlockTile)te;
            CompoundTag com = stack.m_41783_();
            if (com != null && (p = PotionUtils.m_43579_((ItemStack)stack)) != Potions.f_43598_ && com.m_128441_("Damage")) {
                tile.potion = p;
                tile.setMissingCharges(com.m_128451_("Damage"));
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        CompoundTag com = context.m_43722_().m_41783_();
        int charges = com != null ? context.m_43722_().m_41776_() - com.m_128451_("Damage") : 0;
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)TIPPED, (Comparable)Boolean.valueOf(charges != 0 && PotionUtils.m_43577_((CompoundTag)com) != Potions.f_43598_));
    }

    public ItemStack getSpikeItem(BlockEntity te) {
        if (te instanceof BambooSpikesBlockTile) {
            BambooSpikesBlockTile tile = (BambooSpikesBlockTile)te;
            return tile.getSpikeItem();
        }
        return new ItemStack((ItemLike)ModRegistry.BAMBOO_SPIKES_ITEM.get());
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.getSpikeItem((BlockEntity)builder.m_287159_(LootContextParams.f_81462_)));
        return list;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
        };
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        Player player;
        if (entityIn instanceof Player && (player = (Player)entityIn).m_7500_()) {
            return;
        }
        if (entityIn instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entityIn;
            if (entityIn.m_6084_()) {
                boolean up = state.m_61143_((Property)FACING) == Direction.UP;
                double vy = up ? 0.45 : 0.95;
                float fall = entityIn.f_19789_;
                entityIn.m_7601_(state, new Vec3(0.95, vy, 0.95));
                entityIn.f_19789_ = fall;
                if (!level.f_46443_) {
                    BambooSpikesBlockTile te;
                    BlockEntity blockEntity;
                    if (up && entityIn instanceof Player && entityIn.m_6144_()) {
                        return;
                    }
                    float damage = entityIn.m_20186_() > (double)pos.m_123342_() + 0.0625 ? 3.0f : 1.5f;
                    entityIn.m_6469_(BambooSpikesBlock.getDamageSource(level), damage);
                    if (((Boolean)state.m_61143_((Property)TIPPED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof BambooSpikesBlockTile && (te = (BambooSpikesBlockTile)blockEntity).interactWithEntity(le, level)) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)TIPPED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
            }
        }
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.DAMAGE_OTHER;
    }

    @Nullable
    public BlockPathTypes getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, BlockPathTypes originalType) {
        return BlockPathTypes.DAMAGE_OTHER;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!TIPPED_ENABLED.get().booleanValue() || ((Boolean)state.m_61143_((Property)TIPPED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41720_() instanceof LingeringPotionItem) {
            if (BambooSpikesBlock.tryAddingPotion(state, (LevelAccessor)worldIn, pos, PotionUtils.m_43579_((ItemStack)stack)) && !player.m_7500_()) {
                player.m_21008_(handIn, ItemUtils.m_41817_((ItemStack)stack.m_41777_(), (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_), (boolean)false));
            }
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, TIPPED});
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return this.getSpikeItem(level.m_7702_(pos));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return (Boolean)pState.m_61143_((Property)TIPPED) != false ? new BambooSpikesBlockTile(pPos, pState) : null;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        if (0.01 > (double)random.m_188501_() && ((Boolean)state.m_61143_((Property)TIPPED)).booleanValue() && (blockEntity = world.m_7702_(pos)) instanceof BambooSpikesBlockTile) {
            BambooSpikesBlockTile tile = (BambooSpikesBlockTile)blockEntity;
            tile.makeParticle(world);
        }
    }

    public boolean tryAcceptingFluid(Level world, BlockState state, BlockPos pos, SoftFluidStack fluid) {
        if (!TIPPED_ENABLED.get().booleanValue() || ((Boolean)state.m_61143_((Property)TIPPED)).booleanValue()) {
            return false;
        }
        if (fluid.is((SoftFluid)BuiltInSoftFluids.POTION.get()) && fluid.hasTag() && fluid.getTag().m_128461_("PotionType").equals("Lingering")) {
            return BambooSpikesBlock.tryAddingPotion(state, (LevelAccessor)world, pos, PotionUtils.m_43577_((CompoundTag)fluid.getTag()));
        }
        return false;
    }

    public static boolean tryAddingPotion(BlockState state, LevelAccessor world, BlockPos pos, Potion potion) {
        BambooSpikesBlockTile tile;
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)TIPPED, (Comparable)Boolean.valueOf(true)), 0);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof BambooSpikesBlockTile && (tile = (BambooSpikesBlockTile)te).tryApplyPotion(potion)) {
            world.m_5594_(null, pos, SoundEvents.f_11965_, SoundSource.BLOCKS, 0.5f, 1.5f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TIPPED, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        if (te != null) {
            te.m_7651_();
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)TIPPED, (Comparable)Boolean.valueOf(false)), 0);
        return false;
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)TIPPED)).booleanValue()) {
            if (!level.f_46443_) {
                BlockEntity te = level.m_7702_(pos);
                if (te != null) {
                    te.m_7651_();
                }
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)TIPPED, (Comparable)Boolean.valueOf(false)), 3);
            }
            return true;
        }
        return false;
    }

    public boolean ticksWhileMoved() {
        return true;
    }

    public void moveTick(BlockState movedState, Level level, BlockPos pos, AABB aabb, PistonMovingBlockEntity tile) {
        boolean sameDir = ((Direction)movedState.m_61143_((Property)FACING)).equals((Object)tile.m_60392_());
        if (CompatHandler.QUARK) {
            QuarkCompat.tickPiston(level, pos, movedState, aabb, sameDir, (BlockEntity)tile);
        }
    }
}

