/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpWaterBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FirePitBlock
extends LightUpWaterBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0));
    private final float fireDamage;

    public FirePitBlock(float fireDamage, BlockBehaviour.Properties properties) {
        super(properties);
        this.fireDamage = fireDamage;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(level.m_269111_().m_269387_(), this.fireDamage);
        }
        super.m_7892_(state, level, pos, entity);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return super.m_5573_(context);
        }
        return null;
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
        return FirePitBlock.getDir(stateIn).m_122424_() == facing && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    private static Direction getDir(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
        }
    }

    public static void spawnSmokeParticles(Level level, BlockPos pos) {
        RandomSource random = level.m_213780_();
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = FirePitBlock.getDir(state).m_122424_();
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HANGING});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        return this.isLitUp(state, (BlockGetter)((LevelAccessor)level), pos) ? BlockPathTypes.DAMAGE_FIRE : null;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 15 : 0;
    }
}

