/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.EndermanSkullBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EndermanSkullBlockTile
extends SkullBlockEntity {
    private float prevMouthAnim;
    private float mouthAnim;
    private int watchTime;

    public EndermanSkullBlockTile(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public BlockEntityType<?> m_58903_() {
        return ModRegistry.ENDERMAN_SKULL_TILE.get();
    }

    public float getMouthAnimation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevMouthAnim, (float)this.mouthAnim);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EndermanSkullBlockTile tile) {
        if (level.f_46443_) {
            boolean watched = (Boolean)state.m_61143_((Property)ModBlockProperties.WATCHED);
            tile.prevMouthAnim = tile.mouthAnim;
            tile.mouthAnim = Mth.m_14036_((float)(tile.mouthAnim + (watched ? 0.5f : -0.5f)), (float)0.0f, (float)1.0f);
        } else {
            boolean watched = EndermanSkullBlockTile.isBeingWatched(level, pos, state);
            tile.watchTime = !watched ? 0 : ++tile.watchTime;
            int wantedPower = Mth.m_14045_((int)(watched ? 1 + tile.watchTime / CommonConfigs.Redstone.ENDERMAN_HEAD_INCREMENT.get() : 0), (int)0, (int)15);
            if ((Boolean)state.m_61143_((Property)ModBlockProperties.WATCHED) != watched || (Integer)state.m_61143_((Property)EndermanSkullBlock.POWER) != wantedPower) {
                level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)ModBlockProperties.WATCHED, (Comparable)Boolean.valueOf(watched))).m_61124_((Property)EndermanSkullBlock.POWER, (Comparable)Integer.valueOf(wantedPower)));
            }
        }
    }

    public static boolean isBeingWatched(Level level, BlockPos pos, BlockState state) {
        int range = 20;
        List players = level.m_45976_(Player.class, new AABB(pos.m_7918_(-range, -range, -range), pos.m_7918_(range, range, range)));
        for (Player player : players) {
            BlockHitResult hit;
            HitResult result;
            ItemStack itemstack;
            if (SuppPlatformStuff.isEndermanMask(null, player, itemstack = (ItemStack)player.m_150109_().f_35975_.get(3)) || !((result = Utils.rayTrace((Entity)player, (Level)level, (ClipContext.Block)ClipContext.Block.OUTLINE, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)64.0)) instanceof BlockHitResult) || !(hit = (BlockHitResult)result).m_82425_().equals((Object)pos) || !EndermanSkullBlockTile.isLookingAtFace(pos, state, result.m_82450_(), hit.m_82434_())) continue;
            return true;
        }
        return false;
    }

    private static boolean isLookingAtFace(BlockPos pos, BlockState state, Vec3 location, Direction face) {
        if (CommonConfigs.Redstone.ENDERMAN_HEAD_WORKS_FROM_ANY_SIDE.get().booleanValue()) {
            return true;
        }
        if (face.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        if (state.m_61138_((Property)WallSkullBlock.f_58097_)) {
            Direction f = (Direction)state.m_61143_((Property)WallSkullBlock.f_58097_);
            return f == face;
        }
        if (state.m_61138_((Property)SkullBlock.f_56314_)) {
            Integer r = (Integer)state.m_61143_((Property)SkullBlock.f_56314_);
            float angle = (float)r.intValue() * 22.5f;
            if (angle % 90.0f == 0.0f) {
                return Direction.m_122364_((double)angle).m_122424_() == face;
            }
            location = location.m_82546_(Vec3.m_82512_((Vec3i)pos));
            Vec3 relative = location.m_82524_(angle * ((float)Math.PI / 180));
            if (relative.f_82479_ < -0.25 || relative.f_82479_ > 0.25) {
                return false;
            }
            if (relative.f_82481_ > 0.0) {
                return false;
            }
        }
        return true;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("WatchTime", this.watchTime);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.watchTime = tag.m_128451_("WatchTime");
    }

    @Nullable
    public ResourceLocation m_262374_() {
        return ModSounds.IMITATE_ENDERMAN.getId();
    }
}

