/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.PulleyContainerMenu;
import net.mehvahdjukaar.supplementaries.common.misc.RopeHelper;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class PulleyBlockTile
extends ItemDisplayTile {
    public PulleyBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.PULLEY_BLOCK_TILE.get(), pos, state);
    }

    public void updateTileOnInventoryChanged() {
        ModBlockProperties.Winding type = PulleyBlockTile.getContentType(this.getDisplayedItem().m_41720_());
        BlockState state = this.m_58900_();
        if (state.m_61143_(PulleyBlock.TYPE) != type) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_(PulleyBlock.TYPE, (Comparable)((Object)type)));
        }
    }

    public static ModBlockProperties.Winding getContentType(Item item) {
        BlockItem bi;
        ModBlockProperties.Winding type = ModBlockProperties.Winding.NONE;
        if (item instanceof BlockItem && (bi = (BlockItem)item).m_40614_() instanceof ChainBlock || item.m_204114_().m_203656_(ModTags.CHAINS)) {
            type = ModBlockProperties.Winding.CHAIN;
        } else if (item.m_204114_().m_203656_(ModTags.ROPES)) {
            type = ModBlockProperties.Winding.ROPE;
        }
        return type;
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"gui.supplementaries.pulley_block");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new PulleyContainerMenu(i, inventory, (Container)this);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return PulleyBlockTile.getContentType(stack.m_41720_()) != ModBlockProperties.Winding.NONE;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean rotateDirectly(Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90) {
            return this.pullRopeUp();
        }
        if (rot == Rotation.COUNTERCLOCKWISE_90) {
            return this.releaseRopeDown();
        }
        return false;
    }

    public boolean pullRopeUp() {
        return this.pullRope(Direction.DOWN, Integer.MAX_VALUE, true);
    }

    public boolean pullRope(Direction moveDir, int maxDist, boolean addItem) {
        ItemStack stack = this.getDisplayedItem();
        boolean addNewItem = false;
        if (stack.m_41619_()) {
            Item i = this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_().m_5456_();
            if (PulleyBlockTile.getContentType(i) == ModBlockProperties.Winding.NONE) {
                return false;
            }
            stack = new ItemStack((ItemLike)i);
            addNewItem = true;
        }
        if (stack.m_41613_() + 1 > stack.m_41741_() || !(stack.m_41720_() instanceof BlockItem)) {
            return false;
        }
        Block ropeBlock = ((BlockItem)stack.m_41720_()).m_40614_();
        boolean success = RopeHelper.removeRope(this.f_58858_.m_121945_(moveDir), this.f_58857_, ropeBlock, moveDir, maxDist);
        if (success) {
            SoundType soundtype = ropeBlock.m_49966_().m_60827_();
            this.f_58857_.m_5594_(null, this.f_58858_, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (addNewItem) {
                this.setDisplayedItem(stack);
            } else if (addItem) {
                stack.m_41769_(1);
            }
            this.m_6596_();
        }
        return success;
    }

    public boolean releaseRopeDown() {
        return this.releaseRope(Direction.DOWN, Integer.MAX_VALUE, true);
    }

    public boolean releaseRope(Direction dir, int maxDist, boolean removeItem) {
        Item item;
        ItemStack stack = this.getDisplayedItem();
        if (stack.m_41613_() < 1 || !((item = stack.m_41720_()) instanceof BlockItem)) {
            return false;
        }
        BlockItem bi = (BlockItem)item;
        Block ropeBlock = bi.m_40614_();
        boolean success = RopeHelper.addRope(this.f_58858_.m_121945_(dir), this.f_58857_, null, InteractionHand.MAIN_HAND, ropeBlock, dir, dir == Direction.DOWN, maxDist);
        if (success) {
            SoundType soundtype = ropeBlock.m_49966_().m_60827_();
            this.f_58857_.m_5594_(null, this.f_58858_, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            if (removeItem) {
                stack.m_41774_(1);
                this.m_6596_();
            }
        }
        return success;
    }

    public boolean rotateIndirect(Player player, InteractionHand hand, Block ropeBlock, Direction moveDir, boolean retracting) {
        Direction[] directionArray;
        ItemStack stack = this.getDisplayedItem();
        if (stack.m_41619_()) {
            if (retracting) {
                return false;
            }
            this.setDisplayedItem(new ItemStack((ItemLike)ropeBlock));
            return true;
        }
        if (!stack.m_150930_(ropeBlock.m_5456_())) {
            return false;
        }
        BlockState state = this.m_58900_();
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)PulleyBlock.f_55923_);
        if (axis == moveDir.m_122434_()) {
            return false;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61122_((Property)PulleyBlock.FLIPPED));
        if (moveDir.m_122434_().m_122479_()) {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = Direction.DOWN;
        } else {
            Direction[] directionArray3 = new Direction[3];
            directionArray3[0] = moveDir;
            directionArray3[1] = moveDir.m_175362_(axis);
            directionArray = directionArray3;
            directionArray3[2] = moveDir.m_175364_(axis);
        }
        Direction[] order = directionArray;
        ArrayList<Direction> remaining = new ArrayList<Direction>();
        int maxSideDist = 7;
        for (Direction d : order) {
            if (RopeHelper.isCorrectRope(ropeBlock, this.f_58857_.m_8055_(this.f_58858_.m_121945_(d)), d)) {
                return this.moveConnected(retracting, maxSideDist, d);
            }
            remaining.add(d);
        }
        for (Direction d : remaining) {
            if (!this.moveConnected(retracting, maxSideDist, d)) continue;
            return true;
        }
        if (retracting) {
            stack.m_41774_(1);
            this.m_6596_();
            return true;
        }
        return false;
    }

    private boolean moveConnected(boolean retracting, int maxSideDist, Direction d) {
        int dist;
        int n = dist = d == Direction.DOWN ? Integer.MAX_VALUE : maxSideDist;
        if (retracting) {
            return this.pullRope(d, dist, false);
        }
        return this.releaseRope(d, dist, false);
    }

    public boolean needsToUpdateClientWhenChanged() {
        return false;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return null;
    }
}

