/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.claims.sync;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.BitStorage;
import xaero.pac.client.claims.ClientClaimsManager;
import xaero.pac.client.claims.player.ClientPlayerClaimInfoManager;
import xaero.pac.common.claims.PlayerChunkClaimHolder;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.result.api.AreaClaimResult;
import xaero.pac.common.claims.storage.RegionClaimsPaletteStorage;

public class ClientClaimsSyncHandler {
    private final ClientClaimsManager claimsManager;
    private ResourceLocation dimensionSyncing;
    private ResourceLocation lastClaimUpdateDimension;
    private PlayerChunkClaim lastClaimUpdateState;
    private int lastClaimUpdateX;
    private int lastClaimUpdateZ;

    public ClientClaimsSyncHandler(ClientClaimsManager claimsManager) {
        this.claimsManager = claimsManager;
    }

    public void onPlayerInfo(UUID playerId, String username) {
        ((ClientPlayerClaimInfoManager)this.claimsManager.getPlayerClaimInfoManager()).updatePlayerInfo(playerId, username, this.claimsManager);
    }

    public void onSubClaimInfo(UUID playerId, int subConfigIndex, String claimsName, Integer claimsColor) {
        ((ClientPlayerClaimInfoManager)this.claimsManager.getPlayerClaimInfoManager()).updateSubClaimInfo(playerId, subConfigIndex, claimsName, claimsColor, this.claimsManager);
    }

    public void onClaimState(PlayerChunkClaim claim) {
        this.claimsManager.addClaimState(claim);
    }

    public void onLoading(boolean start) {
        this.claimsManager.setLoading(start);
    }

    public void onClaimLimits(int loadingClaimCount, int loadingForceloadCount, int claimLimit, int forceloadLimit, int maxClaimDistance, boolean alwaysUseLoadingValues) {
        this.claimsManager.setLoadingClaimCount(loadingClaimCount);
        this.claimsManager.setLoadingForceloadCount(loadingForceloadCount);
        this.claimsManager.setClaimLimit(claimLimit);
        this.claimsManager.setForceloadLimit(forceloadLimit);
        this.claimsManager.setMaxClaimDistance(maxClaimDistance);
        this.claimsManager.setAlwaysUseLoadingValues(alwaysUseLoadingValues);
    }

    public void onSubConfigIndices(int currentSubConfigIndex, int currentServerSubConfigIndex, String currentSubConfigId, String currentServerSubConfigId) {
        this.claimsManager.setCurrentSubConfigIndex(currentSubConfigIndex);
        this.claimsManager.setCurrentServerSubConfigIndex(currentServerSubConfigIndex);
        this.claimsManager.setCurrentSubConfigId(currentSubConfigId);
        this.claimsManager.setCurrentServerSubConfigId(currentServerSubConfigId);
    }

    public void onDimension(ResourceLocation dim) {
        this.dimensionSyncing = dim;
    }

    public void onClaimUpdate(ResourceLocation dimension, int x, int z, UUID playerId, int subConfigIndex, boolean forceload, int claimSyncIndex) {
        if (playerId != null) {
            if (this.claimsManager.getClaimStateBySyncIndex(claimSyncIndex) == null) {
                this.claimsManager.addClaimState(new PlayerChunkClaim(playerId, subConfigIndex, forceload, claimSyncIndex));
            }
            this.lastClaimUpdateState = this.claimsManager.claim(dimension, playerId, subConfigIndex, x, z, forceload);
        } else {
            this.claimsManager.unclaim(dimension, x, z);
            this.lastClaimUpdateState = null;
        }
        this.lastClaimUpdateDimension = dimension;
        this.lastClaimUpdateX = x;
        this.lastClaimUpdateZ = z;
    }

    public void onClaimUpdatePos(int x, int z) {
        if (this.lastClaimUpdateDimension == null) {
            throw new IllegalStateException();
        }
        if (this.lastClaimUpdateState != null) {
            this.claimsManager.claim(this.lastClaimUpdateDimension, this.lastClaimUpdateState.getPlayerId(), this.lastClaimUpdateState.getSubConfigIndex(), x, z, this.lastClaimUpdateState.isForceloadable());
        } else {
            this.claimsManager.unclaim(this.lastClaimUpdateDimension, x, z);
        }
        this.lastClaimUpdateX = x;
        this.lastClaimUpdateZ = z;
    }

    public void onClaimUpdateNextXPos() {
        this.onClaimUpdatePos(this.lastClaimUpdateX + 1, this.lastClaimUpdateZ);
    }

    public void onClaimUpdateNextZPos() {
        this.onClaimUpdatePos(this.lastClaimUpdateX, this.lastClaimUpdateZ + 1);
    }

    public void onRegion(int x, int z, int[] paletteInts, BitStorage storage) {
        Object2IntOpenHashMap paletteHelper = new Object2IntOpenHashMap();
        ArrayList palette = Lists.newArrayList((Object[])new PlayerChunkClaimHolder[]{null});
        for (int i = 0; i < paletteInts.length; ++i) {
            PlayerChunkClaim claim = this.claimsManager.getClaimStateBySyncIndex(paletteInts[i]);
            if (claim != null) {
                paletteHelper.put((Object)claim, palette.size());
            }
            palette.add(new PlayerChunkClaimHolder(claim));
        }
        RegionClaimsPaletteStorage newRegionStorage = new RegionClaimsPaletteStorage((Object2IntMap<PlayerChunkClaim>)paletteHelper, null, palette, storage, false);
        newRegionStorage.setNeedsHolderRecalculation(true);
        this.claimsManager.claimRegion(this.dimensionSyncing, x, z, newRegionStorage);
    }

    public void onClaimResult(AreaClaimResult result) {
        this.claimsManager.getClaimResultTracker().onClaimResult(result);
    }

    public void onClaimModes(boolean adminMode, boolean serverMode) {
        this.claimsManager.setAdminMode(adminMode);
        this.claimsManager.setServerMode(serverMode);
    }

    public void onClaimStateRemoved(int syncIndex) {
        PlayerChunkClaim state = this.claimsManager.getClaimStateBySyncIndex(syncIndex);
        if (state != null) {
            this.claimsManager.removeClaimState(state);
        }
    }

    public void onRemoveSubClaim(UUID playerId, int subConfigIndex) {
        this.claimsManager.removeSubClaim(playerId, subConfigIndex);
    }

    public void reset() {
        this.dimensionSyncing = null;
        this.lastClaimUpdateState = null;
        this.lastClaimUpdateDimension = null;
    }
}

