/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims.player;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.api.IPlayerChunkClaimAPI;

public class PlayerChunkClaim
implements IPlayerChunkClaim {
    private final UUID playerId;
    private final int subConfigIndex;
    private final boolean forceloadable;
    private final int syncIndex;

    public PlayerChunkClaim(UUID playerId, int subConfigIndex, boolean forceloadable, int syncIndex) {
        this.playerId = playerId;
        this.subConfigIndex = subConfigIndex;
        this.forceloadable = forceloadable;
        this.syncIndex = syncIndex;
    }

    @Override
    public boolean isForceloadable() {
        return this.forceloadable;
    }

    public static long getLongCoordinatesFor(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public static int getXFromLongCoordinates(long key) {
        return (int)(key >> 32);
    }

    public static int getZFromLongCoordinates(long key) {
        return (int)(key & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    @Nonnull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public int getSubConfigIndex() {
        return this.subConfigIndex;
    }

    public int getSyncIndex() {
        return this.syncIndex;
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.subConfigIndex, this.forceloadable);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PlayerChunkClaim)) {
            return false;
        }
        PlayerChunkClaim other = (PlayerChunkClaim)obj;
        return this.playerId.equals(other.playerId) && this.forceloadable == other.forceloadable && this.subConfigIndex == other.subConfigIndex;
    }

    @Override
    public boolean isSameClaimType(IPlayerChunkClaimAPI other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.playerId.equals(other.getPlayerId()) && this.subConfigIndex == other.getSubConfigIndex();
    }

    public String toString() {
        return String.format("[%s, %d, %s, %d]", this.playerId, this.subConfigIndex, this.forceloadable, this.syncIndex);
    }
}

