/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims.result.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import xaero.pac.common.claims.result.api.ClaimResult;

public class AreaClaimResult {
    private final List<ClaimResult.Type> resultTypes;
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;

    public AreaClaimResult(Set<ClaimResult.Type> resultTypes, int left, int top, int right, int bottom) {
        List<ClaimResult.Type> resultTypeList = Arrays.asList(resultTypes.toArray(new ClaimResult.Type[resultTypes.size()]));
        Collections.sort(resultTypeList);
        this.resultTypes = Collections.unmodifiableList(resultTypeList);
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public int getSize() {
        return this.resultTypes.size();
    }

    @Nonnull
    public Iterable<ClaimResult.Type> getResultTypesIterable() {
        return this.resultTypes;
    }

    @Nonnull
    public Stream<ClaimResult.Type> getResultTypesStream() {
        return this.resultTypes.stream();
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }
}

