/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.sync.player;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.ServerClaimStateHolder;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.sync.ClaimsManagerSynchronizer;
import xaero.pac.common.server.claims.sync.player.ClaimsManagerPlayerLazyPacketScheduler;
import xaero.pac.common.server.claims.sync.player.ClaimsManagerPlayerSubClaimPropertiesSync;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.PlayerConfig;

public final class ClaimsManagerPlayerStateSync
extends ClaimsManagerPlayerLazyPacketScheduler {
    private final UUID playerId;
    private final ClaimsManagerPlayerSubClaimPropertiesSync subClaimPropertiesSync;
    private List<PlayerChunkClaim> packetBuilder;
    private Iterator<ServerClaimStateHolder> iterator;
    private final boolean ownedOnly;

    private ClaimsManagerPlayerStateSync(UUID playerId, ClaimsManagerSynchronizer synchronizer, ClaimsManagerPlayerSubClaimPropertiesSync subClaimPropertiesSync, Iterator<ServerClaimStateHolder> iterator, boolean ownedOnly) {
        super(synchronizer);
        this.playerId = playerId;
        this.subClaimPropertiesSync = subClaimPropertiesSync;
        this.iterator = iterator;
        this.ownedOnly = ownedOnly;
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, ServerPlayer player, int limit) {
        if (this.packetBuilder == null) {
            this.packetBuilder = this.startClaimStateSync();
        }
        for (int canSync = limit; this.iterator != null && this.iterator.hasNext() && canSync > 0; --canSync) {
            PlayerChunkClaim state = this.iterator.next().getState();
            if (this.ownedOnly && !state.getPlayerId().equals(this.playerId) && !state.getPlayerId().equals(PlayerConfig.SERVER_CLAIM_UUID)) continue;
            this.continueClaimStateSync(this.packetBuilder, state, player);
            canSync -= 2;
        }
        this.finalizeClaimStateSync(this.packetBuilder, player);
        if (this.isFinished()) {
            this.packetBuilder = null;
        }
    }

    public List<PlayerChunkClaim> startClaimStateSync() {
        return new ArrayList<PlayerChunkClaim>(128);
    }

    public void continueClaimStateSync(List<PlayerChunkClaim> packetBuilder, PlayerChunkClaim state, ServerPlayer player) {
        packetBuilder.add(state);
        if (packetBuilder.size() == 128) {
            this.synchronizer.syncClaimStates(packetBuilder, player);
            packetBuilder.clear();
        }
    }

    public void finalizeClaimStateSync(List<PlayerChunkClaim> packetBuilder, ServerPlayer player) {
        if (!packetBuilder.isEmpty()) {
            this.synchronizer.syncClaimStates(packetBuilder, player);
            packetBuilder.clear();
        }
    }

    @Override
    public void onLazyPacketsDropped() {
        this.iterator = null;
    }

    public boolean isFinished() {
        return this.subClaimPropertiesSync.isFinished() && (this.iterator == null || !this.iterator.hasNext());
    }

    @Override
    public boolean shouldWorkNotClogged(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, ServerPlayer player) {
        return this.started && this.subClaimPropertiesSync.isFinished() && !this.isFinished();
    }

    public static final class Builder {
        private ServerPlayer player;
        private ClaimsManagerSynchronizer synchronizer;
        private ClaimsManagerPlayerSubClaimPropertiesSync subClaimPropertiesSync;

        private Builder() {
        }

        public Builder setDefault() {
            this.setPlayer(null);
            this.setSynchronizer(null);
            this.setSubClaimPropertiesSync(null);
            return this;
        }

        public Builder setPlayer(ServerPlayer player) {
            this.player = player;
            return this;
        }

        public Builder setSynchronizer(ClaimsManagerSynchronizer synchronizer) {
            this.synchronizer = synchronizer;
            return this;
        }

        public Builder setSubClaimPropertiesSync(ClaimsManagerPlayerSubClaimPropertiesSync subClaimPropertiesSync) {
            this.subClaimPropertiesSync = subClaimPropertiesSync;
            return this;
        }

        public ClaimsManagerPlayerStateSync build() {
            if (this.player == null || this.synchronizer == null || this.subClaimPropertiesSync == null) {
                throw new IllegalStateException();
            }
            boolean ownedOnly = ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.OWNED_ONLY;
            Iterator<ServerClaimStateHolder> iterator = this.synchronizer.getStateHolderIteratorForSync();
            return new ClaimsManagerPlayerStateSync(this.player.m_20148_(), this.synchronizer, this.subClaimPropertiesSync, iterator, ownedOnly);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

