/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.system.impl;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.system.api.IPlayerPartySystemAPI;

public class DefaultPlayerPartySystem
implements IPlayerPartySystemAPI<IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> {
    private final IPartyManager<IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> partyManager;

    public DefaultPlayerPartySystem(IPartyManager<IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> partyManager) {
        this.partyManager = partyManager;
    }

    @Override
    @Nullable
    public IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly> getPartyByOwner(@Nonnull UUID playerId) {
        return this.partyManager.getPartyByOwner(playerId);
    }

    @Override
    @Nullable
    public IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly> getPartyByMember(@Nonnull UUID playerId) {
        return this.partyManager.getPartyByMember(playerId);
    }

    @Override
    public boolean isPlayerAllying(@Nonnull UUID playerId, @Nonnull UUID potentialAllyPlayerId) {
        Object playerParty = this.getPartyByMember(playerId);
        if (playerParty == null) {
            return false;
        }
        Object potentialAllyPlayerParty = this.getPartyByMember(potentialAllyPlayerId);
        if (potentialAllyPlayerParty == null) {
            return false;
        }
        return playerParty.isAlly(potentialAllyPlayerParty.getId());
    }

    @Override
    public boolean isPermittedToPartyClaim(@Nonnull UUID playerId) {
        Object party = this.getPartyByMember(playerId);
        if (party == null) {
            return false;
        }
        IPartyMemberAPI member = party.getMemberInfo(playerId);
        return member != null && member.getRank().ordinal() >= PartyMemberRank.MODERATOR.ordinal();
    }
}

