/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config.sub;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import xaero.pac.common.list.SortedValueList;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.util.linked.ILinkedChainNode;
import xaero.pac.common.util.linked.LinkedChain;

public class PlayerSubConfig<P extends IServerParty<?, ?, ?>>
extends PlayerConfig<P>
implements ILinkedChainNode<PlayerSubConfig<P>>,
IPlayerConfig {
    public static final Set<IPlayerConfigOptionSpecAPI<?>> STATIC_OVERRIDABLE_OPTIONS = new HashSet();
    private final PlayerConfig<P> mainConfig;
    private final String subId;
    private final int subIndex;
    private PlayerSubConfig<P> nextInChain;
    private PlayerSubConfig<P> previousInChain;
    private boolean destroyed;

    private PlayerSubConfig(PlayerConfig<P> mainConfig, String subId, PlayerConfigType type, UUID playerId, PlayerConfigManager<P, ?> manager, Map<PlayerConfigOptionSpec<?>, Object> automaticDefaultValues, LinkedChain<PlayerSubConfig<P>> linkedSubConfigs, Map<String, PlayerSubConfig<P>> subByID, Int2ObjectMap<String> subIndexToID, SortedValueList<String> subConfigIds, List<String> subConfigIdsUnmodifiable, int subIndex) {
        super(type, playerId, manager, automaticDefaultValues, linkedSubConfigs, subByID, subIndexToID, subConfigIds, subConfigIdsUnmodifiable);
        this.mainConfig = mainConfig;
        this.subId = subId;
        this.subIndex = subIndex;
    }

    @Override
    public Config getStorage() {
        if (this.storage == null) {
            this.setStorage(Config.of(LinkedHashMap::new, (ConfigFormat)TomlFormat.instance()));
            this.setDirty(true);
        }
        return this.storage;
    }

    @Override
    public boolean isOptionAllowed(@Nonnull IPlayerConfigOptionSpecAPI<?> option) {
        return super.isOptionAllowed(option) && this.manager.getOverridableOptions().contains(option);
    }

    private <T extends Comparable<T>> T getInner(IPlayerConfigOptionSpecAPI<T> o, boolean inherit) {
        PlayerConfigOptionSpec option = (PlayerConfigOptionSpec)o;
        if (!this.manager.getOverridableOptions().contains(option)) {
            return inherit ? (T)this.mainConfig.getFromEffectiveConfig(option) : null;
        }
        if (this.isOptionDefaulted(option)) {
            return inherit ? (T)((PlayerConfig)this.manager.getDefaultConfig()).getFromEffectiveConfig(option) : null;
        }
        Config storage = this.getStorage();
        Comparable overrideValue = (Comparable)storage.get(option.getPath());
        if (overrideValue == null && inherit) {
            return this.mainConfig.getFromEffectiveConfig(option);
        }
        return (T)overrideValue;
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getFromEffectiveConfig(@Nonnull IPlayerConfigOptionSpecAPI<T> o) {
        return this.getInner(o, true);
    }

    public boolean isInherited(IPlayerConfigOptionSpecAPI<?> o) {
        return this.getInner(o, false) == null;
    }

    @Override
    protected <T extends Comparable<T>> boolean isValidSetValue(@Nonnull PlayerConfigOptionSpec<T> option, @Nullable T value) {
        return value == null || super.isValidSetValue(option, value);
    }

    @Override
    protected <T extends Comparable<T>> T getValueForDefaultConfigMatch(T actualEffective, T value) {
        return null;
    }

    @Override
    @Nullable
    public <T extends Comparable<T>> T getDefaultRawValue(@Nonnull IPlayerConfigOptionSpecAPI<T> option) {
        return null;
    }

    public PlayerConfig<P> getMainConfig() {
        return this.mainConfig;
    }

    @Override
    @Nullable
    public String getSubId() {
        return this.subId;
    }

    @Override
    public int getSubIndex() {
        return this.subIndex;
    }

    @Override
    @Nullable
    public PlayerSubConfig<P> createSubConfig(@Nonnull String id) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getUsedSubConfig() {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    @Nullable
    public PlayerConfig<P> getSubConfig(@Nonnull String id) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getEffectiveSubConfig(int subIndex) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public boolean subConfigExists(@Nonnull String id) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public boolean subConfigExists(int subIndex) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public PlayerSubConfig<P> removeSubConfig(String id) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public PlayerSubConfig<P> removeSubConfig(int index) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public PlayerSubConfig<P> createSubConfig(String id, int index) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    @Nonnull
    public List<String> getSubConfigIds() {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public Stream<PlayerSubConfig<P>> getSubConfigStream() {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public int getSubCount() {
        return 0;
    }

    @Override
    public int getSubConfigLimit() {
        return 0;
    }

    @Override
    public void setNext(PlayerSubConfig<P> element) {
        this.nextInChain = element;
    }

    @Override
    public void setPrevious(PlayerSubConfig<P> element) {
        this.previousInChain = element;
    }

    @Override
    public PlayerSubConfig<P> getNext() {
        return this.nextInChain;
    }

    @Override
    public PlayerSubConfig<P> getPrevious() {
        return this.previousInChain;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void onDestroyed() {
        this.destroyed = true;
    }

    static {
        STATIC_OVERRIDABLE_OPTIONS.addAll(PlayerConfigOptions.OPTIONS.values());
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.USED_SUBCLAIM);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.USED_SERVER_SUBCLAIM);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.PARTY_NAME);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.BONUS_CHUNK_CLAIMS);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.BONUS_CHUNK_FORCELOADS);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.SHARE_LOCATION_WITH_PARTY_MUTUAL_ALLIES);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.RECEIVE_LOCATIONS_FROM_PARTY_MUTUAL_ALLIES);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.FORCELOAD);
        STATIC_OVERRIDABLE_OPTIONS.remove(PlayerConfigOptions.OFFLINE_FORCELOAD);
    }

    public static final class Builder<P extends IServerParty<?, ?, ?>>
    extends PlayerConfig.Builder<P, Builder<P>> {
        private PlayerConfig<P> mainConfig;
        private String subId;
        private int subIndex;

        @Override
        public Builder<P> setDefault() {
            super.setDefault();
            this.setMainConfig(null);
            this.setSubId(null);
            this.setSubIndex(-1);
            return (Builder)this.self;
        }

        public Builder<P> setMainConfig(PlayerConfig<P> mainConfig) {
            this.mainConfig = mainConfig;
            return (Builder)this.self;
        }

        public Builder<P> setSubId(String subId) {
            this.subId = subId;
            return (Builder)this.self;
        }

        public Builder<P> setSubIndex(int subIndex) {
            this.subIndex = subIndex;
            return (Builder)this.self;
        }

        @Override
        public PlayerSubConfig<P> build() {
            if (this.mainConfig == null || this.subId == null || this.subIndex == -1) {
                throw new IllegalStateException();
            }
            if (!Objects.equals(this.mainConfig.getPlayerId(), this.playerId)) {
                throw new IllegalArgumentException("Mismatching player config UUIDs!");
            }
            return (PlayerSubConfig)super.build();
        }

        @Override
        protected PlayerSubConfig<P> buildInternally() {
            return new PlayerSubConfig<P>(this.mainConfig, this.subId, this.type, this.playerId, this.manager, this.automaticDefaultValues, null, null, null, null, null, this.subIndex);
        }

        public static <P extends IServerParty<?, ?, ?>> Builder<P> begin() {
            return new Builder<P>().setDefault();
        }
    }
}

