/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.task.IServerSpreadoutTask;

public abstract class ServerSpreadoutTaskHandler<T extends IServerSpreadoutTask<T, H>, H> {
    protected final Function<H, T> holderToTask;
    protected final int perTickLimit;
    protected final int perTickPerTaskLimit;

    protected ServerSpreadoutTaskHandler(Function<H, T> holderToTask, int perTickLimit, int perTickPerTaskLimit) {
        this.holderToTask = holderToTask;
        this.perTickLimit = perTickLimit;
        this.perTickPerTaskLimit = perTickPerTaskLimit;
    }

    protected abstract Iterator<H> getTaskHolderIterator(IServerData<?, ?> var1);

    protected void handleTasksToAdd(List<T> tasksToAdd) {
    }

    public void onTick(IServerData<?, ?> serverDataA) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = serverDataA;
        int taskCount = 0;
        Iterator<H> taskHolderIterator = this.getTaskHolderIterator(serverData);
        while (taskHolderIterator.hasNext()) {
            H taskHolder = taskHolderIterator.next();
            IServerSpreadoutTask task = (IServerSpreadoutTask)this.holderToTask.apply(taskHolder);
            if (!task.shouldWork(serverData, taskHolder)) continue;
            ++taskCount;
        }
        if (taskCount == 0) {
            return;
        }
        int perTask = Math.min(this.perTickPerTaskLimit, this.perTickLimit / taskCount);
        if (perTask == 0) {
            perTask = 1;
        }
        int allowedCount = this.perTickLimit;
        taskHolderIterator = this.getTaskHolderIterator(serverData);
        ArrayList tasksToAdd = new ArrayList();
        while (taskHolderIterator.hasNext() && allowedCount-- > 0) {
            H taskHolder = taskHolderIterator.next();
            IServerSpreadoutTask task = (IServerSpreadoutTask)this.holderToTask.apply(taskHolder);
            if (task.shouldWork(serverData, taskHolder)) {
                task.onTick(serverData, taskHolder, perTask, tasksToAdd);
            }
            if (!this.canDropTasks() || !task.shouldDrop(serverData, taskHolder)) continue;
            taskHolderIterator.remove();
        }
        this.handleTasksToAdd(tasksToAdd);
    }

    protected boolean canDropTasks() {
        return true;
    }

    public static abstract class Builder<T extends IServerSpreadoutTask<T, H>, H, B extends Builder<T, H, B>> {
        protected final B self;
        protected Function<H, T> holderToTask;
        protected int perTickLimit;
        protected int perTickPerTaskLimit;

        protected Builder() {
            Builder self = this;
            this.self = self;
        }

        public B setDefault() {
            this.setHolderToTask(null);
            this.setPerTickLimit(-1);
            this.setPerTickPerTaskLimit(-1);
            return this.self;
        }

        public B setHolderToTask(Function<H, T> holderToTask) {
            this.holderToTask = holderToTask;
            return this.self;
        }

        public B setPerTickLimit(int perTickLimit) {
            this.perTickLimit = perTickLimit;
            return this.self;
        }

        public B setPerTickPerTaskLimit(int perTickPerTaskLimit) {
            this.perTickPerTaskLimit = perTickPerTaskLimit;
            return this.self;
        }

        public ServerSpreadoutTaskHandler<T, H> build() {
            if (this.perTickLimit == -1 || this.perTickPerTaskLimit == -1 || this.holderToTask == null) {
                throw new IllegalStateException();
            }
            return this.buildInternally();
        }

        protected abstract ServerSpreadoutTaskHandler<T, H> buildInternally();
    }
}

