/*
 * Decompiled with CFR 0.152.
 */
package co.uk.mommyheather.advancedbackups.cli;

import co.uk.mommyheather.advancedbackups.cli.CLIIOHelpers;
import co.uk.mommyheather.advancedbackups.cli.IllegalBackupException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.fusesource.jansi.AnsiConsole;

public class AdvancedBackupsCLI {
    private static String backupLocation;
    private static File serverDir;
    private static String type;
    private static ArrayList<String> fileNames;
    private static File worldFile;
    private static String worldPath;

    public static void main(String[] args) throws IllegalBackupException {
        int backupDateIndex;
        String result;
        if (System.console() != null) {
            AnsiConsole.systemInstall();
        }
        System.out.print("\u001b[H\u001b[2J");
        System.out.flush();
        CLIIOHelpers.info("Advanced Backups - Version " + AdvancedBackupsCLI.class.getPackage().getImplementationVersion());
        CLIIOHelpers.info("Note : this cannot restore backups made prior to the 3.0 release.");
        CLIIOHelpers.info("Searching for properties...", false);
        Properties props = new Properties();
        File file = new File(serverDir, "config/AdvancedBackups.properties");
        try {
            FileReader reader = new FileReader(file);
            props.load(reader);
            backupLocation = props.getProperty("config.advancedbackups.path");
            type = props.getProperty("config.advancedbackups.type");
        }
        catch (Exception e) {
            CLIIOHelpers.error("ERROR LOADING PROPERTIES!");
            CLIIOHelpers.error(AdvancedBackupsCLI.getStackTrace(e));
            CLIIOHelpers.error("");
            CLIIOHelpers.error("");
            CLIIOHelpers.error("Ensure you're running this from within the mods directory, and the config file is in the parent directory!");
            return;
        }
        if (backupLocation == null || type == null) {
            CLIIOHelpers.error("ERROR LOADING PROPERTIES!");
            CLIIOHelpers.error("Backup location : " + backupLocation);
            CLIIOHelpers.error("Type : " + type);
            return;
        }
        CLIIOHelpers.info("Config loaded!");
        File backupDir = new File(serverDir, backupLocation.replaceAll(Pattern.quote("." + File.separator), ""));
        if (!backupDir.exists() && !(backupDir = new File(backupLocation.replaceAll(Pattern.quote("." + File.separator), ""))).exists()) {
            CLIIOHelpers.error("Could not find backup directory!");
            CLIIOHelpers.error(backupDir.getAbsolutePath());
            CLIIOHelpers.error("Have you made any backups before?");
            return;
        }
        boolean flag = false;
        ArrayList<File> otherBackups = new ArrayList<File>();
        for (File b : backupDir.listFiles()) {
            if (!b.getName().endsWith("zip")) continue;
            flag = true;
            otherBackups.add(b);
        }
        if (flag && (result = CLIIOHelpers.getSelectionFromList("Backups from another mod have been found. These can be restored if you want.\nWould you want to work with these backups?", Arrays.asList("Use backups from AdvancedBackups", "Use backups from other mod"))) == "Use backups from other mod") {
            AdvancedBackupsCLI.restoreOtherModZip(backupDir);
            return;
        }
        if ((type = CLIIOHelpers.getBackupType(type)).equals("snapshot (command-made only)")) {
            type = "snapshots";
        }
        boolean exportMode = false;
        CLIIOHelpers.info("Do you want to export a backup, restore the entire world state at this point, or a singular file?");
        String restore = CLIIOHelpers.getSelectionFromList("Enter a number.", Arrays.asList("Export backup as zip", "Restore single file", "Restore entire world"));
        if (restore.equals("Export backup as zip")) {
            exportMode = true;
        }
        worldFile = CLIIOHelpers.getWorldFile(serverDir);
        worldPath = worldFile.getName().replace(" ", "_");
        backupDir = new File(backupDir, worldFile.getName() + "/" + type);
        try {
            backupDateIndex = AdvancedBackupsCLI.getBackupDate(backupDir, exportMode);
        }
        catch (IOException e) {
            CLIIOHelpers.error("ERROR VIEWING BACKUPS!");
            e.printStackTrace();
            return;
        }
        if (exportMode) {
            worldFile = new File(serverDir, "AdvancedBackups.temp");
            worldFile.mkdirs();
        }
        if (!CLIIOHelpers.confirmWarningMessage()) {
            CLIIOHelpers.error("ABORTED - WILL NOT PROCEED.");
            return;
        }
        CLIIOHelpers.info("Preparing...");
        switch (restore) {
            case "Restore entire world": {
                CLIIOHelpers.info("Backing up current world state...");
                CLIIOHelpers.info("Backup saved to : " + AdvancedBackupsCLI.deleteEntireWorld(worldFile, false));
                switch (type) {
                    case "snapshots": 
                    case "zips": {
                        AdvancedBackupsCLI.restoreFullZip(backupDateIndex, worldFile);
                        return;
                    }
                    case "differential": {
                        AdvancedBackupsCLI.restoreFullDifferential(backupDateIndex, worldFile);
                        return;
                    }
                    case "incremental": {
                        AdvancedBackupsCLI.restoreFullIncremental(backupDateIndex, worldFile);
                        return;
                    }
                }
            }
            case "Restore single file": {
                switch (type) {
                    case "snapshots": 
                    case "zips": {
                        AdvancedBackupsCLI.restorePartialZip(backupDateIndex, worldFile);
                        return;
                    }
                    case "differential": {
                        AdvancedBackupsCLI.restorePartialDifferential(backupDateIndex, worldFile);
                        return;
                    }
                    case "incremental": {
                        AdvancedBackupsCLI.restorePartialIncremental(backupDateIndex, worldFile);
                        return;
                    }
                }
            }
            case "Export backup as zip": {
                CLIIOHelpers.info("Restoring to temporary directory...");
                switch (type) {
                    case "snapshots": 
                    case "zips": {
                        AdvancedBackupsCLI.restoreFullZip(backupDateIndex, worldFile);
                        break;
                    }
                    case "differential": {
                        AdvancedBackupsCLI.restoreFullDifferential(backupDateIndex, worldFile);
                        break;
                    }
                    case "incremental": {
                        AdvancedBackupsCLI.restoreFullIncremental(backupDateIndex, worldFile);
                    }
                }
                CLIIOHelpers.info("Done. Preparing to write to zip...");
                CLIIOHelpers.info("Export saved to : " + AdvancedBackupsCLI.deleteEntireWorld(worldFile, true));
            }
        }
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private static int getBackupDate(File backupDir, boolean exportMode) throws IOException {
        int inputType;
        fileNames.clear();
        CLIIOHelpers.info("Select a backup to restore.");
        String[] fileNameArray = backupDir.list();
        if (fileNameArray == null || fileNameArray.length <= 0) {
            throw new IOException(String.format("Selected backup directory %s is empty, or is a file!", backupDir.getAbsolutePath()));
        }
        ArrayList<String> fileNameList = new ArrayList<String>(Arrays.asList(fileNameArray));
        fileNameList.removeIf(name -> name.endsWith("json") || name.contains("incomplete") || name.contains("DS_Store"));
        if (fileNameList.isEmpty()) {
            throw new IOException(String.format("Selected backup directory %s is empty, or is a file!", backupDir.getAbsolutePath()));
        }
        for (String fileName : CLIIOHelpers.sortStringsAlphabeticallyWithDirectoryPriority(fileNameList)) {
            String out;
            File file;
            if (exportMode) {
                if (fileName.endsWith("json") || fileName.contains("incomplete")) continue;
                file = new File(backupDir, fileName);
                fileNames.add(file.getAbsolutePath());
                out = file.getName();
                String[] outs = out.split("\\_");
                out = outs.length >= 2 ? ". " + outs[outs.length - 2] + "_" + outs[outs.length - 1] : ". " + out;
                CLIIOHelpers.info(fileNames.size() + out);
                continue;
            }
            if (fileName.endsWith("json") || fileName.contains("incomplete")) continue;
            file = new File(backupDir, fileName);
            fileNames.add(file.getAbsolutePath());
            out = file.getName();
            out = out.replaceAll(".zip", "");
            out = out.replaceAll("backup_", ": ");
            out = out.replaceAll("-partial", "\u001b[33m partial\u001b[0m");
            out = out.replaceAll("-full", "\u001b[32m full\u001b[0m");
            CLIIOHelpers.info(fileNames.size() + out);
        }
        try {
            String line = CLIIOHelpers.input.nextLine();
            if (line == "") {
                CLIIOHelpers.warn("Please enter a number.");
                return AdvancedBackupsCLI.getBackupDate(backupDir, exportMode);
            }
            inputType = Integer.parseInt(line);
        }
        catch (NumberFormatException | InputMismatchException e) {
            CLIIOHelpers.warn("That was not a number. Please enter a number.");
            return AdvancedBackupsCLI.getBackupDate(backupDir, exportMode);
        }
        if (inputType < 1 || inputType > fileNames.size()) {
            CLIIOHelpers.warn("Please enter a number between " + fileNames.size() + ".");
            return AdvancedBackupsCLI.getBackupDate(backupDir, exportMode);
        }
        return inputType - 1;
    }

    private static void restoreFullZip(int index, File worldFile) throws IllegalBackupException {
        byte[] buffer = new byte[1024];
        try {
            ZipEntry entry;
            FileInputStream fileInputStream = new FileInputStream(fileNames.get(index));
            ZipInputStream zip = new ZipInputStream(fileInputStream);
            while ((entry = zip.getNextEntry()) != null) {
                File outputFile = new File(worldFile, entry.getName());
                if (!outputFile.toPath().normalize().startsWith(worldFile.toPath())) {
                    zip.close();
                    CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                    throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + entry.getName());
                }
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                CLIIOHelpers.info("Restoring " + outputFile.getName());
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                int length = 0;
                while ((length = zip.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
                outputStream.close();
            }
            zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void restoreFullDifferential(int index, File worldFile) throws IllegalBackupException {
        File backup = new File(fileNames.get(index));
        if (backup.getName().contains("-full")) {
            if (backup.isFile()) {
                AdvancedBackupsCLI.restoreFullZip(index, worldFile);
                return;
            }
            AdvancedBackupsCLI.restoreFolder(index, worldFile);
            return;
        }
        for (int i = index; i >= 0; --i) {
            String name = fileNames.get(i);
            if (!name.contains("-full")) continue;
            CLIIOHelpers.info("Restoring last full backup...");
            File file = new File(name);
            if (file.isFile()) {
                AdvancedBackupsCLI.restoreFullZip(i, worldFile);
                break;
            }
            AdvancedBackupsCLI.restoreFolder(i, worldFile);
            break;
        }
        CLIIOHelpers.info("\n\nRestoring selected backup...");
        if (backup.isFile()) {
            AdvancedBackupsCLI.restoreFullZip(index, worldFile);
        } else {
            AdvancedBackupsCLI.restoreFolder(index, worldFile);
        }
    }

    private static void restoreFullIncremental(int index, File worldFile) throws IllegalBackupException {
        File file;
        String name;
        int i;
        File backup = new File(fileNames.get(index));
        if (backup.getName().contains("-full")) {
            if (backup.isFile()) {
                AdvancedBackupsCLI.restoreFullZip(index, worldFile);
                return;
            }
            AdvancedBackupsCLI.restoreFolder(index, worldFile);
            return;
        }
        for (i = index; i >= 0; --i) {
            name = fileNames.get(i);
            if (!name.contains("-full")) continue;
            CLIIOHelpers.info("Restoring last full backup...");
            file = new File(name);
            if (file.isFile()) {
                AdvancedBackupsCLI.restoreFullZip(i, worldFile);
                break;
            }
            AdvancedBackupsCLI.restoreFolder(i, worldFile);
            break;
        }
        while (i < index) {
            name = fileNames.get(i);
            CLIIOHelpers.info("Restoring chained backup...");
            file = new File(name);
            if (file.isFile()) {
                AdvancedBackupsCLI.restoreFullZip(i, worldFile);
            } else {
                AdvancedBackupsCLI.restoreFolder(i, worldFile);
            }
            ++i;
        }
        CLIIOHelpers.info("\n\nRestoring selected backup...");
        if (backup.isFile()) {
            AdvancedBackupsCLI.restoreFullZip(index, worldFile);
        } else {
            AdvancedBackupsCLI.restoreFolder(index, worldFile);
        }
    }

    private static void restorePartialZip(int index, File worldFile) throws IllegalBackupException {
        HashMap<String, Object> filePaths = new HashMap<String, Object>();
        HashMap<String, String> dates = new HashMap<String, String>();
        HashMap<String, ZipFile> entryOwners = new HashMap<String, ZipFile>();
        try {
            int length;
            File backup = new File(fileNames.get(index));
            AdvancedBackupsCLI.addBackupNamesToLists(backup, entryOwners, filePaths, dates, "\u001b[32m");
            for (String string : filePaths.keySet()) {
                File outputFile = new File(worldFile, string);
                if (outputFile.toPath().normalize().startsWith(worldFile.toPath())) continue;
                CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + string);
            }
            ZipEntry select = (ZipEntry)CLIIOHelpers.getFileToRestore(filePaths, "", worldFile);
            File outputFile = new File(worldFile, select.toString());
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            CLIIOHelpers.info("Restoring " + select.toString() + "...");
            byte[] buffer = new byte[1028];
            InputStream inputSteam = entryOwners.get(select.toString()).getInputStream(select);
            while ((length = inputSteam.read(buffer, 0, buffer.length)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void restorePartialDifferential(int index, File worldFile) throws IllegalBackupException {
        HashMap<String, Object> filePaths = new HashMap<String, Object>();
        HashMap<String, String> dates = new HashMap<String, String>();
        HashMap<String, ZipFile> entryOwners = new HashMap<String, ZipFile>();
        try {
            File outputFile;
            File backup = new File(fileNames.get(index));
            if (!backup.getName().contains("-full")) {
                for (int i = index; i >= 0; --i) {
                    String name = fileNames.get(i);
                    if (!name.contains("-full")) continue;
                    AdvancedBackupsCLI.addBackupNamesToLists(new File(name), entryOwners, filePaths, dates, "\u001b[31m");
                    break;
                }
            }
            File file = new File(fileNames.get(index));
            AdvancedBackupsCLI.addBackupNamesToLists(file, entryOwners, filePaths, dates, "\u001b[32m");
            HashMap<String, Object> properMapping = new HashMap<String, Object>();
            for (String date : dates.keySet()) {
                properMapping.put(date + " " + dates.get(date), filePaths.get(date));
            }
            for (String string : filePaths.keySet()) {
                outputFile = new File(worldFile, string);
                if (outputFile.toPath().normalize().startsWith(worldFile.toPath())) continue;
                CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + string);
            }
            Object select = CLIIOHelpers.getFileToRestore(properMapping, "", worldFile);
            if (select instanceof Path) {
                Path input = (Path)select;
                if (select.toString().replace("\\", "/").contains("-full/")) {
                    select = new File(select.toString().replace("\\", "/").split("-full/")[1]).toPath();
                }
                if (select.toString().replace("\\", "/").contains("-partial/")) {
                    select = new File(select.toString().replace("\\", "/").split("-partial/")[1]).toPath();
                }
                if (!(outputFile = new File(worldFile, select.toString())).getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                if (!outputFile.toPath().normalize().startsWith(worldFile.toPath())) {
                    CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                    throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + select.toString());
                }
                CLIIOHelpers.info("\n\nRestoring file : " + select);
                Files.copy(input, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else if (select instanceof ZipEntry) {
                int length;
                ZipEntry entry = (ZipEntry)select;
                outputFile = new File(worldFile, entry.toString());
                if (!outputFile.toPath().normalize().startsWith(worldFile.toPath())) {
                    CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                    throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + select.toString());
                }
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                CLIIOHelpers.info("Restoring " + entry.toString() + "...");
                byte[] buffer = new byte[1028];
                InputStream inputSteam = entryOwners.get(entry.toString()).getInputStream(entry);
                while ((length = inputSteam.read(buffer, 0, buffer.length)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void restorePartialIncremental(int index, File worldFile) throws IllegalBackupException {
        HashMap<String, Object> filePaths = new HashMap<String, Object>();
        HashMap<String, String> dates = new HashMap<String, String>();
        HashMap<String, ZipFile> entryOwners = new HashMap<String, ZipFile>();
        try {
            File backup = new File(fileNames.get(index));
            if (!backup.getName().contains("-full")) {
                Object name;
                int i;
                for (i = index; i >= 0; --i) {
                    name = fileNames.get(i);
                    if (!((String)name).contains("-full")) continue;
                    AdvancedBackupsCLI.addBackupNamesToLists(new File((String)name), entryOwners, filePaths, dates, "\u001b[31m");
                    break;
                }
                while (i < index) {
                    name = fileNames.get(i);
                    AdvancedBackupsCLI.addBackupNamesToLists(new File((String)name), entryOwners, filePaths, dates, "\u001b[31m");
                    ++i;
                }
            }
            File file = new File(fileNames.get(index));
            AdvancedBackupsCLI.addBackupNamesToLists(file, entryOwners, filePaths, dates, "\u001b[32m");
            for (String string : filePaths.keySet()) {
                File outputFile = new File(worldFile, string);
                if (outputFile.toPath().normalize().startsWith(worldFile.toPath())) continue;
                CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + string);
            }
            HashMap<String, Object> properMapping = new HashMap<String, Object>();
            for (String date : dates.keySet()) {
                properMapping.put(date + " " + dates.get(date), filePaths.get(date));
            }
            Object v = CLIIOHelpers.getFileToRestore(properMapping, "", worldFile);
            if (v instanceof Path) {
                void var8_16;
                File outputFile;
                void var8_14;
                Path input = (Path)v;
                if (v.toString().replace("\\", "/").contains("-full/")) {
                    Path path = new File(v.toString().replace("\\", "/").split("-full/")[1]).toPath();
                }
                if (var8_14.toString().replace("\\", "/").contains("-partial/")) {
                    Path path = new File(var8_14.toString().replace("\\", "/").split("-partial/")[1]).toPath();
                }
                if (!(outputFile = new File(worldFile, var8_16.toString())).toPath().normalize().startsWith(worldFile.toPath())) {
                    CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                    throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + var8_16.toString());
                }
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                CLIIOHelpers.info("\n\nRestoring file : " + var8_16);
                Files.copy(input, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else if (v instanceof ZipEntry) {
                int length;
                ZipEntry entry = (ZipEntry)v;
                File outputFile = new File(worldFile, entry.toString());
                if (!outputFile.toPath().normalize().startsWith(worldFile.toPath())) {
                    CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                    throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + v.toString());
                }
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                CLIIOHelpers.info("Restoring " + entry.toString() + "...");
                byte[] buffer = new byte[1028];
                InputStream inputSteam = entryOwners.get(entry.toString()).getInputStream(entry);
                while ((length = inputSteam.read(buffer, 0, buffer.length)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void restoreFolder(int index, final File worldFile) throws IllegalBackupException {
        final File backup = new File(fileNames.get(index));
        try {
            Files.walkFileTree(backup.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    File source = backup.toPath().relativize(file).toFile();
                    File outputFile = new File(worldFile, source.getPath());
                    if (!outputFile.toPath().normalize().startsWith(worldFile.toPath())) {
                        CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                        new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + source.getPath()).printStackTrace();
                        return FileVisitResult.TERMINATE;
                    }
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    CLIIOHelpers.info("Restoring " + outputFile.getName());
                    Files.copy(file, outputFile.toPath(), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void restoreOtherModZip(File backupDir) throws IllegalBackupException {
        boolean fullWorld;
        worldFile = serverDir;
        HashMap<String, File> backups = new HashMap<String, File>();
        final HashMap entries = new HashMap();
        for (File b : backupDir.getParentFile().listFiles()) {
            if (!b.getName().endsWith("zip")) continue;
            backups.put(b.getName(), b);
        }
        String backupName = CLIIOHelpers.getSelectionFromList("Select a backup to restore from.", new ArrayList<String>(backups.keySet()));
        boolean bl = fullWorld = CLIIOHelpers.getSelectionFromList("Do you want to restore the whole world or a singular file?", Arrays.asList("Whole world", "Single file")) == "Whole world";
        if (!fullWorld) {
            if (!CLIIOHelpers.confirmWarningMessage()) {
                return;
            }
            try {
                FileSystem zipFs = FileSystems.newFileSystem(((File)backups.get(backupName)).toPath(), AdvancedBackupsCLI.class.getClassLoader());
                Path root = zipFs.getPath("", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                        entries.put(file.toString(), file);
                        return FileVisitResult.CONTINUE;
                    }
                });
                Path file = (Path)CLIIOHelpers.getFileToRestore(entries, "", worldFile);
                CLIIOHelpers.info("Restoring " + file.toString() + "...");
                Path outputFile = new File(worldFile, file.toString()).toPath();
                if (!outputFile.normalize().startsWith(worldFile.toPath())) {
                    CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                    throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + file.toString());
                }
                if (!outputFile.getParent().toFile().exists()) {
                    outputFile.getParent().toFile().mkdirs();
                }
                Files.copy(file, outputFile, StandardCopyOption.REPLACE_EXISTING);
                CLIIOHelpers.info("Done.");
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        if (!CLIIOHelpers.confirmWarningMessage()) {
            return;
        }
        final ArrayList levelDatPathWrapper = new ArrayList();
        try {
            ZipEntry entry;
            FileSystem zipFs = FileSystems.newFileSystem(((File)backups.get(backupName)).toPath(), AdvancedBackupsCLI.class.getClassLoader());
            Path root = zipFs.getPath("", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    if (file.getFileName().toString().equals("level.dat")) {
                        levelDatPathWrapper.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            Path levelDatPath = (Path)levelDatPathWrapper.get(0);
            CLIIOHelpers.info("Making backup of existing world...");
            CLIIOHelpers.info("Backup saved to : " + AdvancedBackupsCLI.deleteEntireWorld(new File(worldFile, levelDatPath.getParent().toString()), false));
            byte[] buffer = new byte[1024];
            FileInputStream fileInputStream = new FileInputStream((File)backups.get(backupName));
            ZipInputStream zip = new ZipInputStream(fileInputStream);
            while ((entry = zip.getNextEntry()) != null) {
                File outputFile = new File(worldFile, entry.getName());
                if (!outputFile.toPath().normalize().startsWith(worldFile.toPath())) {
                    zip.close();
                    CLIIOHelpers.error("Found a potentially malicious zip file - cowardly exiting, restoration may be incomplete!");
                    throw new IllegalBackupException("Zip file is likely malicious! Found an erroneus path: " + entry.getName());
                }
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                CLIIOHelpers.info("Restoring " + outputFile.toString() + "...");
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                int length = 0;
                while ((length = zip.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, length);
                }
                outputStream.close();
            }
            zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CLIIOHelpers.info("Done.");
    }

    private static String deleteEntireWorld(File worldDir, boolean exportMode) {
        String ret = AdvancedBackupsCLI.backupExistingWorld(worldDir, exportMode);
        try {
            Files.walkFileTree(worldDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    file.toFile().delete();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path file, IOException arg1) {
                    if (file.toFile().listFiles().length == 0) {
                        file.toFile().delete();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            CLIIOHelpers.warn("Failed to delete file :");
            e.printStackTrace();
        }
        return ret;
    }

    private static String backupExistingWorld(final File worldDir, boolean export) {
        File out = new File(worldDir, "../cli" + AdvancedBackupsCLI.serialiseBackupName(export ? "export" : "backup") + ".zip");
        try {
            FileOutputStream outputStream = new FileOutputStream(out);
            final ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            zipOutputStream.setLevel(4);
            Files.walkFileTree(worldDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    try {
                        Path targetFile = worldDir.toPath().relativize(file);
                        if (targetFile.toFile().getName().compareTo("session.lock") == 0) {
                            return FileVisitResult.CONTINUE;
                        }
                        zipOutputStream.putNextEntry(new ZipEntry(targetFile.toString()));
                        byte[] bytes = Files.readAllBytes(file);
                        zipOutputStream.write(bytes, 0, bytes.length);
                        zipOutputStream.closeEntry();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            zipOutputStream.flush();
            zipOutputStream.close();
            CLIIOHelpers.info("Done.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out.getName();
    }

    private static void addBackupNamesToLists(final File file, HashMap<String, ZipFile> entryOwners, final HashMap<String, Object> filePaths, final HashMap<String, String> dates, String colour) throws IOException {
        if (file.isFile()) {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
            while (entryEnum.hasMoreElements()) {
                ZipEntry entry = entryEnum.nextElement();
                String backupName = file.toString().replace("\\", "/");
                filePaths.put(entry.toString().replace("\\", "/"), entry);
                dates.put(entry.toString().replace("\\", "/"), "\u001b[31m" + backupName.substring(backupName.toString().lastIndexOf("/") + 1).replace("backup_", "").replace("-full.zip", "").replace("-partial.zip", "") + "\u001b[0m");
                entryOwners.put(entry.toString(), zipFile);
            }
        } else {
            Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                    String backupName = file.toString().replace("\\", "/");
                    filePaths.put(file.toPath().relativize(path).toString().replace("\\", "/"), path);
                    dates.put(file.toPath().relativize(path).toString().replace("\\", "/"), "\u001b[31m" + backupName.substring(backupName.toString().lastIndexOf("/") + 1).replace("backup_", "").replace("-full", "").replace("-partial", "") + "\u001b[0m");
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static String serialiseBackupName(String in) {
        Date date = new Date();
        String pattern = "yyyy-MM-dd_HH-mm-ss";
        return in + "_" + new SimpleDateFormat(pattern).format(date);
    }

    static {
        serverDir = new File(new File("").toPath().toAbsolutePath().getParent().toString());
        fileNames = new ArrayList();
    }
}

