/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.level.features;

import andrews.swampier_swamps.registry.SSTags;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MudPuddleFeature
extends Feature<NoneFeatureConfiguration> {
    public MudPuddleFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int waterZOffset;
        int waterXOffset;
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        if (pos.m_123342_() <= level.m_141937_() + 4) {
            return false;
        }
        pos = pos.m_6625_(4);
        boolean[] withinRange = new boolean[2048];
        int i = rand.m_188503_(4) + 4;
        for (int j = 0; j < i; ++j) {
            double xMin = rand.m_188500_() * 6.0 + 3.0;
            double yMin = rand.m_188500_() * 4.0 + 2.0;
            double zMin = rand.m_188500_() * 6.0 + 3.0;
            double xMax = rand.m_188500_() * (16.0 - xMin - 2.0) + 1.0 + xMin / 2.0;
            double yMax = rand.m_188500_() * (8.0 - yMin - 4.0) + 2.0 + yMin / 2.0;
            double zmax = rand.m_188500_() * (16.0 - zMin - 2.0) + 1.0 + zMin / 2.0;
            for (int xOffset = 1; xOffset < 15; ++xOffset) {
                double deltaX = ((double)xOffset - xMax) / (xMin / 2.0);
                for (int zOffset = 1; zOffset < 15; ++zOffset) {
                    double deltaZ = ((double)zOffset - zmax) / (zMin / 2.0);
                    for (int yOffset = 1; yOffset < 7; ++yOffset) {
                        double deltaY = ((double)yOffset - yMax) / (yMin / 2.0);
                        double range = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                        if (!(range < 1.0)) continue;
                        withinRange[(xOffset * 16 + zOffset) * 8 + yOffset] = true;
                    }
                }
            }
        }
        BlockState waterState = Blocks.f_49990_.m_49966_();
        for (waterXOffset = 0; waterXOffset < 16; ++waterXOffset) {
            for (waterZOffset = 0; waterZOffset < 16; ++waterZOffset) {
                for (int waterYOffset = 0; waterYOffset < 8; ++waterYOffset) {
                    boolean flag;
                    boolean bl = flag = !withinRange[(waterXOffset * 16 + waterZOffset) * 8 + waterYOffset] && (waterXOffset < 15 && withinRange[((waterXOffset + 1) * 16 + waterZOffset) * 8 + waterYOffset] || waterXOffset > 0 && withinRange[((waterXOffset - 1) * 16 + waterZOffset) * 8 + waterYOffset] || waterZOffset < 15 && withinRange[(waterXOffset * 16 + waterZOffset + 1) * 8 + waterYOffset] || waterZOffset > 0 && withinRange[(waterXOffset * 16 + (waterZOffset - 1)) * 8 + waterYOffset] || waterYOffset < 7 && withinRange[(waterXOffset * 16 + waterZOffset) * 8 + waterYOffset + 1] || waterYOffset > 0 && withinRange[(waterXOffset * 16 + waterZOffset) * 8 + (waterYOffset - 1)]);
                    if (!flag) continue;
                    BlockState state = level.m_8055_(pos.m_7918_(waterXOffset, waterYOffset, waterZOffset));
                    if (waterYOffset >= 4 && state.m_278721_()) {
                        return false;
                    }
                    if (waterYOffset >= 4 || state.m_280296_() || level.m_8055_(pos.m_7918_(waterXOffset, waterYOffset, waterZOffset)) == waterState) continue;
                    return false;
                }
            }
        }
        for (waterXOffset = 0; waterXOffset < 16; ++waterXOffset) {
            for (waterZOffset = 0; waterZOffset < 16; ++waterZOffset) {
                for (int waterYOffset = 0; waterYOffset < 8; ++waterYOffset) {
                    BlockPos posAtTarget;
                    if (!withinRange[(waterXOffset * 16 + waterZOffset) * 8 + waterYOffset] || !this.canReplaceBlock(level.m_8055_(posAtTarget = pos.m_7918_(waterXOffset, waterYOffset, waterZOffset)))) continue;
                    boolean placeAir = waterYOffset >= 4;
                    level.m_7731_(posAtTarget, placeAir ? Blocks.f_50016_.m_49966_() : waterState, 2);
                    if (level.m_8055_(posAtTarget.m_7494_()).m_60713_(Blocks.f_49999_) && level.m_8055_(posAtTarget.m_7494_()).m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y) {
                        BlockPos extraLogsPos = posAtTarget;
                        while (!level.m_8055_(extraLogsPos).m_280296_()) {
                            level.m_7731_(extraLogsPos, Blocks.f_49999_.m_49966_(), 2);
                            extraLogsPos = extraLogsPos.m_7495_();
                        }
                        continue;
                    }
                    if (!placeAir) continue;
                    level.m_186460_(posAtTarget, Blocks.f_50016_, 0);
                    this.m_159739_(level, posAtTarget);
                }
            }
        }
        BlockState mudState = Blocks.f_220864_.m_49966_();
        BlockState mudRootState = Blocks.f_220834_.m_49966_();
        for (int mudXOffset = 0; mudXOffset < 16; ++mudXOffset) {
            for (int mudZOffset = 0; mudZOffset < 16; ++mudZOffset) {
                for (int mudYOffset = 0; mudYOffset < 8; ++mudYOffset) {
                    BlockState stateAtTarget;
                    boolean flag2;
                    boolean bl = flag2 = !withinRange[(mudXOffset * 16 + mudZOffset) * 8 + mudYOffset] && (mudXOffset < 15 && withinRange[((mudXOffset + 1) * 16 + mudZOffset) * 8 + mudYOffset] || mudXOffset > 0 && withinRange[((mudXOffset - 1) * 16 + mudZOffset) * 8 + mudYOffset] || mudZOffset < 15 && withinRange[(mudXOffset * 16 + mudZOffset + 1) * 8 + mudYOffset] || mudZOffset > 0 && withinRange[(mudXOffset * 16 + (mudZOffset - 1)) * 8 + mudYOffset] || mudYOffset < 7 && withinRange[(mudXOffset * 16 + mudZOffset) * 8 + mudYOffset + 1] || mudYOffset > 0 && withinRange[(mudXOffset * 16 + mudZOffset) * 8 + (mudYOffset - 1)]);
                    if (!flag2 || mudYOffset >= 4 && rand.m_188503_(2) == 0 || !(stateAtTarget = level.m_8055_(pos.m_7918_(mudXOffset, mudYOffset, mudZOffset))).m_280296_() || stateAtTarget.m_204336_(BlockTags.f_144288_)) continue;
                    for (int j = 0; j < 5; ++j) {
                        int zRimOffset;
                        int xRimOffset = rand.m_188503_(4) - rand.m_188503_(4);
                        BlockPos fadeInPos = pos.m_7918_(mudXOffset + xRimOffset, mudYOffset, mudZOffset + (zRimOffset = rand.m_188503_(4) - rand.m_188503_(4)));
                        BlockState stateAtRim = level.m_8055_(fadeInPos);
                        if (!stateAtRim.m_204336_(SSTags.Blocks.MUD_PUDDLE_CAN_REPLACE)) continue;
                        level.m_7731_(fadeInPos, rand.m_188503_(15) == 0 ? mudRootState : mudState, 2);
                        this.m_159739_(level, fadeInPos);
                    }
                    BlockPos posAtTarget = pos.m_7918_(mudXOffset, mudYOffset, mudZOffset);
                    if (!level.m_8055_(posAtTarget).m_204336_(SSTags.Blocks.MUD_PUDDLE_CAN_REPLACE)) continue;
                    level.m_7731_(posAtTarget, rand.m_188503_(15) == 0 ? mudRootState : mudState, 2);
                    this.m_159739_(level, posAtTarget);
                }
            }
        }
        if (waterState.m_60819_().m_205070_(FluidTags.f_13131_)) {
            for (int freezingXOffset = 0; freezingXOffset < 16; ++freezingXOffset) {
                for (int freezingZOffset = 0; freezingZOffset < 16; ++freezingZOffset) {
                    BlockPos waterSurfacePos = pos.m_7918_(freezingXOffset, 4, freezingZOffset);
                    if (!((Biome)level.m_204166_(waterSurfacePos).m_203334_()).m_47480_((LevelReader)level, waterSurfacePos, false) || !this.canReplaceBlock(level.m_8055_(waterSurfacePos))) continue;
                    level.m_7731_(waterSurfacePos, Blocks.f_50126_.m_49966_(), 2);
                }
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockState state) {
        return state.m_204336_(SSTags.Blocks.MUD_PUDDLE_CAN_REPLACE);
    }
}

