/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.objects.blocks;

import andrews.swampier_swamps.config.SSConfigs;
import andrews.swampier_swamps.network.NetworkUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SinkingLilyPad
extends WaterlilyBlock {
    public static final IntegerProperty SINK_STAGE = IntegerProperty.m_61631_((String)"sink_stage", (int)0, (int)2);
    private static final Map<Integer, VoxelShape> AABB_SHAPES = ImmutableMap.of((Object)0, (Object)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0), (Object)1, (Object)Block.m_49796_((double)1.0, (double)-1.5, (double)1.0, (double)15.0, (double)0.0, (double)15.0), (Object)2, (Object)Block.m_49796_((double)1.0, (double)-3.0, (double)1.0, (double)15.0, (double)-1.5, (double)15.0));

    public SinkingLilyPad(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SINK_STAGE, (Comparable)Integer.valueOf(0)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level instanceof ServerLevel && (Integer)state.m_61143_((Property)SINK_STAGE) <= 0) {
            level.m_186460_(pos, (Block)this, SSConfigs.commonConfig.lilyPadSinkTimeStage1.get().intValue());
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int sinkStage = (Integer)state.m_61143_((Property)SINK_STAGE);
        VoxelShape shape = AABB_SHAPES.get(sinkStage);
        return SSConfigs.commonConfig.doLilyPadsBreak.get() != false ? shape : (sinkStage == 2 ? Shapes.m_83040_() : shape);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        switch ((Integer)state.m_61143_((Property)SINK_STAGE)) {
            case 0: {
                if (this.getLivingEntitiesAtPos((Level)level, pos) > 0) {
                    this.setNextSinkStage(level, pos, 1, SSConfigs.commonConfig.lilyPadSinkTimeStage2.get());
                    break;
                }
                level.m_7731_(pos, Blocks.f_50196_.m_49966_(), 2);
                break;
            }
            case 1: {
                if (this.getLivingEntitiesAtPos((Level)level, pos) > 0) {
                    this.setNextSinkStage(level, pos, 2, SSConfigs.commonConfig.lilyPadSinkTimeStage3.get());
                    break;
                }
                level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)SINK_STAGE, (Comparable)Integer.valueOf(0)), 2);
                level.m_186460_(pos, (Block)this, SSConfigs.commonConfig.lilyPadResetTime.get().intValue());
                break;
            }
            case 2: {
                if (this.getLivingEntitiesAtPos((Level)level, pos) > 0) {
                    if (SSConfigs.commonConfig.doLilyPadsBreak.get().booleanValue()) {
                        level.m_46961_(pos, true);
                        break;
                    }
                    level.m_186460_(pos, (Block)this, SSConfigs.commonConfig.lilyPadResetTime.get().intValue());
                    break;
                }
                level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)SINK_STAGE, (Comparable)Integer.valueOf(1)), 2);
                level.m_186460_(pos, (Block)this, SSConfigs.commonConfig.lilyPadResetTime.get().intValue());
            }
        }
    }

    private int getLivingEntitiesAtPos(Level level, BlockPos pos) {
        int livingEntityCount = 0;
        for (Entity entity : level.m_45933_(null, new AABB((double)pos.m_123341_() + 0.0625, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.0625, (double)pos.m_123341_() + 0.9375, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.9375))) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !((livingEntity = (LivingEntity)entity).m_20206_() > 1.2f) || !livingEntity.m_20096_() && !livingEntity.m_20069_() || !(livingEntity.m_20182_().f_82480_ > (double)((float)pos.m_7495_().m_123342_() + 0.6875f)) && SSConfigs.commonConfig.doLilyPadsBreak.get().booleanValue()) continue;
            ++livingEntityCount;
        }
        return livingEntityCount;
    }

    private boolean canEntitySink(BlockPos pos, Entity entity) {
        return entity.m_20096_() && entity.m_20182_().f_82480_ > (double)pos.m_123342_() + 0.6875;
    }

    private void setNextSinkStage(ServerLevel level, BlockPos pos, int stage, int ticks) {
        NetworkUtil.createSplashParticlesAtPos((Level)level, pos);
        level.m_5594_(null, pos, SoundEvents.f_12277_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)SINK_STAGE, (Comparable)Integer.valueOf(stage)), 2);
        level.m_186460_(pos, (Block)this, ticks);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{SINK_STAGE});
    }
}

